/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.structure;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.ASN1UTCTime;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.cms.CMSAttributes;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.cms.SignedData;
import cn.org.bjca.gaia.asn1.pkcs.Attribute;
import cn.org.bjca.gaia.asn1.pkcs.SignerInfo;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import java.util.Date;
import java.util.Enumeration;

public class BjcaPkcs7Sign {
    private SignedData signedData = null;

    public BjcaPkcs7Sign(byte[] pkcs7Sign) throws PkiException {
        try {
            ContentInfo info = ContentInfo.getInstance(ASN1Util.checkAndGetASN1Object(pkcs7Sign));
            this.signedData = SignedData.getInstance(info.getContent());
        }
        catch (Exception e) {
            throw new PkiException("11008003", "\u6784\u9020pkcs7\u7b7e\u540d\u5931\u8d25", e);
        }
    }

    public byte[] getOriData() {
        byte[] ori = null;
        ASN1Encodable content = this.signedData.getEncapContentInfo().getContent();
        if (content != null) {
            DEROctetString contentOct = (DEROctetString)content;
            ori = contentOct.getOctets();
        }
        return ori;
    }

    public byte[] getSignValue() {
        Enumeration signerInfoEnum = this.signedData.getSignerInfos().getObjects();
        ASN1Sequence signerInfoSeq = (ASN1Sequence)signerInfoEnum.nextElement();
        SignerInfo signerInfo = SignerInfo.getInstance(signerInfoSeq);
        return signerInfo.getEncryptedDigest().getOctets();
    }

    public byte[] getSignCert() throws PkiException {
        byte[] signCertBytes = null;
        try {
            Enumeration certEnum = this.signedData.getCertificates().getObjects();
            ASN1Sequence certSeq = (ASN1Sequence)certEnum.nextElement();
            Certificate signCert = Certificate.getInstance(certSeq);
            signCertBytes = signCert.getEncoded();
        }
        catch (Exception e) {
            throw new PkiException("11008004", "\u89e3\u6790pkcs7\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25", e);
        }
        return signCertBytes;
    }

    public byte[] getAttributeSignHash() throws PkiException {
        byte[] hash = null;
        try {
            Enumeration signerInfoEnum = this.signedData.getSignerInfos().getObjects();
            ASN1Sequence signerInfoSeq = (ASN1Sequence)signerInfoEnum.nextElement();
            SignerInfo signerInfo = SignerInfo.getInstance(signerInfoSeq);
            ASN1Set attriSet = signerInfo.getAuthenticatedAttributes();
            if (attriSet != null) {
                Enumeration atrrEnum = attriSet.getObjects();
                while (atrrEnum.hasMoreElements()) {
                    ASN1Sequence atrrSeq = (ASN1Sequence)atrrEnum.nextElement();
                    Attribute atrrObject = Attribute.getInstance(atrrSeq);
                    if (!CMSAttributes.messageDigest.getId().equals(atrrObject.getAttrType().getId())) continue;
                    ASN1Set attriValueSet = atrrObject.getAttrValues();
                    Enumeration atrrValueEnum = attriValueSet.getObjects();
                    DEROctetString atrrValue = (DEROctetString)atrrValueEnum.nextElement();
                    hash = atrrValue.getOctets();
                }
            }
        }
        catch (Exception e) {
            throw new PkiException("11008005", "\u89e3\u6790pkcs7\u5c5e\u6027\u7b7e\u540d\u6458\u8981\u503c\u5931\u8d25", e);
        }
        return hash;
    }

    public Date getAttributeSignTime() throws PkiException {
        Date time = null;
        try {
            Enumeration signerInfoEnum = this.signedData.getSignerInfos().getObjects();
            ASN1Sequence signerInfoSeq = (ASN1Sequence)signerInfoEnum.nextElement();
            SignerInfo signerInfo = SignerInfo.getInstance(signerInfoSeq);
            ASN1Set attriSet = signerInfo.getAuthenticatedAttributes();
            if (attriSet != null) {
                Enumeration atrrEnum = attriSet.getObjects();
                while (atrrEnum.hasMoreElements()) {
                    ASN1Sequence atrrSeq = (ASN1Sequence)atrrEnum.nextElement();
                    Attribute atrrOb = Attribute.getInstance(atrrSeq);
                    if (!atrrOb.getAttrType().getId().equals(CMSAttributes.signingTime.getId())) continue;
                    ASN1Set attriValueSet = atrrOb.getAttrValues();
                    Enumeration atrrValueEnum = attriValueSet.getObjects();
                    ASN1UTCTime atrrValue = (ASN1UTCTime)atrrValueEnum.nextElement();
                    time = atrrValue.getDate();
                }
            }
        }
        catch (Exception e) {
            throw new PkiException("11008006", "\u89e3\u6790pkcs7\u5c5e\u6027\u7b7e\u540d\u65f6\u95f4\u5931\u8d25", e);
        }
        return time;
    }
}

