/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSet;
import cn.org.bjca.gaia.asn1.cms.CMSAttributes;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.cms.SignedData;
import cn.org.bjca.gaia.asn1.cms.Time;
import cn.org.bjca.gaia.asn1.pkcs.Attribute;
import cn.org.bjca.gaia.asn1.pkcs.SignerInfo;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.cert.BjcaCert;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.generator.Pkcs7Generator;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.structure.BjcaPkcs7Sign;
import cn.org.bjca.gaia.assemb.util.ASN1Util;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;

public class Pkcs7Util {
    private GaiaProvider provider = null;

    public Pkcs7Util(GaiaProvider provider) {
        this.provider = provider;
    }

    public byte[] pkcs7Sign(AlgPolicy algPolicy, BjcaKey bjcaKey, String signCert, byte[] dataInput, boolean isAttach) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SM3WithSM2") || policyType.equals("SHA256WithRSA") || policyType.equals("SHA1WithRSA"))) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[] p7SignData = null;
        try {
            byte[] signCertBytes = Base64.decode(signCert);
            ASN1Object signCertPkcs = ASN1Util.checkAndGetASN1Object(signCertBytes);
            Certificate signCertOb = Certificate.getInstance(signCertPkcs);
            Certificate[] certs = new Certificate[]{signCertOb};
            AlgPolicy hashPolicy = this.getHashPolicy(policyType, signCertBytes);
            byte[] hash = this.provider.hash(hashPolicy, dataInput);
            byte[] signedBuf = this.provider.signHashedData(algPolicy, hash, bjcaKey);
            Pkcs7Generator pkcs7Generator = new Pkcs7Generator();
            p7SignData = isAttach ? pkcs7Generator.getEncoded(algPolicy, certs, null, signedBuf, dataInput) : pkcs7Generator.getEncoded(algPolicy, certs, null, signedBuf, null);
        }
        catch (Exception e) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 ", e);
        }
        return p7SignData;
    }

    public byte[] verifyPkcs7Sign(byte[] signValue, byte[] inputData) throws PkiException {
        byte[] retCert = null;
        try {
            ContentInfo info = ContentInfo.getInstance(ASN1Util.checkAndGetASN1Object(signValue));
            SignedData sData = SignedData.getInstance(info.getContent());
            Enumeration certEnum = sData.getCertificates().getObjects();
            ASN1Sequence certSeq = (ASN1Sequence)certEnum.nextElement();
            Certificate signCert = Certificate.getInstance(certSeq);
            BjcaCert signCertOb = new BjcaCert(signCert);
            Enumeration signerInfoEnum = sData.getSignerInfos().getObjects();
            ASN1Sequence signerInfoSeq = (ASN1Sequence)signerInfoEnum.nextElement();
            SignerInfo signerInfo = SignerInfo.getInstance(signerInfoSeq);
            ASN1ObjectIdentifier digestOid = signerInfo.getDigestAlgorithm().getAlgorithm();
            String hashAlg = AlgConstant.convertOidToAlgName(digestOid);
            if (hashAlg.equals("HMac-SM3")) {
                hashAlg = "SM3";
            }
            String signAlg = AlgConstant.convertHashAlgToSignAlg(hashAlg);
            byte[] pubKey = signCertOb.getPublicKeyData();
            byte[] sign = signerInfo.getEncryptedDigest().getOctets();
            byte[] ori = null;
            ASN1Encodable content = sData.getEncapContentInfo().getContent();
            if (content == null) {
                if (inputData == null) {
                    throw new PkiException("11008002", "pkcs7\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25 \u7f3a\u5c11\u64cd\u4f5c\u53c2\u6570\u9519\u8bef p7detachSign need content\uff01");
                }
                ori = inputData;
            } else {
                DEROctetString contentOct = (DEROctetString)content;
                ori = contentOct.getOctets();
            }
            AlgPolicy hashPolicy = null;
            AlgPolicy algPolicy = new AlgPolicy(signAlg);
            BjcaKey bjcaKey = null;
            if ("SM3".equals(hashAlg)) {
                SM3Param sm3Param = new SM3Param(pubKey);
                hashPolicy = new AlgPolicy(hashAlg, sm3Param);
                bjcaKey = new BjcaKey("SM2_Public", pubKey);
            } else {
                hashPolicy = new AlgPolicy(hashAlg);
                bjcaKey = new BjcaKey("RSA_Public", pubKey);
            }
            byte[] hash = this.provider.hash(hashPolicy, ori);
            boolean ret = this.provider.verifySignHashedData(algPolicy, hash, sign, bjcaKey);
            if (ret) {
                retCert = signCert.getEncoded();
            }
        }
        catch (Exception e) {
            throw new PkiException("11008002", "pkcs7\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25 ", e);
        }
        return retCert;
    }

    public byte[] pkcs7SignDigest(AlgPolicy algPolicy, BjcaKey bjcaKey, String signCert, byte[] hashedData, boolean isAttributeSign) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SM3WithSM2") || policyType.equals("SHA256WithRSA") || policyType.equals("SHA1WithRSA"))) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[] p7SignData = null;
        try {
            byte[] signCertBytes = Base64.decode(signCert);
            ASN1Object signCertPkcs = ASN1Util.checkAndGetASN1Object(signCertBytes);
            Certificate signCertOb = Certificate.getInstance(signCertPkcs);
            Certificate[] certs = new Certificate[]{signCertOb};
            byte[] signedBuf = null;
            Pkcs7Generator pkcs7Generator = new Pkcs7Generator();
            if (isAttributeSign) {
                ASN1ObjectIdentifier dataOid = AlgConstant.convertAlgToPkcs7DataOid(policyType);
                ASN1EncodableVector attributeVector = this.getAttrV(dataOid, hashedData);
                DERSet derRSet = new DERSet(attributeVector);
                byte[] attributesByte = derRSet.getEncoded();
                AlgPolicy hashPolicy = this.getHashPolicy(policyType, signCertBytes);
                byte[] hash = this.provider.hash(hashPolicy, attributesByte);
                signedBuf = this.provider.signHashedData(algPolicy, hash, bjcaKey);
                p7SignData = pkcs7Generator.getAttributeEncoded(algPolicy, certs, null, signedBuf, attributeVector);
            } else {
                signedBuf = this.provider.signHashedData(algPolicy, hashedData, bjcaKey);
                p7SignData = pkcs7Generator.getEncoded(algPolicy, certs, null, signedBuf, null);
            }
        }
        catch (Exception e) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 ", e);
        }
        return p7SignData;
    }

    public byte[] verifyPkcs7SignDigest(byte[] signValue, byte[] hashedData) throws PkiException {
        byte[] retCert = null;
        try {
            boolean ret;
            ContentInfo info = ContentInfo.getInstance(ASN1Util.checkAndGetASN1Object(signValue));
            SignedData sData = SignedData.getInstance(info.getContent());
            Enumeration certEnum = sData.getCertificates().getObjects();
            ASN1Sequence certSeq = (ASN1Sequence)certEnum.nextElement();
            Certificate signCert = Certificate.getInstance(certSeq);
            BjcaCert signCertOb = new BjcaCert(signCert);
            Enumeration signerInfoEnum = sData.getSignerInfos().getObjects();
            ASN1Sequence signerInfoSeq = (ASN1Sequence)signerInfoEnum.nextElement();
            SignerInfo signerInfo = SignerInfo.getInstance(signerInfoSeq);
            ASN1ObjectIdentifier digestOid = signerInfo.getDigestAlgorithm().getAlgorithm();
            String hashAlg = AlgConstant.convertOidToAlgName(digestOid);
            if (hashAlg.equals("HMac-SM3")) {
                hashAlg = "SM3";
            }
            String signAlg = AlgConstant.convertHashAlgToSignAlg(hashAlg);
            byte[] pubKey = signCertOb.getPublicKeyData();
            byte[] sign = signerInfo.getEncryptedDigest().getOctets();
            byte[] ori = null;
            AlgPolicy algPolicy = new AlgPolicy(signAlg);
            BjcaKey bjcaKey = null;
            bjcaKey = "SM3".equals(hashAlg) ? new BjcaKey("SM2_Public", pubKey) : new BjcaKey("RSA_Public", pubKey);
            ASN1Set attriSet = signerInfo.getAuthenticatedAttributes();
            if (attriSet != null) {
                byte[] hash = null;
                Enumeration atrrEnum = attriSet.getObjects();
                while (atrrEnum.hasMoreElements()) {
                    ASN1Sequence atrrSeq = (ASN1Sequence)atrrEnum.nextElement();
                    Attribute atrrOb = Attribute.getInstance(atrrSeq);
                    if (!atrrOb.getAttrType().getId().equals(CMSAttributes.messageDigest.getId())) continue;
                    ASN1Set attriValueSet = atrrOb.getAttrValues();
                    Enumeration atrrValueEnum = attriValueSet.getObjects();
                    DEROctetString atrrValue = (DEROctetString)atrrValueEnum.nextElement();
                    hash = atrrValue.getOctets();
                }
                if (!Arrays.equals(hashedData, hash)) {
                    return null;
                }
                byte[] atrri = attriSet.getEncoded();
                AlgPolicy hashPolicy = null;
                if ("SM3".equals(hashAlg)) {
                    SM3Param sm3Param = new SM3Param(pubKey);
                    hashPolicy = new AlgPolicy(hashAlg, sm3Param);
                } else {
                    hashPolicy = new AlgPolicy(hashAlg);
                }
                ori = this.provider.hash(hashPolicy, atrri);
            } else {
                ori = hashedData;
            }
            if (sign == null || sign.length == 0) {
                // empty if block
            }
            if (ret = this.provider.verifySignHashedData(algPolicy, ori, sign, bjcaKey)) {
                retCert = signCert.getEncoded();
            }
        }
        catch (Exception e) {
            throw new PkiException("11008002", "pkcs7\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25 ", e);
        }
        return retCert;
    }

    public byte[] assembPkcs7Sign(AlgPolicy algPolicy, byte[] p1Sign, String signCert, byte[] dataInput, boolean isAttach) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SM3WithSM2") || policyType.equals("SHA256WithRSA") || policyType.equals("SHA1WithRSA"))) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[] p7SignData = null;
        try {
            byte[] signCertBytes = Base64.decode(signCert);
            ASN1Object signCertPkcs = ASN1Util.checkAndGetASN1Object(signCertBytes);
            Certificate signCertOb = Certificate.getInstance(signCertPkcs);
            Certificate[] certs = new Certificate[]{signCertOb};
            Pkcs7Generator pkcs7Generator = new Pkcs7Generator();
            p7SignData = isAttach ? pkcs7Generator.getEncoded(algPolicy, certs, null, p1Sign, dataInput) : pkcs7Generator.getEncoded(algPolicy, certs, null, p1Sign, null);
        }
        catch (Exception e) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 ", e);
        }
        return p7SignData;
    }

    public byte[] assembPkcs7SignDigest(AlgPolicy algPolicy, String signCert, byte[] p1Sign, byte[] assembPlainText, boolean isAttributeSign) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        if (!(policyType.equals("SM3WithSM2") || policyType.equals("SHA256WithRSA") || policyType.equals("SHA1WithRSA"))) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 \u6a21\u5757\u4e0d\u652f\u6301\u6b64\u79cd\u64cd\u4f5c " + policyType);
        }
        byte[] p7SignData = null;
        try {
            byte[] signCertBytes = Base64.decode(signCert);
            ASN1Object signCertPkcs = ASN1Util.checkAndGetASN1Object(signCertBytes);
            Certificate signCertOb = Certificate.getInstance(signCertPkcs);
            Certificate[] certs = new Certificate[]{signCertOb};
            Pkcs7Generator pkcs7Generator = new Pkcs7Generator();
            if (isAttributeSign) {
                ASN1EncodableVector attributeVector = this.getAttrVFromAssembPlainText(assembPlainText);
                p7SignData = pkcs7Generator.getAttributeEncoded(algPolicy, certs, null, p1Sign, attributeVector);
            } else {
                p7SignData = pkcs7Generator.getEncoded(algPolicy, certs, null, p1Sign, null);
            }
        }
        catch (Exception e) {
            throw new PkiException("11008001", "pkcs7\u7b7e\u540d\u5931\u8d25 ", e);
        }
        return p7SignData;
    }

    public BjcaPkcs7Sign parseP7Structure(byte[] signValue) throws PkiException {
        BjcaPkcs7Sign bjcaPkcs7Sign = new BjcaPkcs7Sign(signValue);
        return bjcaPkcs7Sign;
    }

    private AlgPolicy getHashPolicy(String policyType, byte[] signCertBytes) throws Exception {
        AlgPolicy hashPolicy = null;
        String hashAlg = AlgConstant.convertSignAlgToHashAlg(policyType);
        if ("SM3".equals(hashAlg)) {
            BjcaCert signCertOb = new BjcaCert(signCertBytes);
            byte[] pubkey = signCertOb.getPublicKeyData();
            SM3Param sm3Param = new SM3Param(pubkey);
            hashPolicy = new AlgPolicy(hashAlg, sm3Param);
        } else {
            hashPolicy = new AlgPolicy(hashAlg);
        }
        return hashPolicy;
    }

    public byte[] assembPlainText(AlgPolicy algPolicy, byte[] hashedData) throws PkiException {
        String policyType = algPolicy.getPolicyType();
        ASN1ObjectIdentifier dataOid = AlgConstant.convertAlgToPkcs7DataOid(policyType);
        ASN1EncodableVector attributeVector = this.getAttrV(dataOid, hashedData);
        DERSet derRSet = new DERSet(attributeVector);
        byte[] attributesByte = new byte[]{};
        try {
            attributesByte = derRSet.getEncoded();
        }
        catch (IOException e) {
            throw new PkiException("11008007", "\u6784\u9020p7\u5c5e\u6027\u7b7e\u540d\u539f\u6587\u5931\u8d25 ", e);
        }
        return attributesByte;
    }

    private ASN1EncodableVector getAttrVFromAssembPlainText(byte[] assembPlainText) throws PkiException {
        ASN1Object asn1Object = ASN1Util.checkAndGetASN1Object(assembPlainText);
        DERSet derRSet = new DERSet(asn1Object.toASN1Primitive());
        ASN1Set derRSet1 = (ASN1Set)derRSet.getObjectAt(0);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(derRSet1.getObjectAt(0));
        vector.add(derRSet1.getObjectAt(1));
        vector.add(derRSet1.getObjectAt(2));
        return vector;
    }

    private ASN1EncodableVector getAttrV(ASN1ObjectIdentifier dataOid, byte[] hashedData) {
        ASN1EncodableVector attributeVector = new ASN1EncodableVector();
        Attribute[] attributes = new Attribute[]{new Attribute(CMSAttributes.contentType, new DERSet(dataOid)), new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date()))), new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString(hashedData)))};
        attributeVector.add(attributes[0]);
        attributeVector.add(attributes[1]);
        attributeVector.add(attributes[2]);
        return attributeVector;
    }
}

