/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms;

import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.cms.KEKIdentifier;
import cn.org.bjca.gaia.asn1.cms.KEKRecipientInfo;
import cn.org.bjca.gaia.asn1.cms.RecipientInfo;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.RecipientInfoGenerator;
import cn.org.bjca.gaia.operator.GenericKey;
import cn.org.bjca.gaia.operator.OperatorException;
import cn.org.bjca.gaia.operator.SymmetricKeyWrapper;

public abstract class KEKRecipientInfoGenerator
implements RecipientInfoGenerator {
    private final KEKIdentifier kekIdentifier;
    protected final SymmetricKeyWrapper wrapper;

    protected KEKRecipientInfoGenerator(KEKIdentifier kekIdentifier, SymmetricKeyWrapper wrapper) {
        this.kekIdentifier = kekIdentifier;
        this.wrapper = wrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey contentEncryptionKey) throws CMSException {
        try {
            DEROctetString encryptedKey = new DEROctetString(this.wrapper.generateWrappedKey(contentEncryptionKey));
            return new RecipientInfo(new KEKRecipientInfo(this.kekIdentifier, this.wrapper.getAlgorithmIdentifier(), encryptedKey));
        }
        catch (OperatorException e) {
            throw new CMSException("exception wrapping content key: " + e.getMessage(), e);
        }
    }
}

