/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms.jcajce;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.jcajce.CMSUtils;
import cn.org.bjca.gaia.cms.jcajce.DefaultJcaJceExtHelper;
import cn.org.bjca.gaia.cms.jcajce.EnvelopedDataHelper;
import cn.org.bjca.gaia.cms.jcajce.NamedJcaJceExtHelper;
import cn.org.bjca.gaia.cms.jcajce.ProviderJcaJceExtHelper;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;

public class JceAlgorithmIdentifierConverter {
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;

    public JceAlgorithmIdentifierConverter setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceAlgorithmIdentifierConverter setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public AlgorithmParameters getAlgorithmParameters(AlgorithmIdentifier algorithmIdentifier) throws CMSException {
        ASN1Encodable parameters = algorithmIdentifier.getParameters();
        if (parameters == null) {
            return null;
        }
        try {
            AlgorithmParameters params = this.helper.createAlgorithmParameters(algorithmIdentifier.getAlgorithm());
            CMSUtils.loadParameters(params, algorithmIdentifier.getParameters());
            return params;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find parameters for algorithm", e);
        }
        catch (NoSuchProviderException e) {
            throw new CMSException("can't find provider for algorithm", e);
        }
    }
}

