/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.dvcs;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.cms.SignedData;
import cn.org.bjca.gaia.asn1.dvcs.DVCSObjectIdentifiers;
import cn.org.bjca.gaia.cms.CMSSignedData;
import cn.org.bjca.gaia.dvcs.DVCSConstructionException;
import cn.org.bjca.gaia.dvcs.DVCSMessage;

public class DVCSResponse
extends DVCSMessage {
    private cn.org.bjca.gaia.asn1.dvcs.DVCSResponse asn1;

    public DVCSResponse(CMSSignedData signedData) throws DVCSConstructionException {
        this(SignedData.getInstance(signedData.toASN1Structure().getContent()).getEncapContentInfo());
    }

    public DVCSResponse(ContentInfo contentInfo) throws DVCSConstructionException {
        super(contentInfo);
        if (!DVCSObjectIdentifiers.id_ct_DVCSResponseData.equals(contentInfo.getContentType())) {
            throw new DVCSConstructionException("ContentInfo not a DVCS Response");
        }
        try {
            this.asn1 = contentInfo.getContent().toASN1Primitive() instanceof ASN1Sequence ? cn.org.bjca.gaia.asn1.dvcs.DVCSResponse.getInstance(contentInfo.getContent()) : cn.org.bjca.gaia.asn1.dvcs.DVCSResponse.getInstance(ASN1OctetString.getInstance(contentInfo.getContent()).getOctets());
        }
        catch (Exception e) {
            throw new DVCSConstructionException("Unable to parse content: " + e.getMessage(), e);
        }
    }

    @Override
    public ASN1Encodable getContent() {
        return this.asn1;
    }
}

