/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.provider.symmetric;

import cn.org.bjca.gaia.crypto.CipherKeyGenerator;
import cn.org.bjca.gaia.crypto.engines.HC256Engine;
import cn.org.bjca.gaia.jcajce.provider.config.ConfigurableProvider;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BaseKeyGenerator;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.BaseStreamCipher;
import cn.org.bjca.gaia.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import cn.org.bjca.gaia.jcajce.provider.util.AlgorithmProvider;

public final class HC256 {
    private HC256() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = HC256.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.HC256", PREFIX + "$Base");
            provider.addAlgorithm("KeyGenerator.HC256", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.HC256", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "HC256 IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("HC256", 256, new CipherKeyGenerator());
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new HC256Engine(), 32);
        }
    }
}

