/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.spec;

import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.org.bjca.gaia.asn1.rosstandart.RosstandartObjectIdentifiers;
import cn.org.bjca.gaia.crypto.engines.GOST28147Engine;
import cn.org.bjca.gaia.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class GOST28147WrapParameterSpec
implements AlgorithmParameterSpec {
    private byte[] ukm = null;
    private byte[] sBox = null;
    private static Map oidMappings = new HashMap();

    public GOST28147WrapParameterSpec(byte[] sBox) {
        this.sBox = new byte[sBox.length];
        System.arraycopy(sBox, 0, this.sBox, 0, sBox.length);
    }

    public GOST28147WrapParameterSpec(byte[] sBox, byte[] ukm) {
        this(sBox);
        this.ukm = new byte[ukm.length];
        System.arraycopy(ukm, 0, this.ukm, 0, ukm.length);
    }

    public GOST28147WrapParameterSpec(String sBoxName) {
        this.sBox = GOST28147Engine.getSBox(sBoxName);
    }

    public GOST28147WrapParameterSpec(String sBoxName, byte[] ukm) {
        this(sBoxName);
        this.ukm = new byte[ukm.length];
        System.arraycopy(ukm, 0, this.ukm, 0, ukm.length);
    }

    public GOST28147WrapParameterSpec(ASN1ObjectIdentifier sBoxName, byte[] ukm) {
        this(GOST28147WrapParameterSpec.getName(sBoxName));
        this.ukm = Arrays.clone(ukm);
    }

    public byte[] getSBox() {
        return Arrays.clone(this.sBox);
    }

    public byte[] getUKM() {
        return Arrays.clone(this.ukm);
    }

    private static String getName(ASN1ObjectIdentifier sBoxOid) {
        String sBoxName = (String)oidMappings.get(sBoxOid);
        if (sBoxName == null) {
            throw new IllegalArgumentException("unknown OID: " + sBoxOid);
        }
        return sBoxName;
    }

    static {
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet, "E-A");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet, "E-B");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet, "E-C");
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet, "E-D");
        oidMappings.put(RosstandartObjectIdentifiers.id_tc26_gost_28147_param_Z, "Param-Z");
    }
}

