/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.NumberUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.com.sansec.device.local.Card;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.util.MathUtil;

public class CryptoUtil
extends SuperUtil {
    public CryptoUtil(String appName) {
        super(appName);
    }

    public String encryptData_des_ecb(long ALGID, long cryptoMode, byte[] key, byte[] iv, byte[] toBeEncryptedBlob) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec keyspec = new DESKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cpher.init(1, deskey);
            byte[] data = cpher.doFinal(toBeEncryptedBlob);
            String outData = base64Util.BJS_EncodeBase64(data);
            return outData;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption ,des_ecb", e);
            this.debuglog("Exception in symmetric encryption ,des_ecb");
            return null;
        }
    }

    public boolean encryptData_des_ecb(long ALGID, long cryptoMode, byte[] key, byte[] iv, InputStream inputStream, OutputStream outData) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        try {
            int len;
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec keyspec = new DESKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cpher.init(1, deskey);
            CipherInputStream cis = new CipherInputStream(inputStream, cpher);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = cis.read(inBytes)) != -1) {
                outData.write(inBytes, 0, len);
            }
            inputStream.close();
            cis.close();
            outData.close();
            return true;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption ,des_ecb", e);
            this.debuglog("Exception in symmetric encryption ,des_ecb");
            return false;
        }
    }

    public byte[] decryptData_des_ecb(long ALGID, long cryptoMode, byte[] key, byte[] iv, String beDecryptedBlob) throws DecryptDataException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] inDataByte = base64Util.BJS_DecodeBase64(beDecryptedBlob);
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec keyspec = new DESKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            cpher.init(2, deskey);
            byte[] data = cpher.doFinal(inDataByte);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric decryption,des_ecb", e);
            this.debuglog("Exception in symmetric decryption,des_ecb");
            return null;
        }
    }

    public byte[] encryptData_3des_cbc(byte[] key, byte[] iv, byte[] inData) {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return null;
        }
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            IvParameterSpec ivPara = new IvParameterSpec(iv);
            cpher.init(1, (Key)deskey, ivPara);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,3des_cbc", e);
            this.debuglog("Exception in symmetric encryption,3des_cbc");
            return null;
        }
    }

    public byte[] encryptData_3des_cbc_nopadding(byte[] key, byte[] iv, byte[] inData) {
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/CBC/Nopadding");
            IvParameterSpec ivPara = new IvParameterSpec(iv);
            cpher.init(1, (Key)deskey, ivPara);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,3des_cbc", e);
            this.debuglog("Exception in symmetric encryption,3des_cbc");
            return null;
        }
    }

    public byte[] decryptData_3des_cbc(byte[] key, byte[] iv, byte[] inData) {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return null;
        }
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            IvParameterSpec ivpara = new IvParameterSpec(iv);
            cpher.init(2, (Key)deskey, ivpara);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception symmetric decryption,3des_cbc", e);
            this.debuglog("Exception symmetric decryption,3des_cbc");
            return null;
        }
    }

    public byte[] decryptData_3des_cbc_nopadding(byte[] key, byte[] iv, byte[] inData) {
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/CBC/Nopadding");
            IvParameterSpec ivpara = new IvParameterSpec(iv);
            cpher.init(2, (Key)deskey, ivpara);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception symmetric decryption,3des_cbc", e);
            this.debuglog("Exception symmetric decryption,3des_cbc");
            return null;
        }
    }

    public byte[] encryptData_3des_ecb(byte[] key, byte[] inData) {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return null;
        }
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpher.init(1, deskey);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,3des_ecb", e);
            this.debuglog("Exception in symmetric encryption,3des_ecb");
            return null;
        }
    }

    public byte[] encryptData_3des_ecb_noPadding(byte[] key, byte[] inData) {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return null;
        }
        if (inData == null) {
            this.errorlog("the indata must not be null!");
            this.debuglog("the indata must not be null!");
            return null;
        }
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/Nopadding");
            cpher.init(1, deskey);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,3des_ecb", e);
            this.debuglog("Exception in symmetric encryption,3des_ecb");
            return null;
        }
    }

    public boolean encryptData_3des_ecb(byte[] key, InputStream inputStream, OutputStream outData) throws EncryptDataException {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return false;
        }
        try {
            int len;
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpher.init(1, deskey);
            CipherInputStream cis = new CipherInputStream(inputStream, cpher);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = cis.read(inBytes)) != -1) {
                outData.write(inBytes, 0, len);
            }
            inputStream.close();
            cis.close();
            outData.close();
            return true;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption ,des_ecb", e);
            this.debuglog("Exception in symmetric encryption ,des_ecb");
            e.printStackTrace();
            return false;
        }
    }

    public boolean decryptData_3des_ecb(byte[] key, InputStream inputStream, OutputStream outData) throws IOException {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return false;
        }
        try {
            int len;
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpher.init(2, deskey);
            CipherInputStream cis = new CipherInputStream(inputStream, cpher);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = cis.read(inBytes)) != -1) {
                outData.write(inBytes, 0, len);
            }
            inputStream.close();
            cis.close();
            outData.close();
            return true;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric decryption,3des_ecb", e);
            this.debuglog("Exception in symmetric decryption,3des_ecb");
            return false;
        }
    }

    public byte[] decryptData_3des_ecb(byte[] key, byte[] inData) {
        if (key != null && key.length != 24) {
            this.errorlog("the length of key must be 24");
            this.debuglog("the length of key must be 24");
            return null;
        }
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cpher.init(2, deskey);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric decryption,3des_ecb", e);
            this.debuglog("Exception in symmetric decryption,3des_ecb");
            return null;
        }
    }

    public byte[] decryptData_3des_ecb_noPadding(byte[] key, byte[] inData) {
        try {
            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
            DESedeKeySpec keyspec = new DESedeKeySpec(key);
            SecretKey deskey = keyfactory.generateSecret(keyspec);
            Cipher cpher = Cipher.getInstance("DESede/ECB/Nopadding");
            cpher.init(2, deskey);
            byte[] data = cpher.doFinal(inData);
            return data;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric decryption,3des_ecb", e);
            this.debuglog("Exception in symmetric decryption,3des_ecb");
            return null;
        }
    }

    public byte[] encryptData_sm1_ecb_pkcs5(byte[] key, byte[] inData) {
        byte[] enData = null;
        Card sanweiCard = Card.getInstance();
        byte[] outAllDataByte = sanweiCard.encrypt(4097, true, key, null, inData);
        int rv = MathUtil.byte2int(outAllDataByte, 0);
        if (rv != 0) {
            return null;
        }
        enData = new byte[outAllDataByte.length - 4];
        System.arraycopy(outAllDataByte, 4, enData, 0, enData.length);
        return enData;
    }

    public byte[] decryptData_sm1_ecb_pkcs5(byte[] key, byte[] inData) {
        byte[] outData = null;
        Card sanweiCard = Card.getInstance();
        byte[] outAllDataByte = sanweiCard.decrypt(4097, true, key, null, inData);
        int rv = MathUtil.byte2int(outAllDataByte, 0);
        if (rv != 0) {
            return null;
        }
        outData = new byte[outAllDataByte.length - 4];
        System.arraycopy(outAllDataByte, 4, outData, 0, outData.length);
        return outData;
    }

    public static void main(String[] arg) {
        try {
            Base64Util base64 = new Base64Util("");
            CryptoUtil cryU = new CryptoUtil("");
            NumberUtil numU = new NumberUtil("");
            byte[] key = new byte[32];
            byte[] iv = new byte[16];
            for (int i = 0; i < 32; ++i) {
                key[i] = 8;
                if (i >= 16) continue;
                iv[i] = 1;
            }
            byte[] enData = cryU.encryptData_aes_256_cbc(key, iv, "hello".getBytes());
            System.out.println(Arrays.toString(enData));
            byte[] datta = cryU.decryptData_aes_256_cbc(enData, iv, key);
            System.out.println(new String(datta));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] encryptData_sm4_cbc(byte[] key, byte[] iv, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            byte[] encdata = null;
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Encrypt(4098, true, key, iv, inData);
            return encdata;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,sm4_cbc", e);
            this.debuglog("Exception in symmetric encryption,sm4_cbc");
            return null;
        }
    }

    public byte[] encryptData_sm4_cbc_nopadding(byte[] key, byte[] iv, byte[] inData) {
        try {
            byte[] encdata = null;
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Encrypt(4098, false, key, iv, inData);
            return encdata;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,sm4_cbc", e);
            this.debuglog("Exception in symmetric encryption,sm4_cbc");
            return null;
        }
    }

    public byte[] decryptData_sm4_cbc(byte[] key, byte[] iv, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            byte[] originalData = null;
            WrapCard wCard = new WrapCard();
            originalData = wCard.sm4Decrypt(4098, true, key, iv, inData);
            return originalData;
        }
        catch (Exception e) {
            this.errorlog("Exception symmetric decryption,sm4_cbc", e);
            this.debuglog("Exception symmetric decryption,sm4_cbc");
            return null;
        }
    }

    public byte[] decryptData_sm4_cbc_nopadding(byte[] key, byte[] iv, byte[] inData) {
        try {
            byte[] originalData = null;
            WrapCard wCard = new WrapCard();
            originalData = wCard.sm4Decrypt(4098, false, key, iv, inData);
            return originalData;
        }
        catch (Exception e) {
            this.errorlog("Exception symmetric decryption,sm4_cbc", e);
            this.debuglog("Exception symmetric decryption,sm4_cbc");
            return null;
        }
    }

    public byte[] encryptData_sm4_ecb(byte[] key, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            byte[] encdata = null;
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Encrypt(4098, true, key, null, inData);
            return encdata;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,sm4_ecb", e);
            this.debuglog("Exception in symmetric encryption,sm4_ecb");
            return null;
        }
    }

    public byte[] decryptData_sm4_ecb(byte[] key, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            byte[] encdata = null;
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Decrypt(4098, true, key, null, inData);
            return encdata;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,sm4_ecb", e);
            this.debuglog("Exception in symmetric encryption,sm4_ecb");
            return null;
        }
    }

    public byte[] encryptData_sm4_ecb_nopadding(byte[] key, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            byte[] encdata = null;
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Encrypt(4098, false, key, null, inData);
            return encdata;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,sm4_ecb", e);
            this.debuglog("Exception in symmetric encryption,sm4_ecb");
            return null;
        }
    }

    public byte[] decryptData_sm4_ecb_nopadding(byte[] key, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            byte[] encdata = null;
            WrapCard wCard = new WrapCard();
            encdata = wCard.sm4Decrypt(4098, false, key, null, inData);
            return encdata;
        }
        catch (Exception e) {
            this.errorlog("Exception in symmetric encryption,sm4_ecb", e);
            this.debuglog("Exception in symmetric encryption,sm4_ecb");
            return null;
        }
    }

    public byte[] encryptData_aes_128_ecb(byte[] key, byte[] inData) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(key));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, aesKey);
            byte[] result = cipher.doFinal(inData);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception encrypt aes_128_ecb", e);
            this.debuglog("Exception encrypt aes_128_ecb", e);
            return null;
        }
    }

    public byte[] decryptData_aes_128_ecb(byte[] content, byte[] key) {
        if (key != null && key.length != 16) {
            this.errorlog("the length of key must be 16");
            this.debuglog("the length of key must be 16");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128, new SecureRandom(key));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, aesKey);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception decrypt aes_128_ecb", e);
            this.debuglog("Exception decrypt aes_128_ecb", e);
            return null;
        }
    }

    public byte[] encryptData_aes_256_ecb(byte[] key, byte[] inData) {
        if (key != null && key.length != 32) {
            this.errorlog("the length of key must be 32");
            this.debuglog("the length of key must be 32");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key);
            kgen.init(256, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, aesKey);
            byte[] result = cipher.doFinal(inData);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception encrypt aes_128_ecb", e);
            this.debuglog("Exception encrypt aes_128_ecb", e);
            return null;
        }
    }

    public byte[] decryptData_aes_256_ecb(byte[] content, byte[] key) {
        if (key != null && key.length != 32) {
            this.errorlog("the length of key must be 32");
            this.debuglog("the length of key must be 32");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key);
            kgen.init(256, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, aesKey);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception decrypt aes_256_ecb", e);
            this.debuglog("Exception decrypt aes_256_ecb", e);
            return null;
        }
    }

    public byte[] encryptData_aes_256_cbc(byte[] key, byte[] iv, byte[] inData) {
        if (key != null && key.length != 32) {
            this.errorlog("the length of key must be 32");
            this.debuglog("the length of key must be 32");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key);
            kgen.init(256, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)aesKey, new IvParameterSpec(iv));
            byte[] result = cipher.doFinal(inData);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception encrypt aes_256_cbc", e);
            this.debuglog("Exception encrypt aes_256_cbc", e);
            return null;
        }
    }

    public byte[] encryptData_aes_256_cbc_nopadding(byte[] key, byte[] iv, byte[] inData) {
        if (key != null && key.length != 32) {
            this.errorlog("the length of key must be 32");
            this.debuglog("the length of key must be 32");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key);
            kgen.init(256, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/Nopadding");
            cipher.init(1, (Key)aesKey, new IvParameterSpec(iv));
            byte[] result = cipher.doFinal(inData);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception encrypt aes_256_cbc", e);
            this.debuglog("Exception encrypt aes_256_cbc", e);
            return null;
        }
    }

    public byte[] decryptData_aes_256_cbc(byte[] content, byte[] iv, byte[] key) {
        if (key != null && key.length != 32) {
            this.errorlog("the length of key must be 32");
            this.debuglog("the length of key must be 32");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key);
            kgen.init(256, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)aesKey, new IvParameterSpec(iv));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception decrypt aes_256_cbc", e);
            this.debuglog("Exception decrypt aes_256_cbc", e);
            return null;
        }
    }

    public byte[] decryptData_aes_256_cbc_nopadding(byte[] content, byte[] iv, byte[] key) {
        if (key != null && key.length != 32) {
            this.errorlog("the length of key must be 32");
            this.debuglog("the length of key must be 32");
            return null;
        }
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(key);
            kgen.init(256, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec aesKey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/Nopadding");
            cipher.init(2, (Key)aesKey, new IvParameterSpec(iv));
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            this.errorlog("Exception decrypt aes_256_cbc", e);
            this.debuglog("Exception decrypt aes_256_cbc", e);
            return null;
        }
    }
}

