/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.utils.Base64Util;

public class ExportCertificateUtil {
    public static Certificate exportJksCertificate(byte[] jksByte, String password, String keyAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(jksByte);
        keyStore.load(byteInStream, password.toCharArray());
        Certificate cert = keyStore.getCertificate(keyAlias);
        return cert;
    }

    public static PrivateKey exportJksKey(byte[] jksByte, String password, String keyAlias) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(jksByte);
        keyStore.load(byteInStream, password.toCharArray());
        PrivateKey priKey = (PrivateKey)keyStore.getKey(keyAlias, password.toCharArray());
        return priKey;
    }

    public static ArrayList exportJksAlias(byte[] jksByte, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ArrayList<String> aliasList = new ArrayList<String>();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(jksByte);
        keyStore.load(byteInStream, password.toCharArray());
        Enumeration<String> aliaseList = keyStore.aliases();
        while (aliaseList.hasMoreElements()) {
            String alis = aliaseList.nextElement();
            aliasList.add(alis.trim());
        }
        return aliasList;
    }

    public static Certificate exportP12Certificate(byte[] p12Byte, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(p12Byte);
        keyStore.load(byteInStream, password.toCharArray());
        Enumeration<String> aliaseList = keyStore.aliases();
        String olnyAlias = "";
        while (aliaseList.hasMoreElements()) {
            String alis;
            olnyAlias = alis = aliaseList.nextElement();
        }
        Certificate cert = keyStore.getCertificate(olnyAlias);
        return cert;
    }

    public static PrivateKey exportP12Key(byte[] p12Byte, String password) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(p12Byte);
        keyStore.load(byteInStream, password.toCharArray());
        Enumeration<String> aliaseList = keyStore.aliases();
        String olnyAlias = "";
        while (aliaseList.hasMoreElements()) {
            String alis;
            olnyAlias = alis = aliaseList.nextElement();
        }
        PrivateKey priKey = (PrivateKey)keyStore.getKey(olnyAlias, password.toCharArray());
        return priKey;
    }

    public static void main(String[] args) {
        try {
            FileUtil fileU = new FileUtil("");
            Base64Util base64U = new Base64Util("");
            byte[] pfxByte = fileU.readFile("d:\\zhengshu\\011000100018422-Signature.pfx");
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(pfxByte);
            keyStore.load(byteInStream, "31040084".toCharArray());
            Enumeration<String> aliaseList = keyStore.aliases();
            String olnyAlias = "";
            while (aliaseList.hasMoreElements()) {
                String alis;
                olnyAlias = alis = aliaseList.nextElement();
                System.out.println("\u522b\u540d:" + alis);
            }
            Key oKey = keyStore.getKey("1", "31040084".toCharArray());
            Signature oSign = Signature.getInstance("SHA1withRSA");
            oSign.initSign((PrivateKey)oKey);
            oSign.update("hellollll".getBytes());
            byte[] signedBuf = oSign.sign();
            String out = base64U.BJS_EncodeBase64(signedBuf);
            System.out.println(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

