/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;

public class KeyUtil
extends SuperUtil {
    public KeyUtil(String appName) {
        super(appName);
    }

    public RSAPrivateCrtKeyParameters getPrivateKey(PrivateKey privateKey) {
        try {
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            RSAPrivateCrtKeySpec priSpec = keyFac.getKeySpec(privateKey, RSAPrivateCrtKeySpec.class);
            BigInteger modulus = new BigInteger(1, priSpec.getModulus().toByteArray());
            BigInteger publicExponent = new BigInteger(1, priSpec.getPublicExponent().toByteArray());
            BigInteger privateExponent = new BigInteger(1, priSpec.getPrivateExponent().toByteArray());
            BigInteger prime1 = new BigInteger(1, priSpec.getPrimeP().toByteArray());
            BigInteger prime2 = new BigInteger(1, priSpec.getPrimeQ().toByteArray());
            BigInteger exponent1 = new BigInteger(1, priSpec.getPrimeExponentP().toByteArray());
            BigInteger exponent2 = new BigInteger(1, priSpec.getPrimeExponentQ().toByteArray());
            BigInteger coefficient = new BigInteger(1, priSpec.getCrtCoefficient().toByteArray());
            RSAPrivateCrtKeyParameters priK = new RSAPrivateCrtKeyParameters(modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient);
            return priK;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in privatekey type conversion!", e);
            this.debuglog("Exception in privatekey type conversion!", e);
            return null;
        }
    }

    public RSAKeyParameters getPublicKey(PublicKey publicKey) {
        try {
            KeyFactory keyFac = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = keyFac.getKeySpec(publicKey, RSAPublicKeySpec.class);
            BigInteger modulus = new BigInteger(keySpec.getModulus().toByteArray());
            BigInteger exponent = new BigInteger(keySpec.getPublicExponent().toByteArray());
            RSAKeyParameters pubKeyPara = new RSAKeyParameters(false, modulus, exponent);
            return pubKeyPara;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in publickey type conversion!", e);
            this.debuglog("Exception in publickey type conversion!", e);
            return null;
        }
    }
}

