/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.security;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import sun.misc.BASE64Decoder;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.config.ValueProvider;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.FinalizeException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.jni.utils.CryptoUtil;
import xjyb.cn.org.bjca.jni.utils.FileUtil;
import xjyb.cn.org.bjca.jni.utils.HashUtil;
import xjyb.cn.org.bjca.jni.utils.NumberUtil;
import xjyb.cn.org.bjca.jni.utils.Pkcs7Util;
import xjyb.cn.org.bjca.jni.utils.RsaUtil;
import xjyb.cn.org.bjca.jni.utils.SecretUtil;
import xjyb.cn.org.bjca.jni.utils.TsUtil;
import xjyb.cn.org.bjca.jni.utils.XMLSignUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.cn.org.bjca.valuebean.TrustObject;
import xjyb.com.bjca.security.exception.SecurityEngineException;

public class test
extends Log {
    private BjcaApiEngine apiEngine = null;
    private static final int logon_mode = 1;
    public int m_Iinitmodel = 3;
    private String m_container = null;
    private String m_appName = null;
    private String m_devType = null;
    private String m_password = null;
    private String m_keyType = null;
    private String m_provider = null;
    private String m_privateDll = null;
    private String m_policytype = null;
    private ArrayList m_catypeList = null;
    private ArrayList trustObjectList = null;
    private Properties m_appProhibitsList = null;
    private String m_verifyTime = null;
    private String m_uniqidoid = null;
    private byte[] m_signCertBytes = null;
    private byte[] m_encryptCertBytes = null;
    private byte[] m_encryptPfx = null;
    private byte[] m_signPfx = null;

    public test(String appName) {
        super(appName);
        GetPathUtil getPathUtil = new GetPathUtil(this.applicationName);
        GetPathUtil.setConfigPath();
    }

    public BjcaApiEngine initialApp(String appName) throws FileNotFoundException, JDOMException, IOException, InitException {
        if (XmlConfig.version == null) {
            XmlConfig.loadConfig();
        }
        this.setAppValue(appName);
        this.apiEngine = new BjcaApiEngine();
        long execflag = this.apiEngine.BCA_Initialize(this.m_Iinitmodel, this.m_provider, 1, this.m_privateDll);
        if (execflag != 0L) {
            throw new InitException("JNI\u672c\u5730\u5e93\u521d\u59cb\u5316\u5931\u8d25");
        }
        this.initSvrCert();
        this.initTrust();
        return this.apiEngine;
    }

    public void setAppValue(String appName) {
        Properties webApp = (Properties)XmlConfig.getListWebapps().get(appName);
        this.m_appName = appName;
        this.m_container = webApp.getProperty("container");
        this.m_password = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("password");
        this.m_keyType = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("keytype");
        String devicename = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("devicename");
        this.m_devType = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("providertype");
        this.m_Iinitmodel = Integer.parseInt(this.m_devType);
        this.m_provider = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("provider");
        this.m_privateDll = ((Properties)XmlConfig.getListDevices().get(devicename)).getProperty("privatedll");
        this.m_verifyTime = webApp.getProperty("verifytime");
        this.m_policytype = webApp.getProperty("policytype");
        this.m_catypeList = ValueProvider.getAllTrustName(appName);
        this.trustObjectList = ValueProvider.getAllTrust(appName);
        this.m_appProhibitsList = (Properties)XmlConfig.getListWebappsProhibits().get(appName);
        this.m_uniqidoid = ((Properties)XmlConfig.getListCerts().get(this.m_container)).getProperty("uniqidoid");
    }

    public void loginApp() throws InitException {
        byte[] bp;
        int execflag;
        if (this.apiEngine == null) {
            throw new InitException("\u521d\u59cb\u5316\u5de5\u4f5c\u672a\u5b8c\u6210\uff01");
        }
        if (this.m_Iinitmodel != 3 && (execflag = this.apiEngine.BCA_Login(bp = this.m_password.getBytes(), bp.length)) != 0) {
            throw new InitException("JNI\u672c\u5730\u5e93login\u5931\u8d25");
        }
    }

    private boolean initSvrCert() throws InitException {
        GetPathUtil getPathUtil = new GetPathUtil(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        boolean succ = true;
        byte[] certificate = null;
        long[] certificateLen = new long[1];
        byte[] signcertificate = null;
        long[] signcertificateLen = new long[1];
        int keyUsage = Integer.parseInt(this.m_keyType);
        if (this.m_Iinitmodel == 3) {
            String pixpath = null;
            String derpath = null;
            pixpath = getPathUtil.getDiskExchPfx(this.m_container);
            derpath = getPathUtil.getDiskExchCert(this.m_container);
            this.m_encryptCertBytes = fileUtil.readFile(derpath);
            this.m_encryptPfx = fileUtil.readFile(pixpath);
            if (keyUsage == 1) {
                this.m_signCertBytes = this.m_encryptCertBytes;
                this.m_signPfx = this.m_encryptPfx;
            } else {
                pixpath = getPathUtil.getDiskSignPfx(this.m_container);
                derpath = getPathUtil.getDiskSignCert(this.m_container);
                this.m_signCertBytes = fileUtil.readFile(derpath);
                this.m_signPfx = fileUtil.readFile(pixpath);
            }
        } else {
            int execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 1L, certificate, certificateLen);
            if (execflag == 0) {
                certificate = new byte[(int)certificateLen[0]];
                execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 1L, certificate, certificateLen);
            }
            if (execflag != 0) {
                throw new InitException("\u521d\u59cb\u5316\u4ea4\u6362\u8bc1\u4e66\u51fa\u9519\uff01");
            }
            this.m_encryptCertBytes = certificate;
            if (keyUsage == 1) {
                this.m_signCertBytes = this.m_encryptCertBytes;
            } else {
                execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 2L, signcertificate, signcertificateLen);
                if (execflag == 0) {
                    signcertificate = new byte[(int)signcertificateLen[0]];
                    execflag = this.apiEngine.BCA_GetUsrCertificate(this.m_container.getBytes(), this.m_container.getBytes().length, 2L, signcertificate, signcertificateLen);
                }
                if (execflag != 0) {
                    throw new InitException("\u521d\u59cb\u5316\u7b7e\u540d\u8bc1\u4e66\u51fa\u9519\uff01");
                }
                this.m_signCertBytes = signcertificate;
            }
        }
        return succ;
    }

    private boolean initTrust() {
        GetPathUtil getPathUtil = new GetPathUtil(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        boolean retValue = true;
        try {
            ArrayList trustlist = ValueProvider.getAllTrust(this.m_appName);
            for (int i = 0; i < trustlist.size(); ++i) {
                TrustObject otrust = (TrustObject)trustlist.get(i);
                String caType = otrust.getId();
                String p7bpath = getPathUtil.getTrustP7b(caType);
                String crlpath = getPathUtil.getTrustCrl(caType);
                File p7bfile = new File(p7bpath);
                File crlfile = new File(crlpath);
                if (p7bfile.exists()) {
                    byte[] bp7b = fileUtil.readFile(p7bpath);
                    this.apiEngine.BCA_AddCertPathP7b(bp7b, bp7b.length);
                }
                if (!crlfile.exists()) continue;
                byte[] bcrl = fileUtil.readFile(crlpath);
                this.apiEngine.BCA_AddCrl(bcrl, bcrl.length);
            }
        }
        catch (Exception e) {
            retValue = false;
            System.err.println("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return retValue;
    }

    public boolean finalizeApp() {
        boolean isSuccess = true;
        if (this.apiEngine == null) {
            return true;
        }
        try {
            int execflag = this.apiEngine.BCA_Finalize();
            if (execflag != 0) {
                throw new FinalizeException("\u672c\u5730\u5e93\u91ca\u653e\u73af\u5883\u5931\u8d25");
            }
            this.apiEngine = null;
        }
        catch (FinalizeException fe) {
            isSuccess = false;
            System.err.println("\u5e95\u5c42\u5e93\u51fa\u73b0\u9519\u8bef\uff1a" + fe.getMessage());
            fe.printStackTrace();
        }
        catch (Exception e) {
            isSuccess = false;
            System.err.println("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return isSuccess;
    }

    public int BJC_CheckCertValidaty(byte[] usrCert, String sDate) throws Exception {
        int idate = 0;
        if (this.apiEngine == null) {
            throw new Exception("\u521d\u59cb\u5316\u5de5\u4f5c\u672a\u5b8c\u6210\uff01");
        }
        byte[] binfo = null;
        long[] infoLen = new long[1];
        String strdatefrom = null;
        String strdateto = null;
        int execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 11L, binfo, infoLen);
        if (execflag == 0) {
            binfo = new byte[(int)infoLen[0]];
            execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 11L, binfo, infoLen);
            strdatefrom = new String(binfo);
        }
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
        Date compDate = null;
        compDate = sDate == null || sDate.equals("") ? new Date() : dateformat.parse(sDate);
        Date datefrom = dateformat.parse(String.valueOf(strdatefrom.substring(0, 4)) + "/" + strdatefrom.substring(4, 6) + "/" + strdatefrom.substring(6, 8));
        long ldate = (compDate.getTime() - datefrom.getTime()) / 86400000L;
        if (ldate < 0L) {
            return (int)ldate;
        }
        try {
            int execflag1 = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 12L, binfo, infoLen);
            if (execflag == 0) {
                binfo = new byte[(int)infoLen[0]];
                execflag = this.apiEngine.BCA_GetCertificateInfo(usrCert, usrCert.length, 12L, binfo, infoLen);
                strdateto = new String(binfo);
            }
            Date dateto = dateformat.parse(String.valueOf(strdateto.substring(0, 4)) + "/" + strdateto.substring(4, 6) + "/" + strdateto.substring(6, 8));
            ldate = (dateto.getTime() - compDate.getTime()) / 86400000L;
            idate = (int)ldate;
            if (execflag != 0) {
                throw new Exception("\u53d6\u8bc1\u4e66\u6709\u6548\u671f\u65f6\u95f4\u51fa\u9519\uff01");
            }
        }
        catch (Exception e) {
            idate = 0;
            System.err.println("\u9519\u8bef\u539f\u56e0\u662f\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return idate;
    }

    public String getRandomString() throws RandomNumberException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, 10);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] getRandomByte() throws RandomNumberException {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, 10);
        return random;
    }

    public String getRandomString(int len) throws RandomNumberException, Base64Exception {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, len);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] getRandomByte(int len) throws RandomNumberException {
        NumberUtil numberUtil = new NumberUtil(this.applicationName);
        byte[] random = numberUtil.BJK_GenRandomBytes(this.apiEngine, len);
        return random;
    }

    public String BJC_GetUniqIdOidByCAId(String caId) {
        Properties trustCert = ValueProvider.getTrustCert(caId);
        String uniqidoid = trustCert.getProperty("uniqidoid");
        return uniqidoid;
    }

    public String getCertInfo(String base64Cert, int type) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String certInfo = certificatUtil.BJC_GetBasicCertInfo(certbuf, type);
        return certInfo;
    }

    public String getCertInfoByOid(String base64Cert, String oid) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        CertificateUtil certificatUtil = new CertificateUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        String info = certificatUtil.BJC_GetExtCertInfo(certbuf, oid);
        return info;
    }

    public String signDataPkcs1(String Content, long signMethod) throws Base64Exception, HashException, RsaSignException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign(this.apiEngine, Content.getBytes(), signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return signdata;
    }

    public boolean verifySignedDataPkcs1(String Content, String signature, String cert, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
        boolean ret = rsaUtil.BJK_RsaVerify(this.apiEngine, Content.getBytes(), signature, certbuf, signMethod);
        return ret;
    }

    public String signFile(String inFile, long signMethod) throws HashException, RsaSignException, Base64Exception {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String signdata = rsaUtil.BJK_RsaSign_File(this.apiEngine, inFile, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return signdata;
    }

    public boolean VerifySignedFile(String base64EncodeCert, String inFile, String signValue, long signMethod) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        boolean ret = rsaUtil.BJK_RsaVerify_File(this.apiEngine, inFile, signValue, base64EncodeCert, signMethod);
        return ret;
    }

    public String secretSegment(String secert, int m, int n, int k) throws SecretSegmentException {
        SecretUtil secretUtil = new SecretUtil(this.applicationName);
        return secretUtil.BJ_SecertSegment(this.apiEngine, secert, m, n, k);
    }

    public String secertRecovery(String seg) throws SecretRecoveryException {
        SecretUtil secretUtil = new SecretUtil(this.applicationName);
        return secretUtil.BJ_SecertRecovery(this.apiEngine, seg);
    }

    public String encryptData(String key, String inData, long encryptMethod) throws EncryptDataException, IOException, Base64Exception {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        String sdata = cryptoUtil.BJS_SymmEncrypt(this.apiEngine, encryptMethod, 1L, sKey, sKey.length, iv, inData.getBytes());
        return sdata;
    }

    public String decryptData(String key, String inData, long decryptMethod) throws DecryptDataException, Base64Exception, IOException {
        CryptoUtil cryptoUtil = new CryptoUtil(this.applicationName);
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        sKey = new BASE64Decoder().decodeBuffer(key);
        byte[] sdata = cryptoUtil.BJS_SymmDecrypt(this.apiEngine, decryptMethod, 1L, sKey, sKey.length, iv, inData);
        String outData = new String(sdata);
        return outData;
    }

    public boolean encryptFile(String key, String inFile, String outFile, long encryptMethod) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmEncFile(this.apiEngine, inFile, outFile, keybuf, encryptMethod, 1L);
        return rv;
    }

    public boolean decryptFile(String key, String inFile, String outFile, long encryptMethod) throws Base64Exception, DecryptDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        FileUtil fileUtil = new FileUtil(this.applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmDecFile(this.apiEngine, inFile, outFile, keybuf, encryptMethod, 1L);
        return rv;
    }

    public String pubKeyEncrypt(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] sdata = rsaUtil.BJK_RsaEncrypt(this.apiEngine, inData.getBytes(), certbuf);
        return base64Util.BJS_EncodeBase64(sdata);
    }

    public String priKeyDecrypt(String InData) throws Base64Exception, RsaDecryptException {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        String sdata = rsaUtil.BJK_RsaDecrypt(this.apiEngine, InData, this.m_Iinitmodel, this.m_password, this.m_container, this.m_encryptPfx);
        return sdata;
    }

    public byte[] hashAll(ArrayList fileList, ArrayList stringList, long signMethod) {
        FileUtil fileUtil = new FileUtil(this.applicationName);
        HashUtil hu = new HashUtil(this.applicationName);
        byte[] hashbuf = null;
        try {
            int i;
            hu.BJS_HashInit(this.apiEngine, signMethod);
            for (i = 0; i < fileList.size(); ++i) {
                String filePath = ((String)fileList.get(i)).toString();
                byte[] inbuf = fileUtil.readFile(filePath);
                hu.BJS_HashUpdate(this.apiEngine, inbuf, inbuf.length);
            }
            for (i = 0; i < stringList.size(); ++i) {
                String str = ((String)stringList.get(i)).toString();
                hu.BJS_HashUpdate(this.apiEngine, str.getBytes(), str.getBytes().length);
            }
            hashbuf = hu.BJS_HashFinal(this.apiEngine);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return hashbuf;
    }

    public String signAll(ArrayList fileList, ArrayList stringList, long signMethod) throws RsaSignException, Base64Exception {
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        byte[] signData = rsaUtil.BJK_RsaSignNoHash(this.apiEngine, hashbuf, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        String signString = base64Util.BJS_EncodeBase64(signData);
        return signString;
    }

    public boolean verifySignAll(ArrayList fileList, ArrayList stringList, String base64EncodeCert, String signValue, long signMethod) throws Base64Exception, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] sginbuf = base64Util.BJS_DecodeBase64(signValue);
        boolean isSuccess = rsaUtil.BJK_RsaVerifyNoHash(this.apiEngine, hashbuf, sginbuf, certbuf, signMethod);
        return isSuccess;
    }

    public String getTotalTsReq(ArrayList fileList, ArrayList stringList, long signMethod) throws TsException, Base64Exception {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] hashbuf = this.hashAll(fileList, stringList, signMethod);
        String sdata = tsUtil.BJT_TSRequest(this.apiEngine, hashbuf, hashbuf.length, signMethod);
        return sdata;
    }

    public String signDataPkcs7(String inData, long signMethod) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        byte[] conbuf = inData.getBytes();
        String p7signdata = pkcs7Util.BJE_Pkcs7Sign(this.apiEngine, conbuf, conbuf.length, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container);
        return p7signdata;
    }

    public String signDataPkcs7Base64(String inData, long signMethod) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] conbuf = base64Util.BJS_DecodeBase64(inData);
        String p7signdata = pkcs7Util.BJE_Pkcs7Sign(this.apiEngine, conbuf, conbuf.length, signMethod, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_signCertBytes, this.m_keyType, this.m_container);
        return p7signdata;
    }

    public boolean verifySignedDataPkcs7(String pkcs7SignData) throws Base64Exception, Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        boolean isSuccess = pkcs7Util.BJE_Pkcs7Verify(this.apiEngine, pkcs7SignData);
        return isSuccess;
    }

    public String verifySignedDataPkcs7_cert(String pkcs7SignData) throws Base64Exception, Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String cert = pkcs7Util.BJE_Pkcs7Verify_Cert(this.apiEngine, pkcs7SignData);
        return cert;
    }

    public String encodeP7EnvelopedData(String base64EncodeCert, String inData, long encryptMethod) throws Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelope(this.apiEngine, inData, certbuf, encryptMethod);
        return p7envdata;
    }

    public String decodeP7EnvelopedData(String inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String p7envdata = pkcs7Util.BJE_Pkcs7DecodeEnvelope(this.apiEngine, inData, this.m_Iinitmodel, this.m_password, this.m_encryptPfx, this.m_container);
        return p7envdata;
    }

    public String decodeP7EnvelopedExData(String beEncryptedBlob) {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        String p7EnvExdata = pkcs7Util.BJE_Pkcs7DecodeEnvelopeEx(this.apiEngine, beEncryptedBlob, this.m_Iinitmodel, this.m_password, this.m_container, this.m_encryptPfx);
        return p7EnvExdata;
    }

    public String signDataXML(String inData, long signMethod) throws XmlSignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = "";
        return ret;
    }

    public boolean verifySignedDataXML(String inData, long signMethod) throws XmlVerifySignException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        boolean ret = xs.BJX_SignedDataXML_Verify(this.apiEngine, inData, signMethod);
        return ret;
    }

    public String getXMLSignatureInfo(String XMLSignedData, short type) throws GetXMLSignInfoException, JDOMException {
        XMLSignUtil xs = new XMLSignUtil(this.applicationName);
        String ret = xs.BJX_getXMLSignatureInfo(XMLSignedData, type);
        return ret;
    }

    public String createTimeStampRequest(String inData, long hashMethod) throws HashException, TsException, Base64Exception {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] hashBytes = hashUtil.BJS_HashBytes(this.apiEngine, hashMethod, inData.getBytes(), inData.getBytes().length);
        String sdata = tsUtil.BJT_TSRequest(this.apiEngine, hashBytes, hashBytes.length, hashMethod);
        return sdata;
    }

    public String createTimeStampresponse(String inData) throws Base64Exception, TsException {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        String p7tsdata = tsUtil.BJT_TSResponse(this.apiEngine, inData, this.m_Iinitmodel, this.m_password, this.m_signPfx, this.m_keyType, this.m_container);
        return p7tsdata;
    }

    public boolean verifyTimeStamp(String content, String tsResponseData, long hashMethod) throws Base64Exception, TsException, HashException {
        TsUtil tsUtil = new TsUtil(this.applicationName);
        boolean isSuccess = tsUtil.BJT_TSVerify(this.apiEngine, content, tsResponseData, hashMethod);
        return isSuccess;
    }

    public String getTimeStampInfo(String tsResponseData, int type) throws Base64Exception, TsException, ParseException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        TsUtil tsUtil = new TsUtil(this.applicationName);
        byte[] timebuf = base64Util.BJS_DecodeBase64(tsResponseData);
        return tsUtil.BJT_TS_GetInfo(this.apiEngine, timebuf, type);
    }

    public String getP7SignDataInfo(String pkcs7SignData, int type) throws Base64Exception, Pkcs7SignException, Pkcs7DecodeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util(this.applicationName);
        ArrayList infoList = pkcs7Util.BJE_getP7SignDataInfo(this.apiEngine, pkcs7SignData);
        if (type >= 1) {
            return (String)infoList.get(type - 1);
        }
        return null;
    }

    public int getIinitmodel() {
        return this.m_Iinitmodel;
    }

    public String getProvider() {
        return this.m_provider;
    }

    public String getPrivateDll() {
        return this.m_privateDll;
    }

    public String getPassword() {
        return this.m_password;
    }

    public byte[] getSignPfx() {
        return this.m_signPfx;
    }

    public byte[] getSignCertBytes() {
        return this.m_signCertBytes;
    }

    public String getSignCertString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String cert = base64Util.BJS_EncodeBase64(this.m_signCertBytes);
        return cert;
    }

    public byte[] getEncryptCertBytes() {
        return this.m_encryptCertBytes;
    }

    public String getEncryptCertString() throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String cert = base64Util.BJS_EncodeBase64(this.m_encryptCertBytes);
        return cert;
    }

    public String getKeyType() {
        return this.m_keyType;
    }

    public String getContainer() {
        return this.m_container;
    }

    public byte[] getEncryptPfx() {
        return this.m_encryptPfx;
    }

    public byte[] BJ_GetPlainInPut2(String PassEncstr, String sRand) throws Base64Exception, InvalidKeyException, SecurityEngineException, NoSuchAlgorithmException, InvalidKeySpecException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] Passbuf = base64Util.BJS_DecodeBase64(PassEncstr);
        if (Passbuf.length < 264) {
            return null;
        }
        byte[] Encpass = new byte[Passbuf.length - 257];
        System.arraycopy(Passbuf, 257, Encpass, 0, Passbuf.length - 257);
        int keysize = Passbuf[0] * 64;
        byte[] Encrand = new byte[keysize];
        System.arraycopy(Passbuf, 1, Encrand, 0, keysize);
        byte[] outData = null;
        long[] outDataLen = new long[1];
        if (this.m_Iinitmodel == 3) {
            byte[] bpix = this.m_encryptPfx;
            int execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(this.m_password.getBytes(), this.m_password.length(), bpix, bpix.length, Encrand, Encrand.length, outData, outDataLen);
            if (execflag == 0) {
                outData = new byte[(int)outDataLen[0]];
                execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDecByPkcs12(this.m_password.getBytes(), this.m_password.length(), bpix, bpix.length, Encrand, Encrand.length, outData, outDataLen);
            }
            if (execflag != 0) {
                throw new SecurityEngineException(execflag);
            }
        } else {
            int execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDec(this.m_container.getBytes(), this.m_container.length(), 1L, this.m_password.getBytes(), this.m_password.length(), Encrand, Encrand.length, outData, outDataLen);
            if (execflag == 0) {
                outData = new byte[(int)outDataLen[0]];
                execflag = this.apiEngine.BCA_Pkcs1RsaPrivateKeyDec(this.m_container.getBytes(), this.m_container.length(), 1L, this.m_password.getBytes(), this.m_password.length(), Encrand, Encrand.length, outData, outDataLen);
            }
            if (execflag != 0) {
                throw new SecurityEngineException(execflag);
            }
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(sRand.getBytes());
        md.update(outData);
        byte[] mddata = md.digest();
        byte[] dkey = new byte[24];
        System.arraycopy(mddata, 0, dkey, 0, 16);
        System.arraycopy(mddata, 0, dkey, 16, 8);
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
        DESedeKeySpec keyspec = new DESedeKeySpec(dkey);
        SecretKey deskey = keyfactory.generateSecret(keyspec);
        Cipher cpher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
        cpher.init(2, deskey);
        byte[] pass = cpher.doFinal(Encpass);
        return pass;
    }
}

