/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.security;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bjca.bc.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.java.security.SecurityEngine;
import xjyb.cn.org.bjca.java.utils.CryptoUtil;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.java.utils.KeyPairUtil;
import xjyb.cn.org.bjca.java.utils.KeyUtil;
import xjyb.cn.org.bjca.java.utils.NumberUtil;
import xjyb.cn.org.bjca.java.utils.P10Util;
import xjyb.cn.org.bjca.java.utils.Pkcs7Util;
import xjyb.cn.org.bjca.java.utils.RsaUtil;
import xjyb.cn.org.bjca.java.utils.XMLSignUtil;
import xjyb.cn.org.bjca.mac.ASN1Mac;
import xjyb.cn.org.bjca.mac.PBOCMac;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.cn.org.bjca.utils.P12Util;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DEREncodableVector;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERUTF8String;
import xjyb.org.bjca.asn1.pkcs.Attribute;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.crypto.CryptoException;
import xjyb.org.bjca.crypto.digests.sm3.util.SM3Digest;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.jce.CNEnvelopedData;
import xjyb.org.bjca.jce.CNPKCS7SignedData;
import xjyb.org.bjca.jce.PKCS7EnvelopedData;
import xjyb.org.bjca.jce.PKCS7SignedData;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.valuebean.DeviceKeyPair;
import xjyb.org.bjca.sm4soft.crypto.ParameterException;
import xjyb.org.bjca.util.GetP7InfoUtil;
import xjyb.org.bjca.util.P7bUtil;
import xjyb.org.bjca.util.PrintUtil;

public class SecurityUtil {
    private static SecurityUtil secUtil = null;

    private SecurityUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SecurityUtil getInstance() {
        if (secUtil != null) return secUtil;
        Class<SecurityUtil> clazz = SecurityUtil.class;
        synchronized (SecurityUtil.class) {
            Security.addProvider(new BouncyCastleProvider());
            if (Security.addProvider(new BouncyCastleProvider()) != -1) {
                System.out.println("Add provider failed when SecurityUtil initialization !");
                LoggerUtil.errorlog("all", "Add provider failed when SecurityUtil initialization !");
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            secUtil = new SecurityUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return secUtil;
        }
    }

    public String genRandom() throws Base64Exception {
        Base64Util base64Util = new Base64Util("");
        NumberUtil numberUtil = new NumberUtil("");
        byte[] random = numberUtil.BJK_GenRandomBytes(10);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public String genRandom(int len) throws Base64Exception {
        Base64Util base64Util = new Base64Util("");
        NumberUtil numberUtil = new NumberUtil("");
        byte[] random = numberUtil.BJK_GenRandomBytes(len);
        String randomString = base64Util.BJS_EncodeBase64(random);
        return randomString;
    }

    public byte[] genRandomNumber(int len) {
        NumberUtil numberUtil = new NumberUtil("");
        byte[] random = numberUtil.BJK_GenRandomBytes(len);
        return random;
    }

    public String getCertInfo(String base64EncodeCert, int type) {
        Base64Util base64Util = new Base64Util("");
        CertificateUtil certificatUtil = new CertificateUtil("");
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String certInfo = certificatUtil.BJC_GetBasicCertInfo(certbuf, type);
        return certInfo;
    }

    public String getCertInfoByOid(String base64EncodeCert, String oid) throws Base64Exception, GetCertInfoException {
        Base64Util base64Util = new Base64Util("");
        CertificateUtil certificatUtil = new CertificateUtil("");
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        String info = certificatUtil.BJC_GetExtCertInfo(certbuf, oid);
        return info;
    }

    public int checkCertValidity(byte[] usrCert, String inDate) {
        CertificateUtil certificatUtil = new CertificateUtil("");
        int validityDay = certificatUtil.BJC_CheckCertValidity(usrCert, inDate);
        return validityDay;
    }

    public String getCRLInfo(byte[] crlByte, int infoType) {
        CertificateUtil certificatUtil = new CertificateUtil("");
        return certificatUtil.getCRLInfo(crlByte, infoType);
    }

    public boolean isCRLValid(byte[] crlByte, byte[] p7Byte) throws Exception {
        CertificateUtil certificatUtil = new CertificateUtil("");
        return certificatUtil.isCRLValid(crlByte, p7Byte);
    }

    public int validateP7Cert(byte[] p7Byte) throws CryptoException, CertificateException, IOException {
        CertificateUtil certificatUtil = new CertificateUtil("");
        return certificatUtil.validateP7Cert(p7Byte);
    }

    public boolean verifySignedData(String base64EncodeCert, String inData, String signValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        RsaUtil rsaUtil = new RsaUtil("");
        Base64Util base64Util = new Base64Util("");
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
        byte[] signatureByte = base64Util.BJS_DecodeBase64(signValue);
        boolean ret = rsaUtil.BJK_RsaVerifyNoHash(inData.getBytes(), signatureByte, certbuf, 3L);
        return ret;
    }

    public boolean verifySignedData(byte[] cert, byte[] inData, byte[] signValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        RsaUtil rsaUtil = new RsaUtil("");
        boolean ret = rsaUtil.BJK_RsaVerifyNoHash(inData, signValue, cert, 3L);
        return ret;
    }

    public boolean verifySignedDataByPubKey(byte[] pubKey, byte[] inData, byte[] signValue) throws Exception {
        SecurityEngine securityEngine = new SecurityEngine("");
        return securityEngine.verifySignedData(inData, signValue, pubKey);
    }

    public boolean verifySignedFile(String base64EncodeCert, String inFile, String signValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        RsaUtil rsaUtil = new RsaUtil("");
        boolean ret = rsaUtil.BJK_RsaVerify_File(inFile, signValue, base64EncodeCert, 3L);
        return ret;
    }

    public String secretSegment(String secert, int m, int n, int k) throws SecretSegmentException {
        return null;
    }

    public String secretRecovery(String seg) throws SecretRecoveryException {
        return null;
    }

    public String encryptData(String key, String inData) throws EncryptDataException, IOException, Base64Exception {
        Base64Util base64Util = new Base64Util("");
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] bKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        bKey = new BASE64Decoder().decodeBuffer(key);
        byte[] sdata = cryptoUtil.encryptData_3des_cbc(bKey, iv, inData.getBytes());
        String outData = base64Util.BJS_EncodeBase64(sdata);
        return outData;
    }

    public byte[] encryptData(byte[] key, byte[] iv, byte[] inData) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] enData = cryptoUtil.encryptData_3des_cbc(key, iv, inData);
        return enData;
    }

    public String decryptData(String key, String inData) throws DecryptDataException, Base64Exception, IOException {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] bKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        bKey = new BASE64Decoder().decodeBuffer(key);
        byte[] inDataByte = new BASE64Decoder().decodeBuffer(inData);
        byte[] sdata = cryptoUtil.decryptData_3des_cbc(bKey, iv, inDataByte);
        String outData = new String(sdata);
        return outData;
    }

    public byte[] decryptData(byte[] key, byte[] iv, byte[] inData) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] sdata = cryptoUtil.decryptData_3des_cbc(key, iv, inData);
        return sdata;
    }

    public byte[] encryptData(byte[] key, byte[] inData) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        byte[] bData = cryptoUtil.encryptData_3des_cbc(key, iv, inData);
        return bData;
    }

    public byte[] decryptData(byte[] key, byte[] inData) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        byte[] bData = cryptoUtil.decryptData_3des_cbc(key, iv, inData);
        return bData;
    }

    public byte[] encryptData(byte[] key, byte[] inData, int algType, byte[] iv) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] bData = null;
        if (algType == 1022) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.encryptData_3des_cbc(key, iv, inData);
        } else if (algType == 1021) {
            bData = cryptoUtil.encryptData_3des_ecb(key, inData);
        } else if (algType == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.encryptData_sm4_cbc(key, iv, inData);
        }
        return bData;
    }

    public byte[] decryptData(byte[] key, byte[] inData, int algType, byte[] iv) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] bData = null;
        if (algType == 1022) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.decryptData_3des_cbc(key, iv, inData);
        } else if (algType == 1021) {
            bData = cryptoUtil.decryptData_3des_ecb(key, inData);
        } else if (algType == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.decryptData_sm4_cbc(key, iv, inData);
        }
        return bData;
    }

    public byte[] encryptDataNoPadding(byte[] key, byte[] inData, int algType, byte[] iv) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] bData = null;
        if (algType == 1021) {
            bData = cryptoUtil.encryptData_3des_ecb_noPadding(key, inData);
        } else if (algType == 1022) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.encryptData_3des_cbc_nopadding(key, iv, inData);
        } else if (algType == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.encryptData_sm4_cbc_nopadding(key, iv, inData);
        }
        return bData;
    }

    public byte[] decryptDataNoPadding(byte[] key, byte[] inData, int algType, byte[] iv) {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] bData = null;
        if (algType == 1021) {
            bData = cryptoUtil.decryptData_3des_ecb_noPadding(key, inData);
        } else if (algType == 1022) {
            if (iv == null) {
                iv = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.decryptData_3des_cbc_nopadding(key, iv, inData);
        } else if (algType == 400) {
            if (iv == null) {
                iv = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    iv[i] = (byte)(i + 2);
                }
            }
            bData = cryptoUtil.decryptData_sm4_cbc_nopadding(key, iv, inData);
        }
        return bData;
    }

    public boolean encryptFile(String key, String inFile, String outFile) throws Base64Exception, EncryptDataException {
        Base64Util base64Util = new Base64Util("");
        FileUtil fileUtil = new FileUtil("");
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmEncFile(inFile, outFile, keybuf, 102L, 1L);
        return rv;
    }

    public boolean decryptFile(String key, String inFile, String outFile) throws Base64Exception, DecryptDataException {
        Base64Util base64Util = new Base64Util("");
        FileUtil fileUtil = new FileUtil("");
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmDecFile(inFile, outFile, keybuf, 102L, 1L);
        return rv;
    }

    public String pubKeyEncrypt(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        CertificateUtil certUtil = new CertificateUtil("");
        String certType = this.getCertInfo(base64EncodeCert, 31);
        byte[] enData = null;
        if ("ECC".endsWith(certType)) {
            try {
                CertificateUtil certU = new CertificateUtil("");
                X509CertificateStructure strcCert = certU.getX509CertStrc(base64EncodeCert);
                WrapCard wCard = new WrapCard();
                enData = wCard.sm2Encrypt(strcCert, inData.getBytes());
            }
            catch (Exception e) {
                return null;
            }
        } else {
            RsaUtil rsaUtil = new RsaUtil("");
            enData = rsaUtil.BJK_RsaEncrypt(inData.getBytes(), this.base64Decode(base64EncodeCert));
        }
        return this.base64Encode(enData);
    }

    public byte[] pubKeyEncrypt(byte[] publicKey, byte[] inData) {
        WrapCard wrapCard = new WrapCard();
        return wrapCard.sm2Encrypt(publicKey, inData);
    }

    public boolean verifySignedDataPkcs7(String pkcs7SignData) throws Pkcs7VerifySignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        boolean isSuccess = pkcs7Util.BJE_Pkcs7Verify(null, pkcs7SignData);
        return isSuccess;
    }

    public String getP7SignDataInfo(String pkcs7SignData, int type) throws Pkcs7DecodeException {
        Base64Util base64Util = new Base64Util("");
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        byte[] p7SignedData = base64Util.BJS_DecodeBase64(pkcs7SignData);
        ArrayList infoList = pkcs7Util.getP7SignDataInfo(p7SignedData);
        if (type == 1) {
            byte[] inData = (byte[])infoList.get(type - 1);
            String origialData = new String(inData);
            return origialData;
        }
        if (type == 2) {
            byte[] certCode = (byte[])infoList.get(type - 1);
            String base64Cert = base64Util.BJS_EncodeBase64(certCode);
            return base64Cert;
        }
        if (type == 3) {
            byte[] signValue = (byte[])infoList.get(type - 1);
            String base64SignValue = base64Util.BJS_EncodeBase64(signValue);
            return base64SignValue;
        }
        return null;
    }

    public byte[] encodeEnvelopedDataByKeyAndIV(String base64EncodeCert, byte[] inDataByte, byte[] key, byte[] iv) throws Exception {
        byte[] outData = null;
        byte[] certByte = this.base64Decode(base64EncodeCert);
        String certType = this.getCertInfo(base64EncodeCert, 31);
        if ("RSA".equals(certType)) {
            CertificateUtil certUtil = new CertificateUtil("");
            PKCS7EnvelopedData pkcs7Envelope = new PKCS7EnvelopedData();
            PublicKey pubKey = certUtil.getCertPublicKey(certByte);
            outData = pkcs7Envelope.encrypt(inDataByte, certByte, "3DES", "BC", pubKey, key, iv);
        } else if ("ECC".equals(certType)) {
            CNEnvelopedData pkcs7Envelope = new CNEnvelopedData();
            CertificateUtil certU = new CertificateUtil("");
            X509CertificateStructure strcCert = certU.getX509CertStrc(base64EncodeCert);
            outData = pkcs7Envelope.encrypt(inDataByte, strcCert, key, iv);
        }
        return outData;
    }

    public byte[] encodeP7EnvelopedDataByInDataLenAndKeyIV(String base64EncodeCert, long inDataLen, byte[] key, byte[] iv) throws Pkcs7EncodeEnvelopeException {
        byte[] outData = null;
        byte[] certByte = this.base64Decode(base64EncodeCert);
        String certType = this.getCertInfo(base64EncodeCert, 31);
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        if ("RSA".equals(certType)) {
            outData = pkcs7Util.BJE_Pkcs7EncodeEnvelope(inDataLen, certByte, key, iv);
        } else if ("ECC".equals(certType)) {
            Base64Util base64Util = new Base64Util("");
            byte[] certbuf = base64Util.BJS_DecodeBase64(base64EncodeCert);
            outData = pkcs7Util.pkcs7EncodeEnvelope_sm2(inDataLen, certbuf, key, iv);
        }
        return outData;
    }

    public String encodeP7EnvelopedData(String base64EncodeCert, String inData) throws Pkcs7EncodeEnvelopeException, Base64Exception {
        return this.encodeP7EnvelopedData(base64EncodeCert, inData.getBytes());
    }

    public boolean verifySignedDataXML(String inData) throws XmlVerifySignException {
        XMLSignUtil xs = new XMLSignUtil("");
        boolean ret = xs.BJX_SignedDataXML_Verify(inData, 3L);
        return ret;
    }

    public String getXMLSignatureInfo(String XMLSignedData, int type) throws GetXMLSignInfoException, JDOMException {
        XMLSignUtil xs = new XMLSignUtil("");
        String ret = xs.BJX_getXMLSignatureInfo(XMLSignedData, type);
        return ret;
    }

    public String base64Encode(byte[] inData) {
        Base64Util base64Util = new Base64Util("");
        return base64Util.BJS_EncodeBase64(inData);
    }

    public void base64Encode(InputStream inStream, OutputStream outStream) throws IOException {
        Base64Util base64Util = new Base64Util("");
        base64Util.base64Encode(inStream, outStream);
    }

    public byte[] base64Decode(String inData) {
        Base64Util base64Util = new Base64Util("");
        return base64Util.BJS_DecodeBase64(inData);
    }

    public void base64Decode(InputStream inStream, OutputStream outStream) throws IOException {
        Base64Util base64Util = new Base64Util("");
        base64Util.base64Decode(inStream, outStream);
    }

    public String hash_string(String inData) throws HashException, Base64Exception {
        HashUtil hashUtil = new HashUtil("");
        Base64Util base64U = new Base64Util("");
        byte[] hashedData = hashUtil.BJS_HashBytes(0L, inData.getBytes());
        return base64U.BJS_EncodeBase64(hashedData);
    }

    public byte[] hash_byte(byte[] inData, String alg) throws HashException {
        if ("SM3".equals(alg)) {
            WrapCard wCard = new WrapCard();
            byte[] hashedData = null;
            try {
                hashedData = wCard.sm3(inData, null, null);
            }
            catch (IOException e) {
                throw new HashException(e.getMessage());
            }
            return hashedData;
        }
        if ("SHA1".equals(alg)) {
            HashUtil hashUtil = new HashUtil("");
            return hashUtil.BJS_HashBytes(0L, inData);
        }
        return null;
    }

    public byte[] hash_byte(byte[] inData, byte[] pubKey) throws HashException {
        if (pubKey != null) {
            WrapCard wCard = new WrapCard();
            byte[] hashedData = null;
            try {
                byte[] id = "1234567812345678".getBytes();
                hashedData = wCard.sm3(inData, pubKey, id);
            }
            catch (IOException e) {
                throw new HashException(e.getMessage());
            }
            return hashedData;
        }
        return null;
    }

    public byte[] hash_byte(byte[] inData, byte[] pubKey, byte[] ID) throws HashException {
        if (pubKey != null) {
            WrapCard wCard = new WrapCard();
            byte[] hashedData = null;
            try {
                byte[] id = null;
                id = ID != null ? ID : "1234567812345678".getBytes();
                hashedData = wCard.sm3(inData, pubKey, id);
            }
            catch (IOException e) {
                throw new HashException(e.getMessage());
            }
            return hashedData;
        }
        return null;
    }

    public byte[] hash_file(String filePath) throws HashException {
        HashUtil hashUtil = new HashUtil("");
        byte[] fileByte = hashUtil.BJS_HashFile(0L, filePath);
        return fileByte;
    }

    public String getP10PublicKey(byte[] p10) throws Exception {
        P10Util p10U = new P10Util("");
        byte[] pubKey = p10U.getP10PublicKey(p10);
        String publicKeyBase64 = this.base64Encode(pubKey);
        return publicKeyBase64;
    }

    public boolean isTimeStampCert(byte[] usrCert) {
        CertificateUtil certificatUtil = new CertificateUtil("");
        return certificatUtil.isTimeStampCert(usrCert);
    }

    public ArrayList getCertChainByP7(byte[] p7Data) throws CryptoException, IOException {
        ArrayList certList = P7bUtil.getCertChainByP7(p7Data);
        return certList;
    }

    public byte[] encodePkcs7Data(byte[] signCert, byte[] signedData, byte[] originalData) throws Pkcs7SignException {
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        byte[] signedP7Data = pkcs7Util.encodePkcs7Data(signCert, signedData, originalData);
        return signedP7Data;
    }

    public boolean exportPFXByCertAndPriKey(String alias, String password, String base64Cert, String priKey, String pfxPath) throws Exception {
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(this.base64Decode(base64Cert));
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(this.base64Decode(priKey));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        P12Util p12Util = new P12Util();
        p12Util.p12Generator(pfxPath, alias, factory.generatePrivate(pkcs8KeySpec), password, password, oCert);
        return true;
    }

    public byte[] exportPFXByCertAndPriKey(String alias, String password, String base64Cert, String priKey) throws Exception {
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(this.base64Decode(base64Cert));
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(this.base64Decode(priKey));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        P12Util p12Util = new P12Util();
        byte[] pfxCxt = p12Util.p12Generator(alias, factory.generatePrivate(pkcs8KeySpec), password, password, oCert);
        return pfxCxt;
    }

    public String getSerialNumFromEnvelope(String envelope) throws Exception {
        CNEnvelopedData cnEnvelopedData = new CNEnvelopedData();
        return cnEnvelopedData.getSerialNumFromEnvelopedData(this.base64Decode(envelope));
    }

    public String assembleCounterSignInfoList(Object[] infoList) throws Base64Exception, GetCertInfoException, ParseException {
        Base64Util base64Util = new Base64Util("");
        if (infoList == null) {
            return null;
        }
        for (int i = 0; i < infoList.length; ++i) {
            if (infoList[i] != null) continue;
            return null;
        }
        ArrayList certs = (ArrayList)infoList[0];
        ArrayList signingTimeList = (ArrayList)infoList[3];
        if (certs.size() != signingTimeList.size()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < certs.size(); ++i) {
            String beforeDate = this.convertFormat(this.getCertInfo(base64Util.BJS_EncodeBase64((byte[])certs.get(i)), 11), "yyyy/MM/dd", "yyyy-MM-dd");
            String endDate = this.convertFormat(this.getCertInfo(base64Util.BJS_EncodeBase64((byte[])certs.get(i)), 12), "yyyy/MM/dd", "yyyy-MM-dd");
            sb.append("{\"beforeDate\":\"").append(beforeDate).append("\",\"endDate\":\"").append(endDate).append("\",\"signDate\":\"").append(signingTimeList.get(i)).append("\",\"issueDN\":\"").append(this.getCertInfo(base64Util.BJS_EncodeBase64((byte[])certs.get(i)), 20)).append("\",\"subjectDN\":\"").append(this.getCertInfo(base64Util.BJS_EncodeBase64((byte[])certs.get(i)), 21)).append("\"}");
            if (i == certs.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public String jointVerifyCounterSignRetStr(String preCheckSchedule, int preErrorCode, String preInfoList, boolean status) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"checkSchedule\":\"").append(preCheckSchedule).append("\",\"errorCode\":").append(preErrorCode).append(",\"infoList\":").append(preInfoList).append(",\"status\":").append(status).append("}");
        return sb.toString();
    }

    public String convertFormat(String time, String oriFormat, String desFormat) throws ParseException {
        SimpleDateFormat in = new SimpleDateFormat(oriFormat);
        SimpleDateFormat out = new SimpleDateFormat(desFormat);
        String desTime = out.format(in.parse(time));
        return desTime;
    }

    public String signHashedData(String certType, byte[] hash, byte[] privateKey) throws Exception {
        byte[] signedData = null;
        if ("RSA".equals(certType)) {
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            signedData = keyPairUtil.signHashedData(hash, factory.generatePrivate(pkcs8KeySpec));
        } else if ("ECC".equals(certType)) {
            WrapCard wCard = new WrapCard();
            signedData = wCard.sm2SignWithHashedData(hash, privateKey);
        }
        if (signedData != null) {
            return this.base64Encode(signedData);
        }
        return null;
    }

    public String signData(String certType, String data, byte[] privateKey, byte[] publickKey) throws Exception {
        byte[] signedData = null;
        byte[] hash = null;
        if ("RSA".equals(certType)) {
            hash = this.hash_byte(data.getBytes(), "SHA1");
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            signedData = keyPairUtil.signHashedData(hash, factory.generatePrivate(pkcs8KeySpec));
        } else if ("ECC".equals(certType)) {
            hash = this.hash_byte(data.getBytes(), publickKey);
            WrapCard wCard = new WrapCard();
            signedData = wCard.sm2SignWithHashedData(hash, privateKey);
        }
        if (signedData != null) {
            return this.base64Encode(signedData);
        }
        return null;
    }

    public String signData(String certType, byte[] data, byte[] privateKey, byte[] publickKey) throws Exception {
        byte[] signedData = null;
        byte[] hash = null;
        if ("RSA".equals(certType)) {
            hash = this.hash_byte(data, "SHA1");
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            System.out.println("-----------data-----------");
            PrintUtil.printWithHex(data);
            System.out.println("-----------hash-----------");
            PrintUtil.printWithHex(hash);
            signedData = keyPairUtil.signHashedData(hash, factory.generatePrivate(pkcs8KeySpec));
            System.out.println("-----------signedData-----------");
            PrintUtil.printWithHex(signedData);
        } else if ("ECC".equals(certType)) {
            hash = this.hash_byte(data, publickKey);
            WrapCard wCard = new WrapCard();
            signedData = wCard.sm2SignWithHashedData(hash, privateKey);
        }
        if (signedData != null) {
            return this.base64Encode(signedData);
        }
        return null;
    }

    public byte[] signData_retByte(String certType, byte[] data, byte[] privateKey, byte[] publickKey) throws Exception {
        byte[] signedData = null;
        byte[] hash = null;
        if ("RSA".equals(certType)) {
            hash = this.hash_byte(data, "SHA1");
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory factory = KeyFactory.getInstance("RSA");
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            System.out.println("-----------data-----------");
            PrintUtil.printWithHex(data);
            System.out.println("-----------hash-----------");
            PrintUtil.printWithHex(hash);
            signedData = keyPairUtil.signHashedData(hash, factory.generatePrivate(pkcs8KeySpec));
            System.out.println("-----------signedData-----------");
            PrintUtil.printWithHex(signedData);
        } else if ("ECC".equals(certType)) {
            hash = this.hash_byte(data, publickKey);
            WrapCard wCard = new WrapCard();
            signedData = wCard.sm2SignWithHashedData(hash, privateKey);
        }
        if (signedData != null) {
            return signedData;
        }
        return null;
    }

    public boolean verifySignedData(String certType, String cert, String inData, String signValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException, IOException {
        boolean verify = false;
        byte[] certByte = this.base64Decode(cert);
        if ("RSA".equals(certType)) {
            verify = this.verifySignedData(cert, inData, signValue);
        } else if ("ECC".equals(certType)) {
            X509CertificateStructure strcCert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(certByte));
            WrapCard wCard = new WrapCard();
            verify = wCard.vefiySM3WithSM2Sign(inData.getBytes(), strcCert, this.base64Decode(signValue));
        }
        return verify;
    }

    public boolean verifySignedHashData(String certType, String cert, byte[] hash, String signValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException, IOException {
        boolean verify = false;
        byte[] certByte = this.base64Decode(cert);
        if (!"RSA".equals(certType) && "ECC".equals(certType)) {
            X509CertificateStructure strcCert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(certByte));
            WrapCard wCard = new WrapCard();
            verify = wCard.vefiySm2SignWithHashedData(hash, strcCert, this.base64Decode(signValue));
        }
        return verify;
    }

    public byte[] priKeyDecrypt(byte[] encData, byte[] sm2PriKey, PrivateKey rsaPriKey) throws ParameterException, Base64Exception, RsaDecryptException {
        if (sm2PriKey != null && rsaPriKey != null) {
            throw new ParameterException("sm2PriKey\u548crsaPriKey\u4e0d\u80fd\u540c\u65f6\u5b58\u5728");
        }
        if (sm2PriKey == null && rsaPriKey == null) {
            throw new ParameterException("sm2PriKey\u548crsaPriKey\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        byte[] outData = null;
        if (sm2PriKey != null) {
            WrapCard wCard = new WrapCard();
            outData = wCard.sm2Decrypt(sm2PriKey, encData);
        } else if (rsaPriKey != null) {
            RsaUtil rsaUtil = new RsaUtil("");
            outData = rsaUtil.BJK_RsaDecrypt(encData, 4, "", "", null, rsaPriKey, null);
        }
        return outData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generatorP10(String alg, String dn, Object[] keyPairObjects) throws Exception {
        String p10 = "";
        P10Util p10Util = new P10Util("");
        if ("RSA".equals(alg)) {
            if (keyPairObjects == null) throw new Exception("keyPair is invalid");
            if (keyPairObjects.length != 2) throw new Exception("keyPair is invalid");
            return p10Util.p10GeneratorString(dn, (PublicKey)keyPairObjects[0], (PrivateKey)keyPairObjects[1]);
        }
        if (!"ECC".equals(alg)) return p10;
        if (keyPairObjects == null) throw new Exception("keyPair is invalid");
        if (keyPairObjects.length != 1) throw new Exception("keyPair is invalid");
        return p10Util.p10GeneratorString_sm2(dn, (DeviceKeyPair)keyPairObjects[0]);
    }

    public byte[] hashByData(String alg, byte[] dataBytes) {
        return this.hashByData(alg, dataBytes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hashByData(String alg, byte[] dataBytes, String pubInfoStr) {
        if ("SM3".equals(alg.toUpperCase()) || "ECC".equals(alg.toUpperCase())) {
            InputStream in = null;
            byte[] bHash = null;
            try {
                int len22;
                bHash = new byte[32];
                SM3Digest digestU = new SM3Digest();
                if (null != pubInfoStr && !"".equals(pubInfoStr)) {
                    Base64Util base64U = new Base64Util("");
                    ArrayList<byte[]> pubInfoList = new ArrayList<byte[]>();
                    StringTokenizer pubInfoSt = new StringTokenizer(pubInfoStr, "###");
                    while (pubInfoSt.hasMoreElements()) {
                        String pubInfo = pubInfoSt.nextElement().toString();
                        byte[] pubInfoByte = base64U.BJS_DecodeBase64(pubInfo);
                        pubInfoList.add(pubInfoByte);
                    }
                    byte[] xByte = (byte[])pubInfoList.get(0);
                    BigInteger xBigInt = new BigInteger(xByte);
                    byte[] yByte = (byte[])pubInfoList.get(1);
                    BigInteger yBigInt = new BigInteger(yByte);
                    byte[] idByte = (byte[])pubInfoList.get(2);
                    digestU.addId(xBigInt, yBigInt, idByte);
                }
                in = new ByteArrayInputStream(dataBytes);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len22 = in.read(inBytes)) != -1) {
                    digestU.update(inBytes, 0, len22);
                }
                digestU.doFinal(bHash, 0);
                byte[] len22 = bHash;
                return len22;
            }
            catch (Exception e) {
                LoggerUtil.debuglog("all", "Hash file error!", e);
                LoggerUtil.errorlog("all", "Hash file error!", e);
                byte[] blockSize = null;
                return blockSize;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    LoggerUtil.debuglog("all", "Close FileInputStream error!", ex);
                    LoggerUtil.errorlog("all", "Close FileInputStream error!", ex);
                }
            }
        }
        if ("SHA1".equals(alg) || "SHA256".equals(alg)) {
            String algorithm = "SHA1".equals(alg) ? "SHA-1" : "SHA-256";
            InputStream in = null;
            try {
                byte[] hashValue;
                int len;
                MessageDigest md = MessageDigest.getInstance(algorithm);
                in = new ByteArrayInputStream(dataBytes);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len = in.read(inBytes)) != -1) {
                    md.update(inBytes, 0, len);
                }
                byte[] byArray = hashValue = md.digest();
                return byArray;
            }
            catch (Exception e) {
                LoggerUtil.debuglog("all", "Hash file error!", e);
                LoggerUtil.errorlog("all", "Hash file error!", e);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    LoggerUtil.debuglog("all", "Close FileInputStream error!", ex);
                    LoggerUtil.errorlog("all", "Close FileInputStream error!", ex);
                }
            }
        }
        return null;
    }

    public byte[] hashByFile(String alg, String sFilePath) {
        return this.hashByFile(alg, sFilePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hashByFile(String alg, String sFilePath, String pubInfoStr) {
        if ("SM3".equals(alg.toUpperCase()) || "ECC".equals(alg.toUpperCase())) {
            InputStream in = null;
            byte[] bHash = null;
            try {
                int len22;
                bHash = new byte[32];
                SM3Digest digestU = new SM3Digest();
                if (null != pubInfoStr && !"".equals(pubInfoStr)) {
                    Base64Util base64U = new Base64Util("");
                    ArrayList<byte[]> pubInfoList = new ArrayList<byte[]>();
                    StringTokenizer pubInfoSt = new StringTokenizer(pubInfoStr, "###");
                    while (pubInfoSt.hasMoreElements()) {
                        String pubInfo = pubInfoSt.nextElement().toString();
                        byte[] pubInfoByte = base64U.BJS_DecodeBase64(pubInfo);
                        pubInfoList.add(pubInfoByte);
                    }
                    byte[] xByte = (byte[])pubInfoList.get(0);
                    BigInteger xBigInt = new BigInteger(xByte);
                    byte[] yByte = (byte[])pubInfoList.get(1);
                    BigInteger yBigInt = new BigInteger(yByte);
                    byte[] idByte = (byte[])pubInfoList.get(2);
                    digestU.addId(xBigInt, yBigInt, idByte);
                }
                in = new FileInputStream(sFilePath);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len22 = in.read(inBytes)) != -1) {
                    digestU.update(inBytes, 0, len22);
                }
                digestU.doFinal(bHash, 0);
                byte[] len22 = bHash;
                return len22;
            }
            catch (Exception e) {
                LoggerUtil.debuglog("all", "Hash file error!", e);
                LoggerUtil.errorlog("all", "Hash file error!", e);
                byte[] blockSize = null;
                return blockSize;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    LoggerUtil.debuglog("all", "Close FileInputStream error!", ex);
                    LoggerUtil.errorlog("all", "Close FileInputStream error!", ex);
                }
            }
        }
        if ("SHA1".equals(alg) || "SHA256".equals(alg)) {
            String algorithm = "SHA1".equals(alg) ? "SHA-1" : "SHA-256";
            InputStream in = null;
            try {
                byte[] hashValue;
                int len;
                MessageDigest md = MessageDigest.getInstance(algorithm);
                in = new FileInputStream(sFilePath);
                int blockSize = 131072;
                byte[] inBytes = new byte[blockSize];
                while ((len = in.read(inBytes)) != -1) {
                    md.update(inBytes, 0, len);
                }
                byte[] byArray = hashValue = md.digest();
                return byArray;
            }
            catch (Exception e) {
                LoggerUtil.debuglog("all", "Hash file error!", e);
                LoggerUtil.errorlog("all", "Hash file error!", e);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception ex) {
                    LoggerUtil.debuglog("all", "Close FileInputStream error!", ex);
                    LoggerUtil.errorlog("all", "Close FileInputStream error!", ex);
                }
            }
        }
        return null;
    }

    public byte[][] getHashDataFromP7Sign(byte[] p7SignEnvelope) {
        if (p7SignEnvelope == null) {
            throw new IllegalArgumentException("P7\u7b7e\u540d\u503c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        byte[] validP7SignBytes = pkcs7Util.getValidP7Length(p7SignEnvelope);
        byte[][] retValues = new byte[3][];
        DERConstructedSequence constructedSequence = null;
        try {
            constructedSequence = GetP7InfoUtil.getUnauthAttrs(validP7SignBytes);
            DEREncodable tmpObject = constructedSequence.getObjectAt(0);
            if (tmpObject instanceof DERObjectIdentifier) {
                String id = ((DERObjectIdentifier)tmpObject).getId();
                if (id.equals("1.2.156.112562.9.7.1")) {
                    DERConstructedSet valSet = (DERConstructedSet)constructedSequence.getObjectAt(1);
                    DEROctetString octetString = (DEROctetString)valSet.getObjectAt(0);
                    retValues[0] = octetString.getOctets();
                }
            } else if (tmpObject instanceof DERConstructedSequence) {
                for (int i = 0; i < constructedSequence.size(); ++i) {
                    DEROctetString octetString;
                    DERConstructedSet valSet;
                    DERConstructedSequence derSequence = (DERConstructedSequence)constructedSequence.getObjectAt(i);
                    String id = ((DERObjectIdentifier)derSequence.getObjectAt(0)).getId();
                    if (id.equals("1.2.156.112562.9.7.1")) {
                        valSet = (DERConstructedSet)derSequence.getObjectAt(1);
                        octetString = (DEROctetString)valSet.getObjectAt(0);
                        retValues[0] = octetString.getOctets();
                        continue;
                    }
                    if (id.equals("1.2.156.112562.9.7.2")) {
                        valSet = (DERConstructedSet)derSequence.getObjectAt(1);
                        octetString = (DEROctetString)valSet.getObjectAt(0);
                        retValues[1] = octetString.getOctets();
                        continue;
                    }
                    if (!id.equals("1.2.156.112562.9.7.3")) continue;
                    valSet = (DERConstructedSet)derSequence.getObjectAt(1);
                    octetString = (DEROctetString)valSet.getObjectAt(0);
                    retValues[2] = octetString.getOctets();
                }
            }
        }
        catch (Exception e) {
            LoggerUtil.errorlog("all", "\u4eceP7\u4e2d\u83b7\u53d6\u6269\u5c55\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38", e);
        }
        return retValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generatorP10ForDZHT(String alg, String dn, Map extension, Object[] keyPairObjects) throws Exception {
        String p10 = "";
        DERSet extentionSet = null;
        if (extension != null && extension.size() > 0) {
            DEREncodableVector v = new DEREncodableVector();
            for (Map.Entry entry : extension.entrySet()) {
                String oid = (String)entry.getKey();
                String value = (String)entry.getValue();
                DERObjectIdentifier derOid = new DERObjectIdentifier(oid);
                DERUTF8String oidValue = new DERUTF8String(value);
                DERSet asn1Set = new DERSet(oidValue);
                Attribute att = new Attribute(derOid, asn1Set);
                v.add(att);
            }
            extentionSet = new DERSet(v);
        }
        P10Util p10Util = new P10Util("");
        if (alg.contains("RSA")) {
            if (keyPairObjects == null) throw new InvalidKeySpecException("keyPair is invalid");
            if (keyPairObjects.length != 2) throw new InvalidKeySpecException("keyPair is invalid");
            KeyPairUtil KeyPairUtil2 = new KeyPairUtil("");
            PublicKey pubkey = KeyPairUtil2.createPublicKey((byte[])keyPairObjects[0]);
            PrivateKey privateKey = KeyPairUtil2.createPrivateKeyWithKeyEncoded((byte[])keyPairObjects[1]);
            return p10Util.p10GeneratorString(alg, dn, extentionSet, pubkey, privateKey);
        }
        if (!"SM2".equals(alg)) throw new AlgorithmNotFoundException(alg + "is not supported!");
        if (keyPairObjects == null) throw new InvalidKeySpecException("keyPair is invalid");
        if (keyPairObjects.length != 2) throw new InvalidKeySpecException("keyPair is invalid");
        DeviceKeyPair deviceKeyPair = new DeviceKeyPair();
        deviceKeyPair.setPublicKey((byte[])keyPairObjects[0]);
        deviceKeyPair.setPrivateKey((byte[])keyPairObjects[1]);
        return p10Util.p10GeneratorString_sm2(dn, extentionSet, deviceKeyPair);
    }

    public byte[] signHashedDataNoDer(String certType, byte[] hash, byte[] privateKey) throws Exception {
        byte[] signedData = null;
        if ("RSA".equals(certType)) {
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            KeyUtil keyUtil = new KeyUtil("");
            PrivateKey priKey = keyPairUtil.createPrivateKeyWithKeyEncoded(privateKey);
            RSAPrivateCrtKeyParameters privateCrtKey = keyUtil.getPrivateKey(priKey);
            WrapCard wrapCard = new WrapCard();
            signedData = wrapCard.externalSign(privateCrtKey, hash, priKey.getEncoded());
        } else if ("ECC".equals(certType)) {
            WrapCard wCard = new WrapCard();
            signedData = wCard.sm2SignWithHashedDataNoDER(hash, privateKey);
        }
        return signedData;
    }

    public boolean verifySignByHashedDataNoDer(byte[] certBytes, byte[] hashData, byte[] signedDataBytes) throws VerifySignDataException {
        RsaUtil rsaUtil = new RsaUtil("");
        CertificateUtil certU = new CertificateUtil("");
        String certType = certU.BJC_GetBasicCertInfo(certBytes, 31L);
        X509CertificateStructure strcCert = certU.getX509CertStrc(certBytes);
        if ("ECC".endsWith(certType)) {
            try {
                WrapCard wCard = new WrapCard();
                boolean isTrue = wCard.vefiySM3WithSM2SignByHashedDataNoDER(hashData, strcCert, signedDataBytes);
                return isTrue;
            }
            catch (Exception e) {
                LoggerUtil.errorlog("all", "Exception in sm2 signature with hashed Data!", e);
                throw new VerifySignDataException("Exception in sm2 signature with hashed Data!");
            }
        }
        boolean isTrue = rsaUtil.verifySignHashedData(hashData, signedDataBytes, strcCert);
        return isTrue;
    }

    public String p1Sign(byte[] priKeyBytes, String base64Cert, byte[] oriDataBytes, String signAlgIdentifier) throws InvalidKeySpecException, AlgorithmNotFoundException, HashException, IOException {
        byte[] p1Sign = this.p1SignReByte(priKeyBytes, base64Cert, oriDataBytes, signAlgIdentifier);
        if (p1Sign != null) {
            return this.base64Encode(p1Sign);
        }
        return null;
    }

    public byte[] p1SignReByte(byte[] priKeyBytes, String base64Cert, byte[] oriDataBytes, String signAlgIdentifier) throws HashException, InvalidKeySpecException, AlgorithmNotFoundException, IOException {
        WrapCard wrapCard = new WrapCard();
        byte[] p1Sign = null;
        if ("SHA1withRSA".equals(signAlgIdentifier) || "SHA256withRSA".equals(signAlgIdentifier)) {
            byte[] hashData = HashUtil.hash(signAlgIdentifier.replace("withRSA", ""), oriDataBytes, null);
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            KeyUtil keyUtil = new KeyUtil("");
            PrivateKey priKey = keyPairUtil.createPrivateKeyWithKeyEncoded(priKeyBytes);
            p1Sign = wrapCard.externalSign(keyUtil.getPrivateKey(priKey), hashData, priKeyBytes);
        } else if ("SM3withSM2".equals(signAlgIdentifier)) {
            CertificateUtil certUtil = new CertificateUtil("");
            X509CertificateStructure certStr = certUtil.getX509CertStrc(base64Cert);
            byte[] hashData = HashUtil.hash("SM3", oriDataBytes, certStr);
            p1Sign = wrapCard.sm2SignWithHashedData(hashData, priKeyBytes);
        } else {
            throw new AlgorithmNotFoundException(signAlgIdentifier + " is not supported! only support [SHA1withRSA/SHA256withRSA/SM3withSM2]");
        }
        return p1Sign;
    }

    public boolean verifyP1Sign(byte[] oriDataBytes, String p1Sign, String base64Cert, String signAlgIdentifier) throws RsaVerifySignException, IOException, AlgorithmNotFoundException {
        byte[] certBytes = this.base64Decode(base64Cert);
        byte[] p1SignBytes = this.base64Decode(p1Sign);
        if (certBytes == null || p1SignBytes == null) {
            LoggerUtil.errorlog("SecX", "\u8bc1\u4e66\u6570\u636e\u6216\u7b7e\u540d\u6570\u636eBase64\u89e3\u7801\u5931\u8d25![base64Cert=" + base64Cert + ",p1Sign=" + p1Sign + "]");
        }
        return this.verifyP1Sign(oriDataBytes, p1SignBytes, certBytes, signAlgIdentifier);
    }

    public boolean verifyP1Sign(byte[] oriDataBytes, byte[] p1SignBytes, byte[] certBytes, String signAlgIdentifier) throws RsaVerifySignException, IOException, AlgorithmNotFoundException {
        boolean verifyRes = false;
        if ("SHA1withRSA".equals(signAlgIdentifier) || "SHA256withRSA".equals(signAlgIdentifier)) {
            try {
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(certBytes);
                X509Certificate x509Cert = (X509Certificate)oCf.generateCertificate(ois);
                Signature signature = Signature.getInstance(signAlgIdentifier);
                signature.initVerify(x509Cert);
                signature.update(oriDataBytes);
                verifyRes = signature.verify(p1SignBytes);
            }
            catch (Exception e) {
                throw new RsaVerifySignException("RSA Sign verify Exception:" + e.getMessage());
            }
        } else if ("SM3withSM2".equals(signAlgIdentifier)) {
            WrapCard wrapCard = new WrapCard();
            CertificateUtil certUtil = new CertificateUtil("");
            X509CertificateStructure certStr = certUtil.getX509CertStrc(certBytes);
            verifyRes = wrapCard.vefiySM3WithSM2Sign(oriDataBytes, certStr, p1SignBytes);
        } else {
            throw new AlgorithmNotFoundException(signAlgIdentifier + " is not supported! only support [SHA1withRSA/SHA256withRSA/SM3withSM2]");
        }
        return verifyRes;
    }

    public String p7SignAttach(byte[] priKeyBytes, String base64Cert, byte[] oriDataBytes, String signAlgIdentifier) throws HashException, InvalidKeySpecException, AlgorithmNotFoundException, IOException {
        byte[] p7SignBytes;
        block10: {
            byte[] certBytes = this.base64Decode(base64Cert);
            byte[] p1SignBytes = this.p1SignReByte(priKeyBytes, base64Cert, oriDataBytes, signAlgIdentifier);
            if (p1SignBytes == null) {
                LoggerUtil.errorlog("SecX", "p7Sign error:create sign is null!");
                return null;
            }
            boolean isAttach = true;
            p7SignBytes = null;
            if ("SHA1withRSA".equals(signAlgIdentifier) || "SHA256withRSA".equals(signAlgIdentifier)) {
                try {
                    CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream ois = new ByteArrayInputStream(certBytes);
                    X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                    Certificate[] certs = new Certificate[]{oCert};
                    PKCS7SignedData p7sign = new PKCS7SignedData(certs, null, signAlgIdentifier.replace("withRSA", ""), "");
                    if (isAttach) {
                        p7SignBytes = p7sign.getEncoded(p1SignBytes, oriDataBytes);
                        break block10;
                    }
                    p7SignBytes = p7sign.getEncoded(p1SignBytes, null);
                }
                catch (Exception e) {
                    LoggerUtil.errorlog("SecX", "create RSA p7Sign body exception!", e);
                }
            } else if ("SM3withSM2".equals(signAlgIdentifier)) {
                try {
                    X509CertificateStructure x509Cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(certBytes));
                    X509CertificateStructure[] x509Certs = new X509CertificateStructure[]{x509Cert};
                    CNPKCS7SignedData cnP7sign = new CNPKCS7SignedData(x509Certs, null, "SM3", "");
                    p7SignBytes = isAttach ? cnP7sign.getEncoded(p1SignBytes, oriDataBytes) : cnP7sign.getEncoded(p1SignBytes, null);
                }
                catch (Exception e) {
                    LoggerUtil.errorlog("SecX", "create SM2 p7Sign body exception!", e);
                }
            }
        }
        if (p7SignBytes == null) {
            return null;
        }
        return this.base64Encode(p7SignBytes);
    }

    public boolean verifyP7SignAttach(String p7SignAttach) throws Pkcs7VerifySignException {
        return this.verifySignedDataPkcs7(p7SignAttach);
    }

    public String encodeP7EnvelopedData(String base64Cert, byte[] oriDataBytes) throws Pkcs7EncodeEnvelopeException {
        Pkcs7Util pkcs7Util = new Pkcs7Util("");
        Base64Util base64Util = new Base64Util("");
        String type = this.getCertInfo(base64Cert, 31);
        byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
        byte[] p7envdata = null;
        p7envdata = "RSA".equals(type) ? pkcs7Util.BJE_Pkcs7EncodeEnvelope(oriDataBytes, certbuf, 102L) : pkcs7Util.pkcs7EncodeEnvelope_sm2(oriDataBytes, certbuf);
        if (p7envdata == null) {
            return null;
        }
        return base64Util.BJS_EncodeBase64(p7envdata);
    }

    public byte[] decodeP7EnvelopedData(byte[] priKeyBytes, String base64Cert, String p7EnvelopedData) throws Pkcs7DecodeException {
        String certType = this.getCertInfo(base64Cert, 31);
        byte[] certBytes = this.base64Decode(base64Cert);
        byte[] p7EnvelopedBytes = this.base64Decode(p7EnvelopedData);
        byte[] plainDataBytes = null;
        if ("RSA".equals(certType)) {
            try {
                KeyPairUtil keyPairUtil = new KeyPairUtil("");
                PrivateKey priKey = keyPairUtil.createPrivateKeyWithKeyEncoded(priKeyBytes);
                CertificateFactory oCf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream ois = new ByteArrayInputStream(certBytes);
                X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
                PKCS7EnvelopedData pkcs7Envelope = new PKCS7EnvelopedData();
                plainDataBytes = pkcs7Envelope.decrypt(p7EnvelopedBytes, oCert, priKey);
            }
            catch (Exception e) {
                LoggerUtil.errorlog("SecX", "decode RSA p7Envelop exception:" + e.getMessage(), e);
                throw new Pkcs7DecodeException("decode RSA p7Envelop exception:" + e.getMessage());
            }
        }
        if ("ECC".equals(certType)) {
            try {
                Pkcs7Util pkcs7Util = new Pkcs7Util("");
                plainDataBytes = pkcs7Util.pkcs7DecodeEnvelope_sm2(p7EnvelopedBytes, priKeyBytes, certBytes);
            }
            catch (Pkcs7DecodeEnvelopeException e) {
                LoggerUtil.errorlog("SecX", "decode SM2 p7Envelop exception:" + e.getMessage(), e);
                throw new Pkcs7DecodeException("decode SM2 p7Envelop exception:" + e.getMessage());
            }
        }
        return plainDataBytes;
    }

    public byte[] symmEncryptData(byte[] plainDataBytes, byte[] symmKeyBytes, String symmAlg) throws AlgorithmNotFoundException {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] cipherData = null;
        if ("SM4".equals(symmAlg)) {
            byte[] iv = new byte[16];
            for (int i = 0; i < 16; ++i) {
                iv[i] = (byte)(i + 2);
            }
            cipherData = cryptoUtil.encryptData_sm4_cbc_nopadding(symmKeyBytes, iv, plainDataBytes);
        } else if ("T-DES".equals(symmAlg)) {
            cipherData = cryptoUtil.encryptData_3des_ecb(symmKeyBytes, plainDataBytes);
        } else {
            throw new AlgorithmNotFoundException(symmAlg + " not supported! only support [SM4/T-DES]");
        }
        return cipherData;
    }

    public byte[] symmDecryptData(byte[] cipherDataBytes, byte[] symmKeyBytes, String symmAlg) throws AlgorithmNotFoundException {
        CryptoUtil cryptoUtil = new CryptoUtil("");
        byte[] cipherData = null;
        if ("SM4".equals(symmAlg)) {
            byte[] iv = new byte[16];
            for (int i = 0; i < 16; ++i) {
                iv[i] = (byte)(i + 2);
            }
            cipherData = cryptoUtil.decryptData_sm4_cbc_nopadding(symmKeyBytes, iv, cipherDataBytes);
        } else if ("T-DES".equals(symmAlg)) {
            cipherData = cryptoUtil.decryptData_3des_ecb(symmKeyBytes, cipherDataBytes);
        } else {
            throw new AlgorithmNotFoundException(symmAlg + " not supported! only support [SM4/T-DES]");
        }
        return cipherData;
    }

    public byte[] hmacDigest(byte[] plainDataBytes, byte[] keyBytes, String digestAlg) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] hashBytes = null;
        if (!"HmacSHA1".equals(digestAlg) && !"HmacSHA256".equals(digestAlg)) {
            throw new NoSuchAlgorithmException(digestAlg + " not supported! only support [HmacSHA1/HmacSHA256]");
        }
        SecretKeySpec signingKey = new SecretKeySpec(keyBytes, digestAlg);
        Mac mac = Mac.getInstance(digestAlg);
        mac.init(signingKey);
        hashBytes = mac.doFinal(plainDataBytes);
        return hashBytes;
    }

    public String[] parsePFXRSA(File pfxFile, String pfxPass) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        FileInputStream fis = new FileInputStream(pfxFile);
        keyStore.load(fis, pfxPass == null ? null : pfxPass.toCharArray());
        Enumeration<String> aliases = keyStore.aliases();
        String keyAlias = null;
        if (!aliases.hasMoreElements()) {
            LoggerUtil.errorlog("SecX", "PFX\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55keyAlias\uff01");
            return null;
        }
        keyAlias = aliases.nextElement();
        Base64Util base64Util = new Base64Util("");
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, pfxPass == null ? null : pfxPass.toCharArray());
        Certificate certificate = keyStore.getCertificate(keyAlias);
        String base64priKey = base64Util.BJS_EncodeBase64(privateKey.getEncoded());
        String base64Cert = base64Util.BJS_EncodeBase64(certificate.getEncoded());
        return new String[]{base64priKey, base64Cert};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] parsePFXSM2(File pfxFile, String pfxPass) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, NoSuchProviderException {
        Security.removeProvider("BC");
        Security.addProvider((Provider)new org.bjca.bc.jce.provider.BouncyCastleProvider());
        FileInputStream fis = null;
        String base64priKey = null;
        String base64Cert = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12", "BC");
            fis = new FileInputStream(pfxFile);
            keyStore.load(fis, pfxPass == null ? null : pfxPass.toCharArray());
            Enumeration<String> aliases = keyStore.aliases();
            String keyAlias = null;
            if (!aliases.hasMoreElements()) {
                LoggerUtil.errorlog("SecX", "PFX\u4e2d\u4e0d\u5305\u542b\u4efb\u4f55keyAlias\uff01");
                String[] stringArray = null;
                return stringArray;
            }
            keyAlias = aliases.nextElement();
            Base64Util base64Util = new Base64Util("");
            ECPrivateKey privateKey = (ECPrivateKey)keyStore.getKey(keyAlias, pfxPass == null ? null : pfxPass.toCharArray());
            Certificate certificate = keyStore.getCertificate(keyAlias);
            base64priKey = base64Util.BJS_EncodeBase64(privateKey.getD().toByteArray());
            base64Cert = base64Util.BJS_EncodeBase64(certificate.getEncoded());
            Security.removeProvider("BC");
            Security.addProvider(new BouncyCastleProvider());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return new String[]{base64priKey, base64Cert};
    }

    public byte[] asn1X9_9Mac(byte[] key, byte[] data) throws Exception {
        return ASN1Mac.ansiX9_9MAC(key, data);
    }

    public byte[] pboc3Mac(byte[] key, byte[] data, byte[] iv_sm4) throws AlgorithmNotFoundException, InvalidKeyException {
        return PBOCMac.pbocV3Mac(key, data, iv_sm4);
    }

    public static void testPriKeySignAndEnc() throws Exception {
        SecurityUtil securityUtil = SecurityUtil.getInstance();
        File sm2Pfx = new File("C:\\Users\\lishi\\Desktop\\12.pfx");
        File rsaPfx = new File("C:\\Users\\lishi\\Desktop\\11.pfx");
        String[] rsa = securityUtil.parsePFXRSA(rsaPfx, "11111111");
        String sm2PriKey = "a1fNcuBuATw7AMOkFWrPhEmmQCS1SjE8WeC1P3U0kFc=";
        String sm2Cert = "MIIEdDCCBBugAwIBAgIKLRAAAAAAAAVtfTAKBggqgRzPVQGDdTBEMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTENMAsGA1UECwwEQkpDQTEXMBUGA1UEAwwOQmVpamluZyBTTTIgQ0EwHhcNMTYwMTEyMTYwMDAwWhcNMjIwMTEzMTU1OTU5WjB8MRIwEAYDVQQpDAkxMjM0NTY3ODExIjAgBgNVBAMMGURzdnPmlbDlrZfnrb7lkI3mtYvor5VzbTIxETAPBgNVBAsMCDFkc3Zzc20yMQ0wCwYDVQQKDARCSkNBMRMwEQYDVQQKDApkc3ZzdGVzdGVyMQswCQYDVQQGDAJDTjBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABOKwPDJgWmqSIwdoXVUKwNkVMtJyOUNitq9AFxzFZyqv7x+Iw1zcUWJq9WAGTaVooSgSGcudaqSpf1bcYuBGxlGjggK7MIICtzAfBgNVHSMEGDAWgBQf5s/Uj8UiKpdKKYoV5xbJkjTEtjAdBgNVHQ4EFgQUUf6Xdl6N29PZSMIoBkddSDxVsH0wCwYDVR0PBAQDAgbAMIGbBgNVHR8EgZMwgZAwX6BdoFukWTBXMQswCQYDVQQGEwJDTjENMAsGA1UECgwEQkpDQTENMAsGA1UECwwEQkpDQTEXMBUGA1UEAwwOQmVpamluZyBTTTIgQ0ExETAPBgNVBAMTCGNhMjFjcmwyMC2gK6AphidodHRwOi8vY3JsLmJqY2Eub3JnLmNuL2NybC9jYTIxY3JsMi5jcmwwGwYKKoEchu8yAgEBAQQNDAtKSjEyMzQ1Njc4MTBgBggrBgEFBQcBAQRUMFIwIwYIKwYBBQUHMAGGF09DU1A6Ly9vY3NwLmJqY2Eub3JnLmNuMCsGCCsGAQUFBzAChh9odHRwOi8vY3JsLmJqY2Eub3JnLmNuL2NhaXNzdWVyMGwGA1UdIARlMGMwMAYDVR0gMCkwJwYIKwYBBQUHAgEWGyBodHRwOi8vd3d3LmJqY2Eub3JnLmNuL2NwczAvBgNVHSAwKDAmBggrBgEFBQcCARYaaHR0cDovL3d3dy5iamNhLm9yZy5jbi9jcHMwEQYJYIZIAYb4QgEBBAQDAgD/MBkGCiqBHIbvMgIBAQgECwwJMTIzNDU2NzgxMBsGCiqBHIbvMgIBAgIEDQwLSkoxMjM0NTY3ODEwHwYKKoEchu8yAgEBDgQRDA85OTkwMDAxMDAxMTgwMTMwGwYKKoEchu8yAgEBBAQNDAtKSjEyMzQ1Njc4MTAlBgoqgRyG7zICAQEXBBcMFTEyQDIxNTAwOUpKMDEyMzQ1Njc4MTAXBggqgRzQFAQBBAQLDAkxMjM0NTY3ODEwFAYKKoEchu8yAgEBHgQGDAQxMDUwMAoGCCqBHM9VAYN1A0cAMEQCIDirDrNgmm94vQIGRynhX4Qr27Ok6/z8uDb/Bu6x4+G2AiArrk9MUv0TUdARUPZsQyZRRJEkDBrDzpICtCIEszoFJQ==";
        KeyPairUtil keyPairUtil = new KeyPairUtil("");
        byte[] rsaPriKeyBytes = securityUtil.base64Decode(rsa[0]);
        String rsaCert = rsa[1];
        byte[] sm2PriKeyBytes = securityUtil.base64Decode(sm2PriKey);
        String p1Sign = securityUtil.p1Sign(sm2PriKeyBytes, sm2Cert, "123".getBytes(), "SM3withSM2");
        System.out.println("p1Sign=" + p1Sign);
        boolean sm2P1Verify = securityUtil.verifyP1Sign("123".getBytes(), p1Sign, sm2Cert, "SM3withSM2");
        System.out.println("p1Verify=" + sm2P1Verify);
        String p7SignAttach = securityUtil.p7SignAttach(sm2PriKeyBytes, sm2Cert, "123".getBytes(), "SM3withSM2");
        System.out.println("p7Sign=" + p7SignAttach);
        boolean sm2P7Verify = securityUtil.verifyP7SignAttach(p7SignAttach);
        System.out.println("p7Verify=" + sm2P7Verify);
        String p7Envelop = securityUtil.encodeP7EnvelopedData(sm2Cert, "123\u6d4b\u8bd5\u6570\u636e".getBytes());
        byte[] plainData = securityUtil.decodeP7EnvelopedData(sm2PriKeyBytes, sm2Cert, p7Envelop);
        System.out.println("p7EnvelopTest=" + "123\u6d4b\u8bd5\u6570\u636e".equals(new String(plainData)));
        String rsaP1Sign = securityUtil.p1Sign(rsaPriKeyBytes, null, "123".getBytes(), "SHA256withRSA");
        System.out.println("rsaP1Sign=" + rsaP1Sign);
        boolean rsaP1Verify = securityUtil.verifyP1Sign("123".getBytes(), rsaP1Sign, rsaCert, "SHA256withRSA");
        System.out.println("rsaP1Verify=" + rsaP1Verify);
        String rsaP7SignAttach = securityUtil.p7SignAttach(rsaPriKeyBytes, rsaCert, "123".getBytes(), "SHA256withRSA");
        System.out.println("rsaP7Sign=" + rsaP7SignAttach);
        boolean rsaP7Verify = securityUtil.verifyP7SignAttach(rsaP7SignAttach);
        System.out.println("rsaP7Verify=" + rsaP7Verify);
        String rsaP7Envelop = securityUtil.encodeP7EnvelopedData(rsaCert, "123\u6d4b\u8bd5\u6570\u636e".getBytes());
        byte[] rsaPlainData = securityUtil.decodeP7EnvelopedData(rsaPriKeyBytes, rsaCert, rsaP7Envelop);
        System.out.println("rsaP7EnvelopTest=" + "123\u6d4b\u8bd5\u6570\u636e".equals(new String(rsaPlainData)));
        String keyRandom = securityUtil.genRandom(16);
        byte[] symmKey = securityUtil.base64Decode(keyRandom);
        byte[] encData = securityUtil.symmEncryptData("123\u6d4b\u8bd5\u6570\u636e".getBytes(), symmKey, "SM4");
        byte[] plainDa = securityUtil.symmDecryptData(encData, symmKey, "SM4");
        System.out.println("\u5bf9\u79f0\u52a0\u5bc6\u6d4b\u8bd5\u7ed3\u679c\uff1a" + "123\u6d4b\u8bd5\u6570\u636e".equals(new String(plainDa)));
        byte[] hash = securityUtil.hmacDigest("123".getBytes(), "12".getBytes(), "HmacSHA1");
        System.out.println("HmacSHA1:" + Arrays.toString(hash));
    }

    public static void main(String[] args) throws Exception {
        SecurityUtil.testPriKeySignAndEnc();
    }
}

