/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.bjca.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.exception.AppNotfoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.security.SuperEngine;
import xjyb.cn.org.bjca.utils.CRLThread;
import xjyb.cn.org.bjca.utils.GetPathUtil;
import xjyb.cn.org.bjca.utils.P7Thread;
import xjyb.cn.org.bjca.utils.XmlThread;
import xjyb.com.bjca.security.SecurityEngineDeal_oldJava;
import xjyb.com.bjca.security.SecurityEngineDeal_oldJni;
import xjyb.com.bjca.security.exception.SecurityEngineException;
import xjyb.com.bjca.security.exception.VerifyException;

public abstract class SecurityEngineDeal
implements SuperEngine {
    public static String applicationName = "BJCASecXV2Default";

    public static SecurityEngineDeal getInstance() throws FileNotFoundException, JDOMException, IOException, InitException, KeyStoreException, NoSuchAlgorithmException, CertificateException, InitException, AppNotfoundException {
        int deviceType;
        if (GetPathUtil.getBJCAROOT_Path() == null) {
            GetPathUtil.setConfigPath();
        }
        if (XmlConfig.version == null) {
            System.out.println("Secx Version:2.7.2 build201808061400");
            LoggerUtil.systemlog("all", "Secx Version:2.7.2 build201808061400");
            XmlConfig.loadConfig();
            XmlThread xmlThread = new XmlThread();
            xmlThread.start();
            P7Thread p7Thread = new P7Thread();
            p7Thread.start();
            CRLThread crlThread = new CRLThread();
            crlThread.start();
        }
        if ((deviceType = XmlConfig.getWebappsDeviceType(applicationName)) == 0) {
            LoggerUtil.errorlog(applicationName, "Not found that application name !");
            LoggerUtil.debuglog(applicationName, "Not found that application name !");
            throw new AppNotfoundException("Not found that application name !");
        }
        if (listApp.containsKey(applicationName)) {
            return (SecurityEngineDeal)listApp.get(applicationName);
        }
        if (deviceType == 4 || deviceType == 5) {
            LoggerUtil.systemlog("all", applicationName + " \u5e94\u7528\u8fdb\u5165old\u7eafjava\u5165\u53e3\uff01");
            Security.addProvider(new BouncyCastleProvider());
            if (Security.addProvider(new BouncyCastleProvider()) != -1) {
                System.out.println(applicationName + " Add provider failed when old application initialization !");
                LoggerUtil.errorlog(applicationName, applicationName + " Add provider failed when old application initialization !");
                return null;
            }
            SecurityEngineDeal_oldJava safeEngDealJava = new SecurityEngineDeal_oldJava(applicationName);
            listApp.put(applicationName, safeEngDealJava);
            safeEngDealJava.verifyCRL();
            return safeEngDealJava;
        }
        LoggerUtil.systemlog("all", applicationName + " \u5e94\u7528\u8fdb\u5165old JNI\u5165\u53e3\uff01");
        SecurityEngineDeal_oldJni safeEngDealJni = new SecurityEngineDeal_oldJni(applicationName);
        listApp.put(applicationName, safeEngDealJni);
        safeEngDealJni.verifyCRL();
        return safeEngDealJni;
    }

    @Override
    public abstract void initAppValue();

    @Override
    public abstract void initP7Cert();

    @Override
    public abstract String getApplicationName();

    @Override
    public abstract void setDebug(boolean var1) throws InitException;

    public abstract boolean finalizeBjapi();

    public abstract boolean SetContainer(String var1);

    public abstract boolean ChangePin(String var1, String var2);

    public abstract String GetServerCertificate() throws Base64Exception;

    public abstract byte[] GetServerCertificateBytes();

    public abstract String GetSignCertificate() throws Base64Exception;

    public abstract byte[] GetSignCertificateBytes();

    public abstract String GetRandom() throws RandomNumberException, Base64Exception;

    public abstract String GetRandom(int var1) throws RandomNumberException, Base64Exception;

    public abstract byte[] GetRandomBytes(int var1) throws RandomNumberException;

    public abstract boolean SymmEncrypt_SetAlg(String var1);

    public abstract String SymmEncrypt_Encrypt(String var1, byte[] var2);

    public abstract boolean SymmEncrypt_File(String var1, String var2, String var3, long var4);

    public abstract boolean SymmEncrypt_File(String var1, String var2, byte[] var3, long var4);

    public abstract boolean SymmDecrypt_File(String var1, String var2, String var3, long var4);

    public abstract boolean SymmDecrypt_File(String var1, String var2, byte[] var3, long var4);

    public abstract String SymmEncrypt_Encrypt(long var1, String var3, byte[] var4);

    public abstract String SymmEncrypt_Encrypt(String var1, String var2);

    public abstract byte[] SymmEncrypt_Decrypt(String var1, byte[] var2);

    public abstract byte[] SymmEncrypt_Decrypt(long var1, String var3, byte[] var4);

    public abstract byte[] SymmEncrypt_Decrypt(String var1, String var2);

    public abstract String EncryptedData_Encrypt(String var1, String var2);

    public abstract String EncryptedData_Encrypt(String var1, byte[] var2);

    public abstract String EncryptedData_Decrypt(String var1);

    public abstract String EnvelopedData_Encrypt(String var1, String var2);

    public abstract String EnvelopedData_Encrypt(String var1, byte[] var2);

    public abstract String EnvelopedData_Decrypt(String var1);

    public abstract String EnvelopedDataEx_Encrypt(String var1, String var2);

    public abstract String EnvelopedDataEx_Encrypt(String var1, byte[] var2);

    public abstract String EnvelopedDataEx_Decrypt(String var1);

    public abstract String SignedDataByP7_Sign(String var1);

    public abstract String SignedDataByP7_Verify(String var1, String var2) throws SecurityEngineException, VerifyException;

    public abstract String SignedData_Sign(String var1);

    public abstract String SignedFile_Sign(String var1);

    public abstract boolean SignedData_Verify(String var1, String var2, String var3) throws SecurityEngineException, VerifyException;

    public abstract boolean SignedData_Verify(String var1, String var2, byte[] var3) throws SecurityEngineException, VerifyException;

    public abstract boolean SignedData_Verify(byte[] var1, int var2, String var3, String var4) throws SecurityEngineException, VerifyException;

    public abstract boolean SignedFile_Verify(String var1, String var2, String var3) throws SecurityEngineException, VerifyException;

    public abstract boolean Certificate_IsValid(String var1) throws SecurityEngineException, VerifyException;

    public abstract int Certificate_CheckValidaty(String var1, String var2);

    public abstract String Certificate_GetUniqIdOidByCAId(String var1);

    public abstract String Certificate_GetInfo(String var1, long var2);

    public abstract String Certificate_GetExtInfo(String var1, String var2);

    public abstract String EncodedData_EncodeBase64(byte[] var1);

    public abstract byte[] EncodedData_DecodeBase64(String var1);

    public abstract String HashData(long var1, byte[] var3);

    public abstract String TimeStamp_Request(byte[] var1, long var2);

    public abstract String TimeStamp_Response(String var1);

    public abstract String TimeStamp_GetInfo(String var1, int var2);

    public abstract String TimeStamp_Verify(String var1, String var2) throws SecurityEngineException, VerifyException;

    public abstract String SignedDataXML_Sign(String var1);

    public abstract boolean SignedDataXML_Verify(String var1);

    public abstract String getXMLSignatureInfo(String var1, int var2) throws JDOMException;

    public abstract String GetPlainInPut(String var1, String var2);

    public abstract String GetPlainInPut2(String var1, String var2);

    public abstract String SecertSegment(String var1, int var2, int var3, int var4);

    public abstract String SecertRecovery(String var1);
}

