/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.client.protocol;

import java.io.IOException;
import xjyb.org.apache.http.HttpEntity;
import xjyb.org.apache.http.HttpEntityEnclosingRequest;
import xjyb.org.apache.http.HttpException;
import xjyb.org.apache.http.HttpRequest;
import xjyb.org.apache.http.HttpRequestInterceptor;
import xjyb.org.apache.http.HttpVersion;
import xjyb.org.apache.http.ProtocolVersion;
import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.client.config.RequestConfig;
import xjyb.org.apache.http.client.protocol.HttpClientContext;
import xjyb.org.apache.http.protocol.HttpContext;
import xjyb.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

