/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.crmf;

import java.util.Enumeration;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.crmf.OptionalValidity;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;

public class CertTemplate
extends ASN1Encodable {
    private DERInteger version;
    private DERInteger serialNumber;
    private AlgorithmIdentifier signingAlg;
    private X509Name issuer;
    private OptionalValidity validity;
    private X509Name subject;
    private SubjectPublicKeyInfo publicKey;
    private DERBitString issuerUID;
    private DERBitString subjectUID;
    private X509Extensions extensions;

    private CertTemplate(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        block12: while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            switch (tObj.getTagNo()) {
                case 0: {
                    this.version = DERInteger.getInstance(tObj, false);
                    continue block12;
                }
                case 1: {
                    this.serialNumber = DERInteger.getInstance(tObj, false);
                    continue block12;
                }
                case 2: {
                    this.signingAlg = AlgorithmIdentifier.getInstance(tObj, false);
                    continue block12;
                }
                case 3: {
                    this.issuer = X509Name.getInstance(tObj, true);
                    continue block12;
                }
                case 4: {
                    this.validity = OptionalValidity.getInstance(ASN1Sequence.getInstance(tObj, false));
                    continue block12;
                }
                case 5: {
                    this.subject = X509Name.getInstance(tObj, true);
                    continue block12;
                }
                case 6: {
                    this.publicKey = SubjectPublicKeyInfo.getInstance(tObj, false);
                    continue block12;
                }
                case 7: {
                    this.issuerUID = DERBitString.getInstance(tObj, false);
                    continue block12;
                }
                case 8: {
                    this.subjectUID = DERBitString.getInstance(tObj, false);
                    continue block12;
                }
                case 9: {
                    this.extensions = X509Extensions.getInstance(tObj, false);
                    continue block12;
                }
            }
            throw new IllegalArgumentException("unknown tag: " + tObj.getTagNo());
        }
    }

    public static CertTemplate getInstance(Object o) {
        if (o instanceof CertTemplate) {
            return (CertTemplate)o;
        }
        if (o instanceof ASN1Sequence) {
            return new CertTemplate((ASN1Sequence)o);
        }
        throw new IllegalArgumentException("Invalid object: " + o.getClass().getName());
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        this.addOptional(v, 0, false, this.version);
        this.addOptional(v, 1, false, this.serialNumber);
        this.addOptional(v, 2, false, this.signingAlg);
        this.addOptional(v, 3, true, this.issuer);
        this.addOptional(v, 4, false, this.validity);
        this.addOptional(v, 5, true, this.subject);
        this.addOptional(v, 6, false, this.publicKey);
        this.addOptional(v, 7, false, this.issuerUID);
        this.addOptional(v, 8, false, this.subjectUID);
        this.addOptional(v, 9, false, this.extensions);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, boolean isExplicit, ASN1Encodable obj) {
        if (obj != null) {
            v.add(new DERTaggedObject(isExplicit, tagNo, obj));
        }
    }
}

