/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.x509;

import java.util.Enumeration;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERGeneralizedTime;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.x509.X509Extension;

public class PrivateKeyUsagePeriod
extends ASN1Encodable {
    private DERGeneralizedTime _notBefore;
    private DERGeneralizedTime _notAfter;

    public static PrivateKeyUsagePeriod getInstance(Object obj) {
        if (obj instanceof PrivateKeyUsagePeriod) {
            return (PrivateKeyUsagePeriod)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PrivateKeyUsagePeriod((ASN1Sequence)obj);
        }
        if (obj instanceof X509Extension) {
            return PrivateKeyUsagePeriod.getInstance(X509Extension.convertValueToObject((X509Extension)obj));
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    private PrivateKeyUsagePeriod(ASN1Sequence seq) {
        Enumeration en = seq.getObjects();
        while (en.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)en.nextElement();
            if (tObj.getTagNo() == 0) {
                this._notBefore = DERGeneralizedTime.getInstance(tObj, false);
                continue;
            }
            if (tObj.getTagNo() != 1) continue;
            this._notAfter = DERGeneralizedTime.getInstance(tObj, false);
        }
    }

    public DERGeneralizedTime getNotBefore() {
        return this._notBefore;
    }

    public DERGeneralizedTime getNotAfter() {
        return this._notAfter;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this._notBefore != null) {
            v.add(new DERTaggedObject(false, 0, this._notBefore));
        }
        if (this._notAfter != null) {
            v.add(new DERTaggedObject(false, 1, this._notAfter));
        }
        return new DERSequence(v);
    }
}

