/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.Mac;
import xjyb.org.bjca.crypto.PBEParametersGenerator;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.macs.HMac;
import xjyb.org.bjca.crypto.params.KeyParameter;
import xjyb.org.bjca.crypto.params.ParametersWithIV;

public class PKCS5S2ParametersGenerator
extends PBEParametersGenerator {
    private Mac hMac = new HMac(new SHA1Digest());

    private void F(byte[] P, byte[] S, int c, byte[] iBuf, byte[] out, int outOff) {
        byte[] state = new byte[this.hMac.getMacSize()];
        KeyParameter param = new KeyParameter(P);
        this.hMac.init(param);
        if (S != null) {
            this.hMac.update(S, 0, S.length);
        }
        this.hMac.update(iBuf, 0, iBuf.length);
        this.hMac.doFinal(state, 0);
        System.arraycopy(state, 0, out, outOff, state.length);
        if (c == 0) {
            throw new IllegalArgumentException("iteration count must be at least 1.");
        }
        for (int count = 1; count < c; ++count) {
            this.hMac.init(param);
            this.hMac.update(state, 0, state.length);
            this.hMac.doFinal(state, 0);
            for (int j = 0; j != state.length; ++j) {
                int n = outOff + j;
                out[n] = (byte)(out[n] ^ state[j]);
            }
        }
    }

    private void intToOctet(byte[] buf, int i) {
        buf[0] = (byte)(i >>> 24);
        buf[1] = (byte)(i >>> 16);
        buf[2] = (byte)(i >>> 8);
        buf[3] = (byte)i;
    }

    private byte[] generateDerivedKey(int dkLen) {
        int hLen = this.hMac.getMacSize();
        int l = (dkLen + hLen - 1) / hLen;
        byte[] iBuf = new byte[4];
        byte[] out = new byte[l * hLen];
        for (int i = 1; i <= l; ++i) {
            this.intToOctet(iBuf, i);
            this.F(this.password, this.salt, this.iterationCount, iBuf, out, (i - 1) * hLen);
        }
        return out;
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize) {
        byte[] dKey = this.generateDerivedKey(keySize /= 8);
        return new KeyParameter(dKey, 0, keySize);
    }

    @Override
    public CipherParameters generateDerivedParameters(int keySize, int ivSize) {
        byte[] dKey = this.generateDerivedKey((keySize /= 8) + (ivSize /= 8));
        return new ParametersWithIV(new KeyParameter(dKey, 0, keySize), dKey, keySize, ivSize);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int keySize) {
        return this.generateDerivedParameters(keySize);
    }
}

