/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.paddings;

import java.security.SecureRandom;
import xjyb.org.bjca.crypto.InvalidCipherTextException;
import xjyb.org.bjca.crypto.paddings.BlockCipherPadding;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom random;

    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
        this.random = random != null ? random : new SecureRandom();
    }

    @Override
    public String getPaddingName() {
        return "ISO10126-2";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        byte code = (byte)(in.length - inOff);
        while (inOff < in.length - 1) {
            in[inOff] = (byte)this.random.nextInt();
            ++inOff;
        }
        in[inOff] = code;
        return code;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count = in[in.length - 1] & 0xFF;
        if (count > in.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return count;
    }
}

