/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.sm4soft.crypto;

import xjyb.org.bjca.sm4soft.crypto.ParameterException;
import xjyb.org.bjca.sm4soft.sm4.SM4;

public class SM4Crypto {
    private static final SM4 engine = new SM4();
    public static final int ECB = 1;
    public static final int CBC = 2;

    public byte[] encrypt(int mode, byte[] key, byte[] iv, byte[] plain) throws ParameterException {
        if (mode != 1 && mode != 2) {
            throw new ParameterException("\u4e0d\u652f\u6301\u7684\u53cd\u9988(" + mode + ")");
        }
        if (key == null) {
            throw new ParameterException("\u5bc6\u94a5\u53c2\u6570\u4e3a\u7a7a");
        }
        if (key.length != 16) {
            throw new ParameterException("\u5bc6\u94a5\u957f\u5ea6(" + key.length + ")\u975e\u6cd5");
        }
        if (plain == null) {
            throw new ParameterException("\u660e\u6587\u53c2\u6570\u4e3a\u7a7a");
        }
        if (plain.length % 16 != 0) {
            throw new ParameterException("\u660e\u6587\u957f\u5ea6(" + key.length + ")\u4e0d\u662f\u5206\u7ec4\u957f\u5ea6\u6574\u6570\u500d");
        }
        if (mode != 1) {
            if (iv == null) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u53c2\u6570\u4e3a\u7a7a");
            }
            if (iv.length != 16) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u957f\u5ea6(" + iv.length + ")\u975e\u6cd5");
            }
        }
        byte[] nextIV = (byte[])iv.clone();
        byte[] out = new byte[plain.length];
        byte[] block = new byte[16];
        for (int i = 0; i < plain.length; i += 16) {
            System.arraycopy(plain, i, block, 0, 16);
            if (mode == 2) {
                block = this.XOR(block, nextIV);
            }
            block = engine.processBlock(true, key, block);
            if (mode == 2) {
                nextIV = (byte[])block.clone();
            }
            System.arraycopy(block, 0, out, i, 16);
        }
        return out;
    }

    public byte[] encrypt_pkcs5(int mode, byte[] key, byte[] iv, byte[] plain) throws ParameterException {
        plain = this.packData(plain);
        if (mode != 1 && mode != 2) {
            throw new ParameterException("\u4e0d\u652f\u6301\u7684\u53cd\u9988(" + mode + ")");
        }
        if (key == null) {
            throw new ParameterException("\u5bc6\u94a5\u53c2\u6570\u4e3a\u7a7a");
        }
        if (key.length != 16) {
            throw new ParameterException("\u5bc6\u94a5\u957f\u5ea6(" + key.length + ")\u975e\u6cd5");
        }
        if (plain == null) {
            throw new ParameterException("\u660e\u6587\u53c2\u6570\u4e3a\u7a7a");
        }
        if (plain.length % 16 != 0) {
            throw new ParameterException("\u660e\u6587\u957f\u5ea6(" + key.length + ")\u4e0d\u662f\u5206\u7ec4\u957f\u5ea6\u6574\u6570\u500d");
        }
        if (mode != 1) {
            if (iv == null) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u53c2\u6570\u4e3a\u7a7a");
            }
            if (iv.length != 16) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u957f\u5ea6(" + iv.length + ")\u975e\u6cd5");
            }
        }
        byte[] nextIV = (byte[])iv.clone();
        byte[] out = new byte[plain.length];
        byte[] block = new byte[16];
        for (int i = 0; i < plain.length; i += 16) {
            System.arraycopy(plain, i, block, 0, 16);
            if (mode == 2) {
                block = this.XOR(block, nextIV);
            }
            block = engine.processBlock(true, key, block);
            if (mode == 2) {
                nextIV = (byte[])block.clone();
            }
            System.arraycopy(block, 0, out, i, 16);
        }
        return out;
    }

    private byte[] XOR(byte[] x, byte[] y) {
        for (int i = 0; i < x.length; ++i) {
            x[i] = (byte)(x[i] ^ y[i]);
        }
        return x;
    }

    public byte[] decrypt(int mode, byte[] key, byte[] iv, byte[] plain) throws ParameterException {
        if (mode != 1 && mode != 2) {
            throw new ParameterException("\u4e0d\u652f\u6301\u7684\u53cd\u9988(" + mode + ")");
        }
        if (key == null) {
            throw new ParameterException("\u5bc6\u94a5\u53c2\u6570\u4e3a\u7a7a");
        }
        if (key.length != 16) {
            throw new ParameterException("\u5bc6\u94a5\u957f\u5ea6(" + key.length + ")\u975e\u6cd5");
        }
        if (plain == null) {
            throw new ParameterException("\u5bc6\u6587\u53c2\u6570\u4e3a\u7a7a");
        }
        if (plain.length % 16 != 0) {
            throw new ParameterException("\u5bc6\u6587\u957f\u5ea6(" + key.length + ")\u4e0d\u662f\u5206\u7ec4\u957f\u5ea6\u6574\u6570\u500d");
        }
        if (mode != 1) {
            if (iv == null) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u53c2\u6570\u4e3a\u7a7a");
            }
            if (iv.length != 16) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u957f\u5ea6(" + iv.length + ")\u975e\u6cd5");
            }
        }
        byte[] nextIV = (byte[])iv.clone();
        byte[] out = new byte[plain.length];
        byte[] block = new byte[16];
        for (int i = 0; i < plain.length; i += 16) {
            System.arraycopy(plain, i, block, 0, 16);
            block = engine.processBlock(false, key, block);
            if (mode == 2) {
                block = this.XOR(block, nextIV);
                System.arraycopy(plain, i, nextIV, 0, 16);
            }
            System.arraycopy(block, 0, out, i, 16);
        }
        return out;
    }

    public byte[] decrypt_pkcs5(int mode, byte[] key, byte[] iv, byte[] plain) throws ParameterException {
        if (mode != 1 && mode != 2) {
            throw new ParameterException("\u4e0d\u652f\u6301\u7684\u53cd\u9988(" + mode + ")");
        }
        if (key == null) {
            throw new ParameterException("\u5bc6\u94a5\u53c2\u6570\u4e3a\u7a7a");
        }
        if (key.length != 16) {
            throw new ParameterException("\u5bc6\u94a5\u957f\u5ea6(" + key.length + ")\u975e\u6cd5");
        }
        if (plain == null) {
            throw new ParameterException("\u5bc6\u6587\u53c2\u6570\u4e3a\u7a7a");
        }
        if (plain.length % 16 != 0) {
            throw new ParameterException("\u5bc6\u6587\u957f\u5ea6(" + key.length + ")\u4e0d\u662f\u5206\u7ec4\u957f\u5ea6\u6574\u6570\u500d");
        }
        if (mode != 1) {
            if (iv == null) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u53c2\u6570\u4e3a\u7a7a");
            }
            if (iv.length != 16) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u957f\u5ea6(" + iv.length + ")\u975e\u6cd5");
            }
        }
        byte[] nextIV = (byte[])iv.clone();
        byte[] out = new byte[plain.length];
        byte[] block = new byte[16];
        for (int i = 0; i < plain.length; i += 16) {
            System.arraycopy(plain, i, block, 0, 16);
            block = engine.processBlock(false, key, block);
            if (mode == 2) {
                block = this.XOR(block, nextIV);
                System.arraycopy(plain, i, nextIV, 0, 16);
            }
            System.arraycopy(block, 0, out, i, 16);
        }
        out = this.dePackData(out);
        return out;
    }

    public byte[] decrypt_pkcs5_forJit(int mode, byte[] key, byte[] iv, byte[] plain) throws ParameterException {
        if (mode != 1 && mode != 2) {
            throw new ParameterException("\u4e0d\u652f\u6301\u7684\u53cd\u9988(" + mode + ")");
        }
        if (key == null) {
            throw new ParameterException("\u5bc6\u94a5\u53c2\u6570\u4e3a\u7a7a");
        }
        if (key.length != 16) {
            throw new ParameterException("\u5bc6\u94a5\u957f\u5ea6(" + key.length + ")\u975e\u6cd5");
        }
        if (plain == null) {
            throw new ParameterException("\u5bc6\u6587\u53c2\u6570\u4e3a\u7a7a");
        }
        if (plain.length % 16 != 0) {
            throw new ParameterException("\u5bc6\u6587\u957f\u5ea6(" + key.length + ")\u4e0d\u662f\u5206\u7ec4\u957f\u5ea6\u6574\u6570\u500d");
        }
        if (mode != 1) {
            if (iv == null) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u53c2\u6570\u4e3a\u7a7a");
            }
            if (iv.length != 16) {
                throw new ParameterException("\u521d\u59cb\u5316\u5411\u91cf\u957f\u5ea6(" + iv.length + ")\u975e\u6cd5");
            }
        }
        byte[] nextIV = (byte[])iv.clone();
        byte[] out = new byte[plain.length];
        byte[] block = new byte[16];
        for (int i = 0; i < plain.length; i += 16) {
            System.arraycopy(plain, i, block, 0, 16);
            block = engine.processBlock(false, key, block);
            if (mode == 2) {
                block = this.XOR(block, nextIV);
                System.arraycopy(plain, i, nextIV, 0, 16);
            }
            System.arraycopy(block, 0, out, i, 16);
        }
        out = this.dePackDataGA(out);
        return out;
    }

    public byte[] packData(byte[] inData) {
        int inDataLen = inData.length;
        int fillNum = 0;
        fillNum = inDataLen < 16 ? 16 - inDataLen : 16 - inDataLen % 16;
        if (fillNum == 0) {
            fillNum = 16;
        }
        byte[] fillData = new byte[fillNum];
        for (int i = 0; i < fillNum; ++i) {
            fillData[i] = (byte)fillNum;
        }
        byte[] outData = new byte[inDataLen + fillNum];
        System.arraycopy(inData, 0, outData, 0, inDataLen);
        System.arraycopy(fillData, 0, outData, inDataLen, fillNum);
        return outData;
    }

    public byte[] dePackData(byte[] inData) {
        int inDataLen = inData.length;
        byte fillNum = inData[inDataLen - 1];
        int outLen = inDataLen - fillNum;
        byte[] outData = new byte[outLen];
        for (int i = 0; i < outLen; ++i) {
            outData[i] = inData[i];
        }
        return outData;
    }

    public byte[] dePackDataGA(byte[] inData) {
        int outLen = 64;
        byte[] outData = new byte[32];
        for (int i = 32; i < outLen; ++i) {
            outData[i - 32] = inData[i];
        }
        return outData;
    }
}

