/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.impl.service;

import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.ByteArrayMultipartFile;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileBase64VO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileByteVO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.service.IVoucherBaseFunction;
import com.ygsoft.abc.eepsp.satellite.client.openapi.service.IVoucherParseService;
import com.ygsoft.abc.eepsp.satellite.client.openapi.tools.XmlUtil;
import com.ygsoft.abc.eepsp.service.explain.common.bo.BaseResponseBO;
import com.ygsoft.abc.eepsp.service.explain.common.type.ElecVoucherBOEnum;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.EleVoucherParseFactory;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.IEleVoucherParseStrategy;
import com.ygsoft.abc.eepsp.service.explain.voucher.impl.service.VoucherBillParseService;
import com.ygsoft.abc.service.annotation.TLog;
import java.io.IOException;
import java.util.Base64;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class VoucherParseService
implements IVoucherParseService,
IVoucherBaseFunction {
    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- \u89e3\u6790\u7535\u5b50\u51ed\u8bc1\u3002")
    public BaseResponseBO parse(MultipartFile file) {
        BaseResponseBO checkResult = this.checkFile(file);
        if (checkResult.isError()) {
            return checkResult;
        }
        String parseFileName = file.getOriginalFilename();
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance((String)parseFileName);
        ElecVoucherBOEnum voucherType = instance.getElecVoucherBOEunm(file);
        JSONObject parseVoucher = null;
        parseVoucher = null == voucherType ? instance.parseVoucher(file, null) : instance.parseVoucher(file, voucherType.getConfigId());
        if (null == parseVoucher) {
            return BaseResponseBO.error((String)"\u7535\u5b50\u51ed\u8bc1\u89e3\u6790\u5931\u8d25\u3002");
        }
        return BaseResponseBO.success((Object)parseVoucher);
    }

    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- \u89e3\u6790\u7535\u5b50\u51ed\u8bc1\u3002")
    public BaseResponseBO parseForBase64(FileBase64VO fileBase64VO) {
        BaseResponseBO checkResult = this.checkFileBase64VO(fileBase64VO);
        if (checkResult.isError()) {
            return checkResult;
        }
        ByteArrayMultipartFile file = ByteArrayMultipartFile.createFrom(Base64.getDecoder().decode(fileBase64VO.getFileInBase64()), fileBase64VO.getFileName());
        return this.parse(file);
    }

    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- \u89e3\u6790\u7535\u5b50\u51ed\u8bc1\u3002")
    public BaseResponseBO parseForByte(FileByteVO fileByteVO) {
        BaseResponseBO checkResult = this.checkFileByteVO(fileByteVO);
        if (checkResult.isError()) {
            return checkResult;
        }
        ByteArrayMultipartFile file = ByteArrayMultipartFile.createFrom(fileByteVO.getFileInBytes(), fileByteVO.getFileName());
        return this.parse(file);
    }

    @Override
    public Object parseAllelec(MultipartFile file) {
        String parseFileName = file.getOriginalFilename();
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance((String)parseFileName);
        return instance.getAllElec(file);
    }

    @Override
    public Object parseNotGwSpecialVat(MultipartFile file) {
        String parseFileName = file.getOriginalFilename();
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance((String)parseFileName);
        return instance.getNotGwSpecialVat(file);
    }

    @Override
    public BaseResponseBO parseFiscalBills(MultipartFile file) {
        return new VoucherBillParseService().parseFiscalBills(file);
    }

    @Override
    public BaseResponseBO parseDigEleVat(MultipartFile file) {
        BaseResponseBO checkResult = this.checkFile(file);
        if (checkResult.isError()) {
            return checkResult;
        }
        try {
            JSONObject jsonObject = XmlUtil.xml2Json(file);
            return BaseResponseBO.success((Object)jsonObject);
        }
        catch (IOException e) {
            return BaseResponseBO.error((String)"\u7535\u5b50\u51ed\u8bc1\u89e3\u6790\u5931\u8d25\u3002");
        }
    }

    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- json\u8f6cxbrl\u3002")
    public BaseResponseBO json2Xbrl(MultipartFile file, String configId) {
        return new VoucherBillParseService().json2Xbrl(file, configId);
    }

    @Override
    public BaseResponseBO xbrl2Json(MultipartFile file, String configId) {
        return new VoucherBillParseService().xbrl2Json(file, configId);
    }

    @Override
    public BaseResponseBO parseHnFiscalBills(MultipartFile file) {
        return new VoucherBillParseService().parseHnFiscalBills(file);
    }

    @Override
    public BaseResponseBO parseEntryEVoucher(MultipartFile file) {
        return new VoucherBillParseService().parseEntryEVoucher(file);
    }
}

