/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.util;

import com.ygsoft.abc.eepsp.satellite.client.openapi.exception.AbcIOException;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public final class BlockIOUtil {
    private static final int BUFFER_SIZE = 0x100000;

    private BlockIOUtil() {
    }

    public static void write(byte[] data, String filePath) {
        try (FileOutputStream output = new FileOutputStream(filePath);){
            IOUtils.write((byte[])data, (OutputStream)output);
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream input) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            BlockIOUtil.copy(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static long copy(InputStream input, OutputStream output) {
        try {
            int byteRead;
            byte[] buf = new byte[0x100000];
            long size = 0L;
            while ((byteRead = input.read(buf)) != -1) {
                output.write(buf, 0, byteRead);
                size += (long)byteRead;
            }
            return size;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("IO\u5f02\u5e38\u3002");
        }
    }
}

