/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1Null;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1TaggedObject;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.asn1.DERTaggedObject;
import cn.org.bjca.gaia.asn1.pkcs.PrivateKeyInfo;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x9.X962Parameters;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.jce.interfaces.ECPrivateKey;
import cn.org.bjca.gaia.jce.spec.ECParameterSpec;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.ec.FixedPointCombMultiplier;
import cn.org.bjca.gaia.util.BigIntegers;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTPublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Params;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTObjectIdentifiers;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class GMTPrivateKey
implements ECPrivateKey,
GMTKey {
    private static final long serialVersionUID = -3613783346296166756L;
    private final ECParameterSpec sm2ParameterSpec = SM2Params.sm2ParameterSpec;
    private final BigInteger dInt;
    private final byte[] dBytes;
    private final byte[] zvalue;
    private GMTPublicKey pubKey = null;

    public static GMTPrivateKey getInstance(byte[] encoded) {
        return new GMTPrivateKey(encoded);
    }

    public GMTPrivateKey(byte[] encoding) {
        if (encoding == null) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        switch (encoding.length) {
            case 32: {
                this.dInt = this.dIntegerFrom(encoding);
                break;
            }
            case 96: {
                this.dInt = this.dIntegerFrom(encoding);
                byte[] bPubX = new byte[32];
                byte[] bPubY = new byte[32];
                System.arraycopy(encoding, 32, bPubX, 0, 32);
                System.arraycopy(encoding, 64, bPubY, 0, 32);
                this.pubKey = new GMTPublicKey(bPubX, bPubY);
                break;
            }
            default: {
                this.dInt = this.dIntegerFrom(encoding);
            }
        }
        if (this.pubKey == null) {
            this.pubKey = GMTPrivateKey.buildPublicKey(this.dInt);
        }
        this.dBytes = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.dInt);
        this.zvalue = this.pubKey.getZvalue();
    }

    public GMTPrivateKey(byte[] dBytes, byte[] bPubX, byte[] bPubY) {
        if (dBytes == null) {
            throw new IllegalArgumentException("null not allowed for dBytes");
        }
        this.dInt = new BigInteger(1, dBytes);
        this.dBytes = dBytes;
        this.pubKey = bPubX != null && bPubY != null ? new GMTPublicKey(bPubX, bPubY) : GMTPrivateKey.buildPublicKey(this.dInt);
        this.zvalue = this.pubKey.getZvalue();
    }

    public GMTPrivateKey(BigInteger d, BigInteger iPubX, BigInteger iPubY) {
        if (d == null) {
            throw new IllegalArgumentException("null not allowed for d");
        }
        this.dInt = d;
        this.dBytes = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)d);
        this.pubKey = iPubX != null && iPubY != null ? new GMTPublicKey(iPubX, iPubY) : GMTPrivateKey.buildPublicKey(d);
        this.zvalue = this.pubKey.getZvalue();
    }

    public GMTPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        this(ecPrivateKeyParameters, null);
    }

    public GMTPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters, ECPublicKeyParameters ecPublicKeyParameters) {
        if (ecPrivateKeyParameters == null) {
            throw new IllegalArgumentException("null not allowed for ecPrivateKeyParameters");
        }
        if (!SM2Params.sm2DomainParameters.equals((Object)ecPrivateKeyParameters.getParameters())) {
            throw new IllegalArgumentException("domainParameters not allowed for ecPrivateKeyParameters");
        }
        this.dInt = ecPrivateKeyParameters.getD();
        this.dBytes = BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.dInt);
        if (ecPublicKeyParameters == null) {
            this.pubKey = GMTPrivateKey.buildPublicKey(this.dInt);
        } else {
            if (!SM2Params.sm2DomainParameters.equals((Object)ecPublicKeyParameters.getParameters())) {
                throw new IllegalArgumentException("domainParameters not allowed for ecPublicKeyParameters");
            }
            this.pubKey = new GMTPublicKey(ecPublicKeyParameters);
        }
        this.zvalue = this.pubKey.getZvalue();
    }

    private final BigInteger dIntegerFrom(byte[] encoding) {
        BigInteger d = null;
        if (encoding.length != 32 && encoding.length != 96) {
            try {
                byte[] value;
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoding);
                if (seq.size() < 3) {
                    throw new SecurityException("encoding not valid");
                }
                AlgorithmIdentifier aid = AlgorithmIdentifier.getInstance((Object)seq.getObjectAt(1));
                if (!X9ObjectIdentifiers.id_ecPublicKey.equals((Object)aid.getAlgorithm())) {
                    throw new SecurityException("encoding algorithm not valid");
                }
                ASN1Encodable param = aid.getParameters();
                if (param != null && !Arrays.equals(value = param.toASN1Primitive().getEncoded(), DERNull.INSTANCE.getEncoded()) && !Arrays.equals(value, GMTObjectIdentifiers.sm2.getEncoded())) {
                    throw new SecurityException("encoding parameters not valid");
                }
                ASN1Encodable context = seq.getObjectAt(2);
                if (!(context instanceof DEROctetString)) {
                    throw new RuntimeException("encoding context type not valid");
                }
                d = this.dIntegerFrom((DEROctetString)context);
            }
            catch (Exception var7) {
                throw new RuntimeException("encoding not valid", var7);
            }
        } else {
            byte[] value = new byte[32];
            System.arraycopy(encoding, 0, value, 0, 32);
            d = new BigInteger(1, value);
        }
        return d;
    }

    private final BigInteger dIntegerFrom(DEROctetString encoding) {
        BigInteger d = null;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)encoding.getOctets());
        if (seq.size() < 2) {
            throw new SecurityException("encoding context not valid");
        }
        ASN1Encodable value = seq.getObjectAt(1);
        if (value instanceof ASN1Integer) {
            d = ((ASN1Integer)value).getPositiveValue();
        } else {
            if (!(value instanceof ASN1OctetString)) {
                throw new SecurityException("encoding context#d not valid");
            }
            d = new BigInteger(1, ((ASN1OctetString)value).getOctets());
        }
        try {
            int size = seq.size();
            for (int i = 2; i < size; ++i) {
                ASN1TaggedObject tag;
                value = seq.getObjectAt(i);
                if (!(value instanceof ASN1TaggedObject) || (tag = (ASN1TaggedObject)value).getTagNo() != 1) continue;
                DERBitString k = DERBitString.getInstance((Object)tag.getObject());
                this.pubKey = new GMTPublicKey(k.getBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public byte[] getEncoded() {
        return this.getEncoded(false);
    }

    public byte[] getEncoded(boolean x962Format) {
        try {
            DERSequence value = null;
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1Integer(1L));
            if (x962Format) {
                v.add((ASN1Encodable)new DEROctetString(BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.dInt)));
            } else {
                v.add((ASN1Encodable)new ASN1Integer(this.dInt));
            }
            if (this.pubKey != null) {
                byte[] encoding = new byte[65];
                encoding[0] = 4;
                System.arraycopy(this.pubKey.getPubX(), 0, encoding, 1, 32);
                System.arraycopy(this.pubKey.getPubY(), 0, encoding, 33, 32);
                v.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERBitString(encoding)));
            }
            value = new DERSequence(v);
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1Integer(0L));
            v.add((ASN1Encodable)new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)GMTObjectIdentifiers.sm2));
            v.add((ASN1Encodable)new DEROctetString((ASN1Encodable)value));
            return new DERSequence(v).getEncoded();
        }
        catch (IOException var5) {
            throw new RuntimeException("SM2PrivateKey encoding failure ", var5);
        }
    }

    public byte[] getEncoding() {
        try {
            X962Parameters params = new X962Parameters((ASN1Null)DERNull.INSTANCE);
            cn.org.bjca.gaia.asn1.sec.ECPrivateKey keyStructure = new cn.org.bjca.gaia.asn1.sec.ECPrivateKey(this.getDByInt(), (ASN1Encodable)params);
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)params), (ASN1Encodable)keyStructure);
            return info.getEncoded("DER");
        }
        catch (Exception var4) {
            throw new RuntimeException("SM2PrivateKey encoding failure ", var4);
        }
    }

    public void setSM2PublicKey(GMTPublicKey pubKey) {
    }

    public GMTPublicKey getSM2PublicKey() {
        return this.pubKey;
    }

    public BigInteger getD() {
        return this.dInt;
    }

    public BigInteger getDByInt() {
        return this.dInt;
    }

    public byte[] getD_Bytes() {
        return (byte[])this.dBytes.clone();
    }

    public byte[] getDByBytes() {
        return (byte[])this.dBytes.clone();
    }

    public byte[] getDByBytesWithPublicKey() {
        byte[] encoded = null;
        if (this.pubKey != null) {
            encoded = new byte[96];
            System.arraycopy(this.getDByBytes(), 0, encoded, 0, 32);
            System.arraycopy(this.pubKey.getPubXByBytes(), 0, encoded, 32, 32);
            System.arraycopy(this.pubKey.getPubYByBytes(), 0, encoded, 64, 32);
        } else {
            encoded = new byte[32];
            System.arraycopy(this.getDByBytes(), 0, encoded, 0, 32);
        }
        return encoded;
    }

    public byte[] getZvalue() {
        return (byte[])this.zvalue.clone();
    }

    public ECParameterSpec getParams() {
        return this.sm2ParameterSpec;
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    private static GMTPublicKey buildPublicKey(BigInteger d) {
        ECDomainParameters params = SM2Params.sm2DomainParameters;
        FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
        ECPoint Q = multiplier.multiply(params.getG(), d).normalize();
        return new GMTPublicKey(new ECPublicKeyParameters(Q, params));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dInt == null ? 0 : this.dInt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GMTPrivateKey other = (GMTPrivateKey)obj;
        return !(this.dInt == null ? other.dInt != null : !this.dInt.equals(other.dInt));
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2 Private Key: ");
        buffer.append(separator);
        buffer.append("D:");
        if (this.dInt != null) {
            buffer.append(this.dInt.toString(16));
        }
        if (this.pubKey != null) {
            buffer.append(separator);
            buffer.append(this.pubKey);
        }
        return buffer.toString();
    }

    public final BigInteger dBigInteger() {
        return this.dInt;
    }

    @Override
    public final byte[] getDefaultZ() {
        return (byte[])this.zvalue.clone();
    }
}

