/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.jce.interfaces.ECPublicKey;
import cn.org.bjca.gaia.jce.spec.ECParameterSpec;
import cn.org.bjca.gaia.math.ec.ECPoint;
import com.ygsoft.abc.mapp.ygca.algorithm.common.GMTKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Params;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTBigIntegerUtil;
import com.ygsoft.abc.mapp.ygca.algorithm.util.GMTObjectIdentifiers;
import java.math.BigInteger;

public class GMTPublicKey
implements ECPublicKey,
GMTKey {
    private final ECParameterSpec sm2ParameterSpec;
    private static final long serialVersionUID = -4714957801525215906L;
    private byte[] bPubX;
    private byte[] bPubY;
    private BigInteger iPubX;
    private BigInteger iPubY;
    private boolean withCompression;
    private final ECPoint Q;
    private final byte[] zvalue;

    public GMTPublicKey(byte[] encoded) {
        byte[] coding;
        block8: {
            this.sm2ParameterSpec = SM2Params.sm2ParameterSpec;
            this.bPubX = null;
            this.bPubY = null;
            this.iPubX = null;
            this.iPubY = null;
            this.withCompression = false;
            if (encoded != null && encoded.length >= 64) {
                coding = null;
                if (encoded.length != 64 && encoded.length != 65) {
                    try {
                        AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)GMTObjectIdentifiers.sm2);
                        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)encoded);
                        if (!aid.equals((Object)info.getAlgorithm())) {
                            throw new SecurityException("encoded not valid");
                        }
                        coding = info.getPublicKeyData().getBytes();
                        if (coding.length != 65) {
                            throw new SecurityException("encoded not valid");
                        }
                        break block8;
                    }
                    catch (SecurityException var5) {
                        throw var5;
                    }
                    catch (Exception var6) {
                        throw new RuntimeException("encoded not valid", var6);
                    }
                }
                coding = (byte[])encoded.clone();
            } else {
                throw new IllegalArgumentException("null not allowed for encoded");
            }
        }
        int offset = encoded.length == 64 ? 0 : 1;
        this.bPubX = new byte[32];
        this.bPubY = new byte[32];
        System.arraycopy(coding, offset, this.bPubX, 0, this.bPubX.length);
        System.arraycopy(coding, offset += this.bPubY.length, this.bPubY, 0, this.bPubY.length);
        this.iPubX = new BigInteger(1, this.bPubX);
        this.iPubY = new BigInteger(1, this.bPubY);
        this.Q = this.sm2ParameterSpec.getCurve().createPoint(this.iPubX, this.iPubY).normalize();
        this.zvalue = SM2Params.calcZ(this.bPubX, this.bPubY);
    }

    public GMTPublicKey(byte[] bPubX, byte[] bPubY) {
        this.sm2ParameterSpec = SM2Params.sm2ParameterSpec;
        this.bPubX = null;
        this.bPubY = null;
        this.iPubX = null;
        this.iPubY = null;
        this.withCompression = false;
        if (bPubX == null) {
            throw new IllegalArgumentException("null not allowed for bPubX");
        }
        if (bPubY == null) {
            throw new IllegalArgumentException("null not allowed for bPubY");
        }
        this.Q = this.createPoint(null, new BigInteger(1, bPubX), new BigInteger(1, bPubY));
        this.zvalue = SM2Params.calcZ(bPubX, bPubY);
    }

    public GMTPublicKey(BigInteger iPubX, BigInteger iPubY) {
        this.sm2ParameterSpec = SM2Params.sm2ParameterSpec;
        this.bPubX = null;
        this.bPubY = null;
        this.iPubX = null;
        this.iPubY = null;
        this.withCompression = false;
        this.Q = this.createPoint(null, iPubX, iPubY);
        this.zvalue = SM2Params.calcZ(this.bPubX, this.bPubY);
    }

    public GMTPublicKey(ECPublicKeyParameters ecParams) {
        this.sm2ParameterSpec = SM2Params.sm2ParameterSpec;
        this.bPubX = null;
        this.bPubY = null;
        this.iPubX = null;
        this.iPubY = null;
        this.withCompression = false;
        if (ecParams == null) {
            throw new IllegalArgumentException("null not allowed for ecParams");
        }
        if (!SM2Params.sm2DomainParameters.equals((Object)ecParams.getParameters())) {
            throw new IllegalArgumentException("domainParameters not allowed for ecParams");
        }
        this.Q = this.createPoint(ecParams.getQ(), null, null);
        this.zvalue = SM2Params.calcZ(this.bPubX, this.bPubY);
    }

    private final ECPoint createPoint(ECPoint point, BigInteger iPubX, BigInteger iPubY) {
        ECPoint Q = null;
        if (point != null) {
            Q = point.normalize();
            this.iPubX = Q.getXCoord().toBigInteger();
            this.iPubY = Q.getYCoord().toBigInteger();
        } else {
            if (iPubX == null) {
                throw new IllegalArgumentException("null not allowed for iPubX");
            }
            if (iPubY == null) {
                throw new IllegalArgumentException("null not allowed for iPubY");
            }
            this.iPubX = iPubX;
            this.iPubY = iPubY;
            Q = this.sm2ParameterSpec.getCurve().createPoint(iPubX, iPubY);
        }
        this.bPubX = GMTBigIntegerUtil.asUnsigned32ByteArray(this.iPubX);
        this.bPubY = GMTBigIntegerUtil.asUnsigned32ByteArray(this.iPubY);
        return Q;
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)GMTObjectIdentifiers.sm2);
            byte[] encoded = new byte[65];
            encoded[0] = 4;
            System.arraycopy(this.bPubX, 0, encoded, 1, 32);
            System.arraycopy(this.bPubY, 0, encoded, 33, 32);
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(algorithm, encoded);
            return info.getEncoded("DER");
        }
        catch (Exception var4) {
            throw new RuntimeException("Encoded Failure for SM2PublicKey", var4);
        }
    }

    public ECPoint getQ() {
        return this.Q;
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public byte[] getPubX() {
        return (byte[])this.bPubX.clone();
    }

    public BigInteger getPubX_Int() {
        return this.iPubX;
    }

    public byte[] getPubXByBytes() {
        return (byte[])this.bPubX.clone();
    }

    public BigInteger getPubXByInt() {
        return this.iPubX;
    }

    public byte[] getPubY() {
        return (byte[])this.bPubY.clone();
    }

    public BigInteger getPubY_Int() {
        return this.iPubY;
    }

    public byte[] getPubYByBytes() {
        return (byte[])this.bPubY.clone();
    }

    public BigInteger getPubYByInt() {
        return this.iPubY;
    }

    public byte[] getZvalue() {
        return (byte[])this.zvalue.clone();
    }

    public boolean isWithCompression() {
        return this.withCompression;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public ECParameterSpec getParams() {
        return this.sm2ParameterSpec;
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.iPubX == null ? 0 : this.iPubX.hashCode());
        result = 31 * result + (this.iPubY == null ? 0 : this.iPubY.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GMTPublicKey other = (GMTPublicKey)obj;
        if (this.iPubX == null ? other.iPubX != null : !this.iPubX.equals(other.iPubX)) {
            return false;
        }
        return !(this.iPubY == null ? other.iPubY != null : !this.iPubY.equals(other.iPubY));
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2 Public Key: ");
        buffer.append(separator);
        buffer.append("X:");
        if (this.iPubX != null) {
            buffer.append(this.iPubX.toString(16));
        }
        buffer.append(separator);
        buffer.append("Y:");
        if (this.iPubY != null) {
            buffer.append(this.iPubY.toString(16));
        }
        return buffer.toString();
    }

    @Override
    public final byte[] getDefaultZ() {
        return (byte[])this.zvalue.clone();
    }

    public final byte[] calcZ(byte[] userId) {
        return SM2Params.calcZ(this.bPubX, this.bPubY, userId);
    }

    public byte[] xBytes() {
        return (byte[])this.bPubX.clone();
    }

    public byte[] yBytes() {
        return (byte[])this.bPubY.clone();
    }
}

