/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.util;

import com.ygsoft.abc.mapp.ygca.algorithm.common.Mechanism;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;

public class KeyUtil {
    private static final String PRIVATEKEY = "PRIVATE KEY";
    private static final String PUBLICKEY = "PUBLIC KEY";
    private static final int notPemFormat = 0;
    private static final int isPemFormat = 1;

    public static final Key generateKey(Mechanism keyType, byte[] keyData) {
        try {
            String type = keyType.getMechanismType();
            SecretKeySpec symmetricKey = null;
            if ("DESede".equals(type)) {
                if (keyData.length != 24) {
                    throw new RuntimeException("generateKey Failure: DES3 KEY must be 24 bytes");
                }
                symmetricKey = new SecretKeySpec(keyData, type);
            } else if ("SM4".equals(type)) {
                if (keyData.length != 16) {
                    throw new RuntimeException("generateKey Failure: SM4 KEY must be 16 bytes");
                }
                symmetricKey = new SecretKeySpec(keyData, type);
            } else {
                if (!type.equals("RC4")) {
                    throw new RuntimeException("generateKey Failure: do not support this key type:" + type);
                }
                if (keyData.length != 16) {
                    throw new RuntimeException("generateKey Failure: RC4 KEY must be 16 bytes");
                }
                symmetricKey = new SecretKeySpec(keyData, type);
            }
            return symmetricKey;
        }
        catch (Exception var4) {
            throw new RuntimeException(var4);
        }
    }
}

