/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.util;

import cn.org.bjca.gaia.util.Arrays;
import com.ygsoft.abc.mapp.ygca.algorithm.common.ASN1SM2Signature;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PrivateKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2PublicKey;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Result;
import com.ygsoft.abc.mapp.ygca.algorithm.util.Base64;
import com.ygsoft.abc.mapp.ygca.algorithm.util.BigIntegerKit;
import com.ygsoft.abc.mapp.ygca.crypto.BCSoftSM2;
import java.math.BigInteger;
import java.security.Key;

public class SM2PackageUtil {
    public static byte[] encryptByBC(byte[] digestData, Key privateKey) throws Exception {
        byte[] sign = new byte[64];
        if (digestData != null && digestData.length == 32) {
            SM2PrivateKey key = null;
            if (privateKey instanceof SM2PrivateKey) {
                key = (SM2PrivateKey)((Object)privateKey);
                BCSoftSM2 bcSoftSM2 = new BCSoftSM2();
                SM2Result sm2Ret = new SM2Result();
                bcSoftSM2.sign(digestData, key.getDByInt(), sm2Ret);
                System.arraycopy(BigIntegerKit.asUnsigned32ByteArray(sm2Ret.r), 0, sign, 0, 32);
                System.arraycopy(BigIntegerKit.asUnsigned32ByteArray(sm2Ret.s), 0, sign, 32, 32);
                return sign;
            }
            throw new RuntimeException("The private key type is not sm2 type!");
        }
        throw new Exception("the digest data is null or not 32 bytes!");
    }

    public static boolean verifyByBC(byte[] digestData, byte[] signValue, Key publicKey) throws Exception {
        System.out.println("digestData:" + Base64.toBase64String(digestData));
        System.out.println("signValue:" + Base64.toBase64String(signValue));
        System.out.println("publicKey:" + Base64.toBase64String(publicKey.getEncoded()));
        if (digestData != null && digestData.length == 32) {
            ASN1SM2Signature signature;
            SM2Result sm2Ret = null;
            if (signValue != null && signValue.length == 64) {
                sm2Ret = new SM2Result();
                sm2Ret.r = new BigInteger(1, Arrays.copyOfRange((byte[])signValue, (int)0, (int)32));
                sm2Ret.s = new BigInteger(1, Arrays.copyOfRange((byte[])signValue, (int)32, (int)64));
            } else {
                if (!ASN1SM2Signature.isASN1SignType(signValue)) {
                    throw new Exception("the signature data is null or not 64 bytes!");
                }
                signature = new ASN1SM2Signature(signValue);
                sm2Ret = new SM2Result();
                sm2Ret.r = signature.getR().getPositiveValue();
                sm2Ret.s = signature.getS().getPositiveValue();
            }
            signature = null;
            SM2PublicKey sm2PubKey = publicKey instanceof SM2PublicKey ? (SM2PublicKey)((Object)publicKey) : new SM2PublicKey(publicKey.getEncoded());
            BCSoftSM2 sm2 = new BCSoftSM2();
            return sm2.verify(digestData, sm2PubKey.getQ(), sm2Ret);
        }
        throw new Exception("the digest data is null or not 32 bytes!");
    }

    public static final byte[] encryptByJNI(byte[] digestData, BigInteger da) throws Exception {
        throw new RuntimeException("\u4e0d\u652f\u6301\u64cd\u4f5c");
    }

    public static boolean verifyByJNI(byte[] digestData, byte[] signValue, byte[] pubX, byte[] pubY) throws Exception {
        throw new RuntimeException("\u4e0d\u652f\u6301\u64cd\u4f5c");
    }
}

