/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.asn1.parser;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DEROutputStream;
import cn.org.bjca.gaia.util.encoders.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ASN1Parser {
    public static byte[] parseDERObj2Bytes(ASN1Encodable obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream((OutputStream)bos);
        try {
            dos.writeObject(obj);
            return bos.toByteArray();
        }
        catch (Exception var4) {
            throw new RuntimeException("\u8bfb\u53d6\u5931\u8d25\u3002", var4);
        }
    }

    public static ASN1Object parseBytes2DERObj(byte[] data) {
        ASN1Primitive var2;
        ASN1InputStream in = null;
        try {
            in = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));
            var2 = in.readObject();
        }
        catch (Exception var11) {
            throw new RuntimeException("\u8bfb\u53d6\u5931\u8d25\u3002", var11);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var10) {
                    throw new RuntimeException("Parsed DERData failure", var10);
                }
            }
        }
        return var2;
    }

    public static ASN1Sequence parseOCT2SEQ(ASN1OctetString asn1oct) {
        ASN1Sequence var2;
        ASN1InputStream in = null;
        try {
            in = new ASN1InputStream((InputStream)new ByteArrayInputStream(asn1oct.getOctets()));
            var2 = (ASN1Sequence)in.readObject();
        }
        catch (Exception var11) {
            throw new RuntimeException("\u8bfb\u53d6\u5931\u8d25\u3002", var11);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException var10) {
                    throw new RuntimeException("Parsed DERData failure", var10);
                }
            }
        }
        return var2;
    }

    public static byte[] deleteCRLF(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        return bos.toByteArray();
    }

    public static final ASN1Sequence getDERSequenceFrom(byte[] encoding) {
        try {
            byte[] data;
            if (ASN1Parser.isDERSequence(encoding)) {
                return ASN1Sequence.getInstance((Object)encoding);
            }
            if (ASN1Parser.isBERSequence(encoding)) {
                return ASN1Sequence.getInstance((Object)encoding);
            }
            try {
                data = Base64.decode((byte[])encoding);
            }
            catch (Exception var3) {
                throw new RuntimeException("encoding required base64 encoding", var3);
            }
            return ASN1Sequence.getInstance((Object)data);
        }
        catch (RuntimeException var4) {
            throw var4;
        }
        catch (Exception var5) {
            throw new RuntimeException("encoding required DERSequence encoding", var5);
        }
    }

    public static final boolean isBERSequence(byte[] encoding) {
        if (encoding == null) {
            throw new RuntimeException("encoding should not be null");
        }
        if (encoding.length < 4) {
            throw new RuntimeException("encoding length less than 4");
        }
        if (encoding[0] != 48) {
            return false;
        }
        int offset = 1;
        byte var10001 = (byte)offset;
        int var3 = offset + 1;
        int length = encoding[var10001] & 0xFF;
        if (length != 128) {
            return false;
        }
        return encoding[encoding.length - 1] == 0 && encoding[encoding.length - 2] == 0;
    }

    public static final boolean isDERSequence(byte[] encoding) {
        int length;
        if (encoding == null) {
            throw new RuntimeException("encoding should not be null");
        }
        if (encoding.length < 2) {
            throw new RuntimeException("encoding length less than 4");
        }
        if (encoding[0] != 48) {
            return false;
        }
        int offset = 1;
        if ((length = encoding[++offset] & 0xFF) == 128) {
            return false;
        }
        if (length > 127) {
            int dLength = length & 0x7F;
            if (dLength > 4) {
                return false;
            }
            length = 0;
            int next = 0;
            for (int i = 0; i < dLength; ++i) {
                next = encoding[offset++] & 0xFF;
                length = (length << 8) + next;
            }
            if (length < 0) {
                return false;
            }
        }
        return encoding.length == offset + length;
    }
}

