/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwca.client;

import com.uccs.CertUtils;
import com.uccs.CertUtilsImpl;
import com.uccs.Certservice;
import com.uccs.CertserviceImpl;
import com.ygsoft.abc.mapp.ygca.gwca.domain.vo.HashCalculateRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwca.domain.vo.HashSignVerifyRequestVO;
import com.ygsoft.abc.mapp.ygca.gwca.domain.vo.ResponseVO;
import com.ygsoft.abc.mapp.ygca.gwca.domain.vo.SignTimeRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignVerifyRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.TransIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xjyb.com.alibaba.fastjson.JSONObject;

public class GwcaClient {
    private static final Logger LOG = LoggerFactory.getLogger(GwcaClient.class);
    private static boolean isGw6 = false;

    private ResponseVO checkRespResult(String json) {
        if (StringUtil.isBlank(json)) {
            throw new RuntimeException("\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        ResponseVO resp = (ResponseVO)JSONObject.parseObject((String)json, ResponseVO.class);
        if (!resp.successed()) {
            throw new RuntimeException(resp.getMessage());
        }
        return resp;
    }

    public SignVerifyRespDataVO hashSignVerify(HashSignVerifyRequestVO signVerifyRequestVO) {
        signVerifyRequestVO.check();
        String transId = TransIdUtil.next();
        String serviceCode = signVerifyRequestVO.getServiceCode();
        String reqDocHash = signVerifyRequestVO.getReqDocHash();
        String signValue = signVerifyRequestVO.getSignValue();
        String signCert = signVerifyRequestVO.getSignCert();
        String json = isGw6 ? CertserviceImpl.getInstance().hashSignVerify(transId, serviceCode, reqDocHash, signValue, signCert) : Certservice.getInstance().hashSignVerify(transId, serviceCode, reqDocHash, signValue, signCert);
        LOG.info("--->hashSignVerify:" + json);
        this.checkRespResult(json);
        ResponseVO respEntity = (ResponseVO)JSONObject.parseObject((String)json, ResponseVO.class);
        if (respEntity.getData() != null) {
            return (SignVerifyRespDataVO)JSONObject.parseObject((String)respEntity.getData(), SignVerifyRespDataVO.class);
        }
        return null;
    }

    public HashCalculateRespDataVO hashCalc(String reqDoc, String cert) {
        if (StringUtil.isBlank(reqDoc)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1areqDoc\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isBlank(cert)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1acert\u4e3a\u7a7a\u3002");
        }
        String json = isGw6 ? CertUtilsImpl.getInstance().hashCalc(reqDoc, cert) : CertUtils.getInstance().hashCalc(reqDoc, cert);
        LOG.info("--->hashCalc:" + json);
        this.checkRespResult(json);
        ResponseVO respEntity = (ResponseVO)JSONObject.parseObject((String)json, ResponseVO.class);
        if (respEntity.getData() != null) {
            return (HashCalculateRespDataVO)JSONObject.parseObject((String)respEntity.getData(), HashCalculateRespDataVO.class);
        }
        return null;
    }

    public SignTimeRespDataVO getSignTime(String signValue) {
        String json = isGw6 ? CertUtilsImpl.getInstance().getSignTime(signValue) : CertUtils.getInstance().getSignTime(signValue);
        LOG.info("--->getSignTime:" + json);
        ResponseVO respEntity = (ResponseVO)JSONObject.parseObject((String)json, ResponseVO.class);
        if (respEntity.getData() != null) {
            return (SignTimeRespDataVO)JSONObject.parseObject((String)respEntity.getData(), SignTimeRespDataVO.class);
        }
        return null;
    }

    static {
        try {
            Class.forName("com.owca.LICENSE");
            isGw6 = true;
        }
        catch (ClassNotFoundException e) {
            isGw6 = false;
        }
        LOG.info("isGw6: " + isGw6);
    }
}

