/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.domain.vo;

import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignInfoVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.X509CertDTO;
import com.ygsoft.abc.mapp.ygca.gwcw.util.DateUtil;
import java.io.Serializable;

public class SignInfoDTO
implements Serializable {
    private static final long serialVersionUID = -6026200363941625097L;
    private String signTime;
    private X509CertDTO certInfo;

    public SignInfoDTO() {
    }

    public SignInfoDTO(X509CertDTO certInfo) {
        this.certInfo = certInfo;
    }

    public SignInfoDTO(X509CertDTO certInfo, String signTime) {
        this.certInfo = certInfo;
        this.signTime = signTime;
    }

    public static SignInfoDTO createFrom(SignInfoVO signInfoVO) {
        if (null == signInfoVO) {
            return null;
        }
        SignInfoDTO dto = new SignInfoDTO();
        dto.setSignTime(DateUtil.format(signInfoVO.getSignTime()));
        dto.setCertInfo(X509CertDTO.createFrom(signInfoVO.getCertInfo()));
        return dto;
    }

    public SignInfoVO convert() {
        SignInfoVO signInfoVO = new SignInfoVO();
        signInfoVO.setSignTime(DateUtil.parse(this.getSignTime()));
        signInfoVO.setCertInfo(this.getCertInfo() == null ? null : this.getCertInfo().convert());
        return signInfoVO;
    }

    public String getSignTime() {
        return this.signTime;
    }

    public void setSignTime(String signTime) {
        this.signTime = signTime;
    }

    public X509CertDTO getCertInfo() {
        return this.certInfo;
    }

    public void setCertInfo(X509CertDTO certInfo) {
        this.certInfo = certInfo;
    }

    public String toString() {
        return "SignInfoDTO [signTime=" + this.signTime + ", certInfo=" + this.certInfo + "]";
    }
}

