/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd;

import com.ygsoft.abc.mapp.ygca.gwcw.common.config.ConfigTool;
import com.ygsoft.abc.mapp.ygca.gwcw.util.GmUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreException;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreFactory;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert.CertTools;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.ContentInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.OIDs;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignedData;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignerInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.VerifyInfo;
import java.security.GeneralSecurityException;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1Set;
import org.bouncycastle162.asn1.x509.Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GBT35275ValidateExt {
    private static final Logger LOG = LoggerFactory.getLogger(GBT35275ValidateExt.class);

    public static VerifyInfo validate(String alg, byte[] tbsContent, byte[] signedValue) throws GeneralSecurityException {
        ContentInfo contentInfo = ContentInfo.getInstance(signedValue);
        if (contentInfo == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790ContentInfo\u7ed3\u6784");
        }
        if (!OIDs.signedData.equals((Object)contentInfo.getContentType())) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u7b7e\u540d\u6570\u636e\u7c7b\u578b\uff0c\u7c7b\u578b\uff1a" + contentInfo.getContentType());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        if (signedData == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7b7e\u540d\u503c\u683c\u5f0f\uff0c\u4e0d\u7b26 GBT35275");
        }
        for (ASN1Encodable item : signedData.getSignerInfos()) {
            byte[] signature;
            SignerInfo signerInfo = SignerInfo.getInstance(item);
            IssuerAndSerialNumber iaSn = signerInfo.getIssuerAngSerialNumber();
            Certificate c = signedData.getSignCert(iaSn);
            if (c == null) {
                return VerifyInfo.Err("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u8bc1\u4e66\u65e0\u6cd5\u9a8c\u8bc1\u7b7e\u540d");
            }
            java.security.cert.Certificate cert = CertTools.toJavaCert(c);
            byte[] originData = GBT35275ValidateExt.getAttriBytes(signerInfo);
            if (!GmUtil.verifySm3WithSm2(originData, signature = signerInfo.getEncryptedDigest().getOctets(), cert.getPublicKey())) {
                return VerifyInfo.Err("\u7b7e\u540d\u503c\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            }
            if (!ConfigTool.checkCert()) continue;
            try {
                CertificateStoreFactory.getInstance().verify(CertTools.toJavaCert(c));
            }
            catch (CertificateStoreException e) {
                LOG.error("\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u4e0d\u901a\u8fc7\u3002", (Throwable)e);
                return VerifyInfo.Err("\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            }
        }
        return VerifyInfo.OK();
    }

    private static byte[] getAttriBytes(SignerInfo signerInfo) throws GeneralSecurityException {
        try {
            ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
            if (authAttributes != null) {
                return authAttributes.toASN1Primitive().getEncoded();
            }
            throw new GeneralSecurityException("\u7b7e\u540d\u6458\u8981\u5c5e\u6027\u4fe1\u606f\u7f3a\u5931");
        }
        catch (Exception e) {
            if (e instanceof GeneralSecurityException) {
                throw (GeneralSecurityException)e;
            }
            throw new GeneralSecurityException("\u83b7\u53d6\u7b7e\u540d\u6458\u8981\u5c5e\u6027\u5931\u8d25", e);
        }
    }
}

