/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd;

import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyListSignResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateAbstractContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateProxyContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidatorExt;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.OFDValidator;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.OFDVerifyException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDValidateUtil {
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VerifyResultVO verifyOfd(File ofdFile, OFDValidateAbstractContainer validateContainer) {
        FileInputStream is = null;
        byte[] fileData = null;
        try {
            is = new FileInputStream(ofdFile);
            fileData = IOUtil.toByteArray(is);
        }
        catch (IOException e) {
            try {
                LOG.warn("ofd file not exits", (Throwable)e);
                new VerifyListSignResultVO(YesnoEnum.NSP, "OFD\u6587\u4ef6\u4e0d\u5b58\u5728", null);
            }
            catch (Throwable throwable) {
                OFDValidateUtil.close(is);
                throw throwable;
            }
            OFDValidateUtil.close(is);
        }
        OFDValidateUtil.close(is);
        return OFDValidateUtil.verifyOfd(fileData, validateContainer);
    }

    private static void close(Closeable ... closeable) {
        if (closeable != null) {
            for (Closeable o : closeable) {
                if (o == null) continue;
                try {
                    o.close();
                }
                catch (IOException e) {
                    LOG.warn("close error", (Throwable)e);
                }
            }
        }
    }

    public static VerifyResultVO verifyOfd(byte[] fileData, OFDValidateAbstractContainer validateContainer) {
        VerifyListSignResultVO listSignResult = OFDValidateUtil.verifyOfdList(fileData, validateContainer);
        return VerifyResultVO.from(listSignResult);
    }

    public static VerifyListSignResultVO verifyOfdList(byte[] fileData, OFDValidateAbstractContainer validateContainer) {
        YesnoEnum success = YesnoEnum.NSP;
        String errorMsg = null;
        if (validateContainer == null) {
            validateContainer = new OFDValidateProxyContainer();
        }
        try {
            OFDValidatorExt ofdValidator = new OFDValidatorExt(fileData);
            ofdValidator.setValidator(validateContainer);
            ofdValidator.exeValidate();
            success = YesnoEnum.YES;
            LOG.info(String.format("verifyOfd success with cert: %s", validateContainer.getSignInfoS()));
        }
        catch (Exception e) {
            if (e instanceof OFDVerifyException) {
                errorMsg = e.getMessage();
                if (errorMsg.contains("\u9a8c\u8bc1\u4e0d\u901a\u8fc7")) {
                    success = YesnoEnum.NO;
                }
            } else {
                errorMsg = "OFD\u9a8c\u7b7e\u4e0d\u652f\u6301";
            }
            LOG.warn(String.format("verifyOfd fail with cert: %s", validateContainer.getSignInfoS()), (Throwable)e);
        }
        return new VerifyListSignResultVO(success, errorMsg, validateContainer.getSignInfoS());
    }

    public static boolean verifyOfd2(String ofdPath) {
        boolean success = false;
        try {
            OFDReader ofdReader = new OFDReader(ofdPath);
            OFDValidator ofdValidator = new OFDValidator(ofdReader);
            OFDValidateProxyContainer validateContainer = new OFDValidateProxyContainer();
            ofdValidator.setValidator(validateContainer);
            ofdValidator.exeValidate();
            success = true;
            LOG.info(String.format("verifyOfd file: %s, success", ofdPath));
        }
        catch (Exception e) {
            LOG.warn(String.format("verifyOfd file: %s, fail", ofdPath), (Throwable)e);
            success = false;
        }
        return success;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        LOG = LoggerFactory.getLogger(OFDValidateUtil.class);
    }
}

