/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.validator.xbrl;

import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import com.ygsoft.abc.mapp.ygca.algorithm.common.PKCS7SignedData;
import com.ygsoft.abc.mapp.ygca.algorithm.util.Base64;
import com.ygsoft.abc.mapp.ygca.exception.VerifyRuntimeException;
import com.ygsoft.abc.mapp.ygca.gwca.client.GwcaClientFactory;
import com.ygsoft.abc.mapp.ygca.gwca.domain.vo.HashSignVerifyRequestVO;
import com.ygsoft.abc.mapp.ygca.gwca.domain.vo.SignTimeRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.common.config.ConfigTool;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignInfoVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignVerifyRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.X509CertVO;
import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.ZipUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreException;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.certstore.CertificateStoreFactory;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert.CertTools;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xjyb.org.bjca.sm4soft.util.ByteUtil;

public class XbrlValidator {
    private static final Logger LOG = LoggerFactory.getLogger(XbrlValidator.class);

    public static VerifyResultVO verifyXbrl(byte[] zipData) {
        if (zipData == null) {
            return new VerifyResultVO(YesnoEnum.NSP, "\u53c2\u6570\u9519\u8bef\uff1a\u6587\u4ef6\u4e3a\u7a7a\u3002", null);
        }
        try {
            Map<String, byte[]> map = ZipUtil.unzipFile(zipData);
            byte[] sourceData = XbrlValidator.getSourceData(map);
            byte[] signedData = XbrlValidator.getSignedData(map);
            if (sourceData == null || signedData == null) {
                throw new VerifyRuntimeException("\u4e0d\u652f\u6301\u7684\u9a8c\u7b7e\u683c\u5f0f");
            }
            String signedBase64 = new String(signedData);
            return XbrlValidator.verifyXbrl(sourceData, signedBase64);
        }
        catch (Exception e) {
            if (e instanceof VerifyRuntimeException) {
                return new VerifyResultVO(YesnoEnum.NSP, e.getMessage(), null);
            }
            return new VerifyResultVO(YesnoEnum.NSP, "\u9a8c\u7b7e\u51fa\u9519", null);
        }
    }

    public static VerifyResultVO verifyXbrl(String zipBase64) {
        if (StringUtil.isBlank(zipBase64)) {
            return new VerifyResultVO(YesnoEnum.NSP, "\u53c2\u6570\u9519\u8bef\uff1azipBase64\u4e3a\u7a7a\u3002", null);
        }
        byte[] zipData = Base64.decode(zipBase64);
        return XbrlValidator.verifyXbrl(zipData);
    }

    private static VerifyResultVO verifyXbrl(byte[] sourceData, String signedBase64) {
        VerifyResultVO resultVO;
        block6: {
            if (sourceData == null) {
                return new VerifyResultVO(YesnoEnum.NSP, "\u539f\u6570\u636e\u4e3a\u7a7a\u3002", null);
            }
            if (signedBase64 == null) {
                return new VerifyResultVO(YesnoEnum.NSP, "\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a\u3002", null);
            }
            resultVO = new VerifyResultVO();
            try {
                PKCS7SignedData pkcs7SignedData = new PKCS7SignedData();
                pkcs7SignedData.loadBase64(signedBase64.getBytes());
                Certificate cert = pkcs7SignedData.getSignerCert();
                String reqDocHash = XbrlValidator.hashBase64(sourceData, Base64.toBase64String(cert.getEncoded()));
                String signValue = signedBase64;
                HashSignVerifyRequestVO requestVO = new HashSignVerifyRequestVO();
                requestVO.setReqDocHash(reqDocHash);
                requestVO.setSignValue(signValue);
                SignVerifyRespDataVO respData = GwcaClientFactory.getInstance().hashSignVerify(requestVO);
                resultVO.setSuccessed(respData.successed() ? YesnoEnum.YES : YesnoEnum.NO);
                SignInfoVO signInfo = new SignInfoVO();
                signInfo.setSignTime(XbrlValidator.parseSignTime(signedBase64));
                signInfo.setCertInfo(XbrlValidator.convert(cert));
                resultVO.setSignInfo(signInfo);
                if (!ConfigTool.checkCert()) break block6;
                try {
                    CertificateStoreFactory.getInstance().verify(CertTools.toJavaCert(cert.getEncoded()));
                }
                catch (CertificateStoreException e) {
                    LOG.error("\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u4e0d\u901a\u8fc7\u3002", (Throwable)e);
                    return new VerifyResultVO(YesnoEnum.NSP, "\u8bc1\u4e66\u6709\u6548\u6027\u9a8c\u8bc1\u4e0d\u901a\u8fc7\u3002", null);
                }
            }
            catch (Exception e) {
                LOG.error("\u89e3\u6790PKCS7\u683c\u5f0f\u5931\u8d25\u3002", (Throwable)e);
                return new VerifyResultVO(YesnoEnum.NSP, "\u89e3\u6790PKCS7\u683c\u5f0f\u5931\u8d25\u3002", null);
            }
        }
        return resultVO;
    }

    private static byte[] getSourceData(Map<String, byte[]> map) {
        if (map.containsKey(".xbrl")) {
            return map.get(".xbrl");
        }
        if (map.containsKey(".xml")) {
            return map.get(".xml");
        }
        return null;
    }

    private static byte[] getSignedData(Map<String, byte[]> map) {
        if (map.containsKey(".sign")) {
            return map.get(".sign");
        }
        return null;
    }

    private static String hashBase64(byte[] data, String cert) {
        String reqDoc = Base64.toBase64String(data);
        return GwcaClientFactory.getInstance().hashCalc(reqDoc, cert).getHash();
    }

    private static Date parseSignTime(String signValue) {
        SignTimeRespDataVO respData = GwcaClientFactory.getInstance().getSignTime(signValue);
        return respData.convertSignTime();
    }

    private static X509CertVO convert(Certificate cert) {
        X509CertVO x509Cert = new X509CertVO();
        x509Cert.setSerialNumber(XbrlValidator.toHexString(cert.getSerialNumber()));
        x509Cert.setSubject(cert.getSubject().toString());
        x509Cert.setIssuer(cert.getIssuer().toString());
        x509Cert.setBeginDate(cert.getStartDate().getDate());
        x509Cert.setEndDate(cert.getEndDate().getDate());
        return x509Cert;
    }

    private static String toHexString(ASN1Integer asn1) {
        try {
            String certSN = ByteUtil.bytes2hex((byte[])asn1.getEncoded()).toLowerCase();
            return certSN.substring(4);
        }
        catch (Exception e) {
            LOG.info("ASN1Integer\u8f6cHex\u5931\u8d25\u3002");
            return asn1.toString();
        }
    }
}

