/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.jdk.nio.file;

import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import java.io.File;

public class FilePath {
    private String path;

    public FilePath(String path) {
        if (StringUtil.isBlank(path)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1apath\u4e3a\u7a7a\u3002");
        }
        this.path = this.replaceLastSeparator(path);
    }

    private String replaceBothSeparator(String path) {
        String path1 = this.replaceFirstSeparator(path);
        return this.replaceLastSeparator(path1);
    }

    private String replaceFirstSeparator(String path) {
        String lastChar = path.substring(0, 1);
        if (lastChar.equals("/") || lastChar.equals("//")) {
            return path.substring(1);
        }
        return path;
    }

    private String replaceLastSeparator(String path) {
        String lastChar = path.substring(path.length() - 1);
        if (lastChar.equals("/") || lastChar.equals("//")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public FilePath append(String ... more) {
        StringBuilder sb = new StringBuilder(this.getPath());
        for (String str : more) {
            sb.append(File.separator).append(this.replaceBothSeparator(str));
        }
        return new FilePath(sb.toString());
    }

    public File toFile() {
        return new File(this.path);
    }

    public String toAbsolutePath() {
        return this.toFile().getAbsolutePath();
    }

    public String getFileName() {
        File file = new File(this.path);
        return file.getName();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return "FilePath [path=" + this.path + "]";
    }
}

