/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.jdk.nio.file;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.UuidUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtil.class);

    public static FilePath createDirectories(FilePath filePath) {
        if (filePath.toFile().exists()) {
            return filePath;
        }
        filePath.toFile().mkdirs();
        return filePath;
    }

    public static FilePath createTempDirectory(String prefix) {
        String temp = System.getProperty("java.io.tmpdir");
        String directoryName = prefix + UuidUtil.newUUID();
        FilePath path = PathUtil.get(temp, directoryName);
        if (path.toFile().exists()) {
            return path;
        }
        path.toFile().mkdirs();
        return path;
    }

    public static boolean exists(FilePath filePath) {
        return filePath.toFile().exists();
    }

    public static boolean notExists(FilePath filePath) {
        return !FileUtil.exists(filePath);
    }

    public static boolean isDirectory(FilePath filePath) {
        if (FileUtil.notExists(filePath)) {
            throw new RuntimeException("\u6307\u5b9a\u6587\u4ef6\u8def\u5f84\u4e0d\u5b58\u5728\u3002");
        }
        File file = filePath.toFile();
        return file.isDirectory();
    }

    public static byte[] readAllBytes(FilePath filePath) {
        return IOUtil.readFile(filePath.getPath());
    }

    public static boolean delete(FilePath filePath) {
        return filePath.toFile().delete();
    }

    public static void write(FilePath filePath, byte[] data) {
        try {
            IOUtil.write(data, new FileOutputStream(new File(filePath.getPath())));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FilePath getParent(FilePath filePath) {
        File file = new File(filePath.getPath());
        String parentPath = file.getParent();
        return new FilePath(parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(FilePath src, FilePath target) {
        block5: {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                in = new FileInputStream(new File(src.getPath()));
                out = new FileOutputStream(new File(target.getPath()));
                IOUtil.copy(in, out);
                IOUtil.close(in);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtil.close(in);
                IOUtil.close(out);
            }
            IOUtil.close(out);
        }
    }

    public static void createFile(FilePath filePath) {
        try {
            File f = new File(filePath.getPath());
            if (f.createNewFile()) {
                LOG.info("File created");
            } else {
                LOG.info("File already exists");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file1, File file2) throws IOException {
        boolean bl;
        boolean file1Exists = file1.exists();
        if (file1Exists != file2.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (file1.isDirectory() || file2.isDirectory()) {
            throw new IOException("Can't compare directories, only files");
        }
        if (file1.length() != file2.length()) {
            return false;
        }
        if (file1.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(file1);
            input2 = new FileInputStream(file2);
            bl = IOUtil.contentEquals(input1, input2);
        }
        catch (Throwable throwable) {
            IOUtil.close(input1);
            IOUtil.close(input2);
            throw throwable;
        }
        IOUtil.close(input1);
        IOUtil.close(input2);
        return bl;
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + ".";
            throw new IOException(message);
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        File[] files = FileUtil.verifiedListFiles(directory);
        IOException exception = null;
        for (File file : files) {
            try {
                FileUtil.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    private static File[] verifiedListFiles(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        return files;
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (!file.delete()) {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        FilePath filePath = new FilePath("C:\\Users\\daihaipeng\\Desktop\\1.txt");
        FilePath target = new FilePath("C:\\Users\\daihaipeng\\Desktop\\2.txt");
        FileUtil.createFile(target);
        String zipFile = "C:\\Users\\daihaipeng\\Desktop\\Desktop.zip";
    }
}

