/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert;

import com.ygsoft.abc.mapp.ygca.ofdrw.util.DateUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Date;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.misc.MiscObjectIdentifiers;
import org.bouncycastle162.asn1.misc.NetscapeCertType;
import org.bouncycastle162.asn1.x500.X500Name;
import org.bouncycastle162.asn1.x500.X500NameBuilder;
import org.bouncycastle162.asn1.x500.style.BCStyle;
import org.bouncycastle162.asn1.x509.BasicConstraints;
import org.bouncycastle162.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle162.asn1.x509.Extension;
import org.bouncycastle162.asn1.x509.KeyPurposeId;
import org.bouncycastle162.cert.X509CertificateHolder;
import org.bouncycastle162.cert.X509v3CertificateBuilder;
import org.bouncycastle162.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle162.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle162.jce.X509KeyUsage;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.bouncycastle162.operator.ContentSigner;
import org.bouncycastle162.operator.OperatorCreationException;
import org.bouncycastle162.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle162.pkcs.PKCS10CertificationRequest;
import org.bouncycastle162.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle162.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class PKCGenerate {
    public static X500Name TestND() {
        return new X500NameBuilder().addRDN(BCStyle.C, "CN").addRDN(BCStyle.O, "OFD R&W").addRDN(BCStyle.ST, "Zhejiang").addRDN(BCStyle.L, "Hangzhou").addRDN(BCStyle.CN, "Test Certificate").build();
    }

    public static PKCS10CertificationRequest CertRequest(KeyPair kp, X500Name subject) throws OperatorCreationException {
        JcaPKCS10CertificationRequestBuilder requestBuilder = new JcaPKCS10CertificationRequestBuilder(subject, kp.getPublic());
        return requestBuilder.build(new JcaContentSignerBuilder("SM3withSM2").setProvider("BC162").build(kp.getPrivate()));
    }

    public static KeyPair GenerateKeyPair() throws GeneralSecurityException {
        ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", (Provider)new BouncyCastleProvider());
        kpg.initialize(sm2Spec);
        kpg.initialize(sm2Spec, new SecureRandom());
        return kpg.generateKeyPair();
    }

    public static X509Certificate GenCert(PKCS10CertificationRequest p10Obj, Certificate root, PrivateKey privateKey) throws GeneralSecurityException, IOException, OperatorCreationException {
        JcaPKCS10CertificationRequest req = new JcaPKCS10CertificationRequest(p10Obj);
        X500Name subject = req.getSubject();
        X500Name issuer = new X509CertificateHolder(root.getEncoded()).getSubject();
        X509v3CertificateBuilder certGen = new JcaX509v3CertificateBuilder(issuer, BigInteger.valueOf(new Date().getTime()), new Date(), DateUtil.getYearAfterTomorrow(), subject, req.getPublicKey()).addExtension(Extension.keyUsage, false, (ASN1Encodable)new X509KeyUsage(196)).addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth)).addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false)).addExtension(MiscObjectIdentifiers.netscapeCertType, false, (ASN1Encodable)new NetscapeCertType(128));
        ContentSigner sigGen = new JcaContentSignerBuilder("SM3withSM2").setProvider("BC162").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC162").getCertificate(certGen.build(sigGen));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

