/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;

public class PKCS12Tools {
    public static PrivateKey ReadPrvKey(InputStream rootKsIn, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        String alias = ks.aliases().nextElement();
        return (PrivateKey)ks.getKey(alias, pwd.toCharArray());
    }

    public static PrivateKey ReadPrvKey(InputStream rootKsIn, String alias, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        return (PrivateKey)ks.getKey(alias, pwd.toCharArray());
    }

    public static Certificate[] ReadCertChain(InputStream rootKsIn, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        String alias = ks.aliases().nextElement();
        return ks.getCertificateChain(alias);
    }

    public static Certificate ReadUserCert(InputStream rootKsIn, String pwd) throws GeneralSecurityException, IOException {
        return PKCS12Tools.ReadCertChain(rootKsIn, pwd)[0];
    }

    public static Certificate[] ReadCertChain(InputStream rootKsIn, String alias, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        ks.load(rootKsIn, pwd.toCharArray());
        return ks.getCertificateChain(alias);
    }

    public static Certificate ReadUserCert(InputStream rootKsIn, String alias, String pwd) throws GeneralSecurityException, IOException {
        return PKCS12Tools.ReadCertChain(rootKsIn, alias, pwd)[0];
    }
}

