/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut;

import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import java.util.Enumeration;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1OctetString;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ASN1Set;
import org.bouncycastle162.asn1.ASN1TaggedObject;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.DERTaggedObject;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;

public class SignerInfo
extends ASN1Object {
    public static final ASN1Integer VERSION_1 = new ASN1Integer(1L);
    private ASN1Integer version = VERSION_1;
    private IssuerAndSerialNumber issuerAngSerialNumber;
    private AlgorithmIdentifier digestAlgorithm;
    private ASN1Set authenticatedAttributes;
    private AlgorithmIdentifier digestEncryptionAlgorithm;
    private ASN1OctetString encryptedDigest;
    private ASN1Set unauthenticatedAttributes;

    public SignerInfo(IssuerAndSerialNumber issuerAngSerialNumber, AlgorithmIdentifier digestAlgorithm, AlgorithmIdentifier digestEncryptionAlgorithm, ASN1OctetString encryptedDigest) {
        this.version = VERSION_1;
        this.issuerAngSerialNumber = issuerAngSerialNumber;
        this.digestAlgorithm = digestAlgorithm;
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
        this.encryptedDigest = encryptedDigest;
    }

    public SignerInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.version = ASN1Integer.getInstance(e.nextElement());
        this.issuerAngSerialNumber = IssuerAndSerialNumber.getInstance(e.nextElement());
        this.digestAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        Object obj = e.nextElement();
        if (obj instanceof ASN1TaggedObject) {
            this.authenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)obj), (boolean)false);
            this.digestEncryptionAlgorithm = AlgorithmIdentifier.getInstance(e.nextElement());
        } else {
            this.authenticatedAttributes = null;
            this.digestEncryptionAlgorithm = AlgorithmIdentifier.getInstance(obj);
        }
        this.encryptedDigest = ASN1OctetString.getInstance(e.nextElement());
        if (e.hasMoreElements()) {
            this.unauthenticatedAttributes = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)e.nextElement()), (boolean)false);
        }
    }

    public static SignerInfo getInstance(Object o) {
        if (o instanceof SignerInfo) {
            return (SignerInfo)((Object)o);
        }
        if (o != null) {
            return new SignerInfo(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public SignerInfo setVersion(ASN1Integer version) {
        this.version = version;
        return this;
    }

    public IssuerAndSerialNumber getIssuerAngSerialNumber() {
        return this.issuerAngSerialNumber;
    }

    public SignerInfo setIssuerAngSerialNumber(IssuerAndSerialNumber issuerAngSerialNumber) {
        this.issuerAngSerialNumber = issuerAngSerialNumber;
        return this;
    }

    public AlgorithmIdentifier getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public SignerInfo setDigestAlgorithm(AlgorithmIdentifier digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        return this;
    }

    public ASN1Set getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public SignerInfo setAuthenticatedAttributes(ASN1Set authenticatedAttributes) {
        this.authenticatedAttributes = authenticatedAttributes;
        return this;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public SignerInfo setDigestEncryptionAlgorithm(AlgorithmIdentifier digestEncryptionAlgorithm) {
        this.digestEncryptionAlgorithm = digestEncryptionAlgorithm;
        return this;
    }

    public ASN1OctetString getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public SignerInfo setEncryptedDigest(ASN1OctetString encryptedDigest) {
        this.encryptedDigest = encryptedDigest;
        return this;
    }

    public ASN1Set getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public SignerInfo setUnauthenticatedAttributes(ASN1Set unauthenticatedAttributes) {
        this.unauthenticatedAttributes = unauthenticatedAttributes;
        return this;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.version);
        v.add((ASN1Encodable)this.issuerAngSerialNumber);
        v.add((ASN1Encodable)this.digestAlgorithm);
        if (this.authenticatedAttributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.authenticatedAttributes));
        }
        v.add((ASN1Encodable)this.digestEncryptionAlgorithm);
        v.add((ASN1Encodable)this.encryptedDigest);
        if (this.unauthenticatedAttributes != null) {
            v.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.unauthenticatedAttributes));
        }
        return new DERSequence(v);
    }
}

