/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.DocBody;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.OFD;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.encryt.Encryptions;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.DocDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class OFDDir
extends VirtualContainer {
    public static final String OFDFileName = "OFD.xml";
    public static final String EncryptionsFileName = "Encryptions.xml";
    public static final String OFDEntriesFileName = "OFDEntries.xml";
    private int maxDocIndex = 0;

    public static OFDDir newOFD() {
        FilePath tempDirectory = FileUtil.createTempDirectory("ofd-tmp-");
        return new OFDDir(tempDirectory);
    }

    public OFDDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
        this.initContainer();
    }

    private void initContainer() {
        File fullDirFile = new File(this.getSysAbsPath());
        File[] files = fullDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                String numb;
                int num;
                if (!f.getName().startsWith("Doc_") || this.maxDocIndex > (num = Integer.parseInt(numb = f.getName().replace("Doc_", "")))) continue;
                this.maxDocIndex = num + 1;
            }
        }
    }

    public OFD getOfd() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(OFDFileName);
        return new OFD(obj);
    }

    public OFDDir setOfd(OFD ofd) {
        this.putObj(OFDFileName, ofd);
        return this;
    }

    public Encryptions obtainEncryptions() {
        Encryptions encryptions = null;
        try {
            encryptions = this.getEncryptions();
        }
        catch (DocumentException e) {
            throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u89e3\u5bc6\u5165\u53e3\u6587\u4ef6", e);
        }
        if (encryptions == null) {
            encryptions = new Encryptions();
            this.setEncryptions(encryptions);
        }
        return encryptions;
    }

    public Encryptions getEncryptions() throws DocumentException {
        try {
            Element obj = this.getObj(EncryptionsFileName);
            if (obj == null) {
                return null;
            }
            return new Encryptions(obj);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public OFDDir setEncryptions(Encryptions encryptions) {
        if (encryptions == null) {
            return this;
        }
        this.putObj(EncryptionsFileName, encryptions);
        return this;
    }

    public DocDir newDoc() {
        String name = "Doc_" + this.maxDocIndex;
        ++this.maxDocIndex;
        return this.obtainContainer(name, DocDir.newFunc());
    }

    public DocDir obtainDoc(int index) {
        String name = "Doc_" + index;
        if (index >= this.maxDocIndex) {
            this.maxDocIndex = index + 1;
        }
        return this.obtainContainer(name, DocDir.newFunc());
    }

    public DocDir getLatestDir() {
        String name = "Doc_" + (this.maxDocIndex - 1);
        return this.obtainContainer(name, DocDir.newFunc());
    }

    public DocDir getDocByIndex(int index) throws FileNotFoundException {
        String name = "Doc_" + index;
        return this.getContainer(name, DocDir.newFunc());
    }

    public DocDir getDocDir(String name) throws FileNotFoundException {
        return this.getContainer(name, DocDir.newFunc());
    }

    public DocDir obtainDocDefault() {
        if (this.exit(OFDFileName)) {
            try {
                OFD ofd = this.getOfd();
                List<DocBody> docBodies = ofd.getDocBodies();
                if (!docBodies.isEmpty()) {
                    DocBody docBody = docBodies.get(docBodies.size() - 1);
                    ST_Loc docRoot = docBody.getDocRoot();
                    return this.obtainContainer(docRoot.parent(), DocDir.newFunc());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("OFD.xml \u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            }
        }
        return this.obtainDoc(0);
    }

    public void jar(OutputStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("\u751f\u6210OFD\u6587\u4ef6\u8f93\u51fa\u6d41\uff08outStream\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.flush();
        ZipOutputStream zip = new ZipOutputStream(outStream);
        this.zip(this.getSysAbsPath(), "", System.currentTimeMillis(), zip);
        zip.finish();
        outStream.flush();
    }

    private void zip(String workDirPath, String dir, long fileTime, ZipOutputStream zip) throws IOException {
        File[] files = new File(workDirPath).listFiles();
        if (files == null) {
            throw new RuntimeException("\u76ee\u5f55\u4e2d\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6\u65e0\u6cd5\u6253\u5305");
        }
        for (File f : files) {
            String entryName = f.getName();
            if (dir != null && !"".equals(dir)) {
                entryName = dir + entryName;
            }
            if (f.isDirectory()) {
                entryName = entryName + "/";
            }
            this.putEntry(zip, fileTime, entryName);
            if (f.isDirectory()) {
                this.zip(f.getAbsolutePath(), entryName, fileTime, zip);
                continue;
            }
            this.writeStream(zip, f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(ZipOutputStream zip, File f) throws IOException {
        BufferedInputStream fileStream = null;
        try {
            int i;
            fileStream = new BufferedInputStream(new FileInputStream(f));
            byte[] buffer = new byte[1024];
            while ((i = ((InputStream)fileStream).read(buffer)) > 0) {
                zip.write(buffer, 0, i);
            }
            zip.flush();
            zip.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtil.close(fileStream);
            throw throwable;
        }
        IOUtil.close(fileStream);
    }

    private void putEntry(ZipOutputStream zip, long fileTime, String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setTime(fileTime);
        zip.putNextEntry(entry);
    }

    public void jar(FilePath filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("\u751f\u6210OFD\u6587\u4ef6\u8def\u5f84\uff08fileName\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (FileUtil.exists(filePath)) {
            FileUtil.delete(filePath);
        }
        this.flush();
        String fullOfFilePath = filePath.toAbsolutePath().toString();
        this.zip(this.getSysAbsPath(), fullOfFilePath);
    }

    private void zip(String workDirPath, String fullOfFilePath) throws IOException {
    }
}

