/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.PageDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.File;
import java.io.FileNotFoundException;

public class PagesDir
extends VirtualContainer {
    private int maxPageIndex = 0;

    public PagesDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
        this.initContainer();
    }

    public static Function<FilePath, PagesDir> newFunc() {
        Function<FilePath, PagesDir> creater = new Function<FilePath, PagesDir>(){

            @Override
            public PagesDir apply(FilePath path) {
                return new PagesDir(path);
            }
        };
        return creater;
    }

    private void initContainer() {
        File fullDirFile = new File(this.getSysAbsPath());
        File[] files = fullDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                String numb;
                int num;
                if (!f.getName().startsWith("Page_") || this.maxPageIndex > (num = Integer.parseInt(numb = f.getName().replace("Page_", "")))) continue;
                this.maxPageIndex = num + 1;
            }
        }
    }

    public PageDir newPageDir() {
        String name = "Page_" + this.maxPageIndex;
        ++this.maxPageIndex;
        Function<FilePath, PageDir> creater = new Function<FilePath, PageDir>(){

            @Override
            public PageDir apply(FilePath path) {
                return new PageDir(path);
            }
        };
        return this.obtainContainer(name, creater);
    }

    public PageDir getByIndex(int index) throws FileNotFoundException {
        String containerName = "Page_" + index;
        Function<FilePath, PageDir> creater = new Function<FilePath, PageDir>(){

            @Override
            public PageDir apply(FilePath path) {
                return new PageDir(path);
            }
        };
        return this.getContainer(containerName, creater);
    }

    public PageDir getPageDir(String containerName) throws FileNotFoundException {
        Function<FilePath, PageDir> creater = new Function<FilePath, PageDir>(){

            @Override
            public PageDir apply(FilePath path) {
                return new PageDir(path);
            }
        };
        return this.getContainer(containerName, creater);
    }
}

