/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signatures;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.SignDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import java.io.File;
import java.io.FileNotFoundException;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SignsDir
extends VirtualContainer {
    private int maxSignIndex = 0;
    public static final String SignaturesFileName = "Signatures.xml";

    public SignsDir(FilePath fullDir) throws IllegalArgumentException {
        super(fullDir);
        this.initContainer();
    }

    public static Function<FilePath, SignsDir> newFunc() {
        Function<FilePath, SignsDir> creater = new Function<FilePath, SignsDir>(){

            @Override
            public SignsDir apply(FilePath path) {
                return new SignsDir(path);
            }
        };
        return creater;
    }

    private void initContainer() {
        File fullDirFile = new File(this.getSysAbsPath());
        File[] files = fullDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                String numb;
                int num;
                String dirName = f.getName();
                if (!dirName.startsWith("Sign_") || this.maxSignIndex > (num = Integer.parseInt(numb = dirName.replace("Sign_", "")))) continue;
                this.maxSignIndex = num + 1;
            }
        }
    }

    public Signatures getSignatures() throws FileNotFoundException, DocumentException {
        Element element = this.getObj(SignaturesFileName);
        return new Signatures(element);
    }

    public SignsDir setSignatures(Signatures signatures) {
        this.putObj(SignaturesFileName, signatures);
        return this;
    }

    public SignDir newSignDir() {
        String name = "Sign_" + this.maxSignIndex;
        ++this.maxSignIndex;
        Function<FilePath, SignDir> creater = new Function<FilePath, SignDir>(){

            @Override
            public SignDir apply(FilePath path) {
                return new SignDir(path);
            }
        };
        return this.obtainContainer(name, creater);
    }

    public SignDir getByIndex(Integer index) throws FileNotFoundException {
        if (index == null || index <= 0) {
            throw new NumberFormatException("\u7b7e\u540d\u5bb9\u5668index\u5fc5\u987b\u5927\u4e8e0");
        }
        String containerName = "Sign_" + index;
        Function<FilePath, SignDir> creater = new Function<FilePath, SignDir>(){

            @Override
            public SignDir apply(FilePath path) {
                return new SignDir(path);
            }
        };
        return this.getContainer(containerName, creater);
    }

    public SignDir getSignDir(String containerName) throws FileNotFoundException {
        Function<FilePath, SignDir> creater = new Function<FilePath, SignDir>(){

            @Override
            public SignDir apply(FilePath path) {
                return new SignDir(path);
            }
        };
        return this.getContainer(containerName, creater);
    }
}

