/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.reader.extractor;

import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Array;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Box;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Pos;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.text.TextCode;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.DeltaTool;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.extractor.ExtractorFilter;
import java.awt.Rectangle;
import java.util.List;

public class RegionTextExtractorFilter
implements ExtractorFilter {
    private final Rectangle rectangle;

    public RegionTextExtractorFilter(Rectangle rectangle) {
        this.rectangle = rectangle;
    }

    @Override
    public String getAllowText(TextObject textObject, TextCode textCode) {
        String content = textCode.getContent();
        String allowText = null;
        if (content != null && !"".equals(content)) {
            List<Float> deltaX = DeltaTool.getDelta(textCode.getDeltaX(), textCode.getContent().length());
            List<Float> deltaY = DeltaTool.getDelta(textCode.getDeltaY(), textCode.getContent().length());
            this.emptyDeltaHandle(content, deltaX, deltaY);
            ST_Box boundary = textObject.getBoundary();
            Double topLeftX = boundary.getTopLeftX();
            Double topLeftY = boundary.getTopLeftY();
            if (topLeftX == null) {
                topLeftX = 0.0;
            }
            if (topLeftY == null) {
                topLeftY = 0.0;
            }
            double[] matrix = RegionTextExtractorFilter.getMatrix(textObject.getCTM());
            double sx = textCode.getX() == null ? 0.0 : textCode.getX();
            double sy = textCode.getY() == null ? 0.0 : textCode.getY();
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < content.length(); ++i) {
                char ch = content.charAt(i);
                if (matrix != null) {
                    ST_Pos transform = RegionTextExtractorFilter.transform(matrix, sx, sy);
                    if (this.rectangle.contains(topLeftX + transform.getX(), topLeftY + transform.getY())) {
                        builder.append(ch);
                    }
                } else if (this.rectangle.contains(topLeftX + sx, topLeftY + sy)) {
                    builder.append(ch);
                }
                sx += (double)deltaX.get(i).floatValue();
                sy += (double)deltaY.get(i).floatValue();
            }
            if (builder.length() != 0) {
                allowText = builder.toString();
            }
        }
        return allowText;
    }

    private static ST_Pos transform(double[] matrix, double sx, double sy) {
        double x = matrix[0] * sx + matrix[2] * sy + matrix[4];
        double y = matrix[1] * sx + matrix[3] * sy + matrix[5];
        return new ST_Pos(x, y);
    }

    private static double[] getMatrix(ST_Array ctm) {
        double[] matrix = null;
        if (ctm != null) {
            List<String> ctmArray = ctm.getArray();
            matrix = new double[ctmArray.size()];
            for (int i = 0; i < ctmArray.size(); ++i) {
                matrix[i] = Double.parseDouble(ctmArray.get(i));
            }
        }
        return matrix;
    }

    private void emptyDeltaHandle(String content, List<Float> deltaX, List<Float> deltaY) {
        int i;
        if (deltaX.isEmpty()) {
            for (i = 0; i < content.length(); ++i) {
                deltaX.add(Float.valueOf(0.0f));
            }
        }
        if (deltaY.isEmpty()) {
            for (i = 0; i < content.length(); ++i) {
                deltaY.add(Float.valueOf(0.0f));
            }
        }
    }
}

