/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.sign;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.PathUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signatures;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.appearance.Seal;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.appearance.StampAnnot;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.range.Reference;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.range.References;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Parameters;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Provider;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.SignedInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.OFDDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.SignDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.SignsDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.BadOFDException;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ResourceLocator;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.ExtendSignatureContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.ProtectFileFilter;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.SignIDProvider;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.SignMode;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.SignatureException;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.SignatureTerminateException;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.StandFormatAtomicSignID;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.ToDigestFileInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.stamppos.StampAppearance;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.DocumentException;

public class OFDSigner
implements Closeable {
    private static SimpleDateFormat DF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private OFDDir ofdDir;
    private OFDReader reader;
    private SignIDProvider MaxSignID;
    private SignMode signMode;
    private Parameters parameters;
    private ST_Loc signaturesLoc;
    private List<StampAppearance> apList;
    private ProtectFileFilter protectFileFilter;
    private ExtendSignatureContainer signContainer;
    private FilePath out;
    private OutputStream outStream;
    private boolean hasSign;
    private String relativeID = null;

    public static Provider OFDRW_Provider() {
        return new Provider().setProviderName("ofdrw-sign").setCompany("ofdrw").setVersion("1.17.13");
    }

    private OFDSigner() {
    }

    public OFDSigner(OFDReader reader, OutputStream outStream, SignIDProvider idProvider) throws SignatureTerminateException {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668\uff08reader\uff09\u4e3a\u7a7a");
        }
        if (outStream == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u540d\u540e\u6587\u4ef6\u8f93\u51fa\u6d41\uff08outStream\uff09\u4e3a\u7a7a");
        }
        if (idProvider == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u6587\u4ef6ID\u63d0\u4f9b\u5668\uff08idProvider\uff09\u4e3a\u7a7a");
        }
        this.outStream = outStream;
        this.setProperty(reader, idProvider);
    }

    public OFDSigner(OFDReader reader, FilePath out, SignIDProvider idProvider) throws SignatureTerminateException {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668\uff08reader\uff09\u4e3a\u7a7a");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u540d\u540e\u6587\u4ef6\u4fdd\u5b58\u4f4d\u7f6e\uff08out\uff09\u4e3a\u7a7a");
        }
        if (idProvider == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u6587\u4ef6ID\u63d0\u4f9b\u5668\uff08idProvider\uff09\u4e3a\u7a7a");
        }
        this.out = out;
        this.setProperty(reader, idProvider);
    }

    private void setProperty(OFDReader reader, SignIDProvider idProvider) throws SignatureTerminateException {
        this.reader = reader;
        this.ofdDir = reader.getOFDDir();
        this.hasSign = false;
        this.MaxSignID = idProvider;
        this.apList = new LinkedList<StampAppearance>();
        this.signMode = SignMode.WholeProtected;
        this.signaturesLoc = null;
        this.preChecker();
    }

    public OFDSigner(OFDReader reader, FilePath out) throws SignatureTerminateException {
        this(reader, out, (SignIDProvider)new StandFormatAtomicSignID());
    }

    public SignMode getSignMode() {
        return this.signMode;
    }

    public OFDSigner setSignMode(SignMode signMode) {
        if (signMode == null) {
            signMode = SignMode.WholeProtected;
        }
        this.signMode = signMode;
        return this;
    }

    public OFDSigner setSignContainer(ExtendSignatureContainer signContainer) {
        if (signContainer == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5b9e\u73b0\u5bb9\u5668\uff08signContainer\uff09\u4e3a\u7a7a");
        }
        this.signContainer = signContainer;
        return this;
    }

    public OFDSigner addApPos(StampAppearance sa) {
        if (sa == null) {
            return this;
        }
        this.apList.add(sa);
        return this;
    }

    private void preChecker() throws SignatureTerminateException {
        ResourceLocator rl = this.reader.getResourceLocator();
        try {
            rl.save();
            rl.cd("/");
            this.signaturesLoc = this.reader.getDefaultDocSignaturesPath();
            if (this.signaturesLoc == null || !rl.exist(this.signaturesLoc.toString())) {
                return;
            }
            Signatures signatures = rl.get(this.signaturesLoc, Signatures.newFunc());
            String maxSignId = signatures.getMaxSignId();
            this.MaxSignID.setCurrentMaxSignId(maxSignId);
            String parent = this.signaturesLoc.parent();
            rl.cd(parent);
            List<com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature> signatureList = signatures.getSignatures();
            for (com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature sig : signatureList) {
                ST_Loc baseLoc = sig.getBaseLoc();
                Signature sigObj = rl.get(baseLoc, Signature.newFunc());
                References refList = sigObj.getSignedInfo().getReferences();
                if (!refList.hasFile(this.signaturesLoc.getLoc())) continue;
                throw new SignatureTerminateException("\u7b7e\u540d\u5217\u8868\u6587\u4ef6\uff08Signatures.xml\uff09\u5df2\u7ecf\u88ab\u4fdd\u62a4\uff0c\u6587\u6863\u4e0d\u5141\u8bb8\u7ee7\u7eed\u8ffd\u52a0\u7b7e\u540d");
            }
        }
        catch (Exception e) {
            throw new BadOFDException("\u9519\u8befOFD\u7ed3\u6784\u548c\u6587\u4ef6\u683c\u5f0f", e);
        }
        finally {
            rl.restore();
        }
    }

    private List<ToDigestFileInfo> toBeDigestFileList() throws IOException {
        LinkedList<ToDigestFileInfo> res = new LinkedList<ToDigestFileInfo>();
        FilePath containerPath = this.ofdDir.getContainerPath();
        String sysRoot = "abc";
        File path2 = new File(containerPath.getPath());
        File[] fileArray = path2.listFiles();
        if (fileArray.length > 0) {
            for (File file : fileArray) {
                String abxFilePath = "abc";
                abxFilePath = abxFilePath.replace("abc", "");
                ToDigestFileInfo fileInfo = new ToDigestFileInfo(abxFilePath, PathUtil.get(abxFilePath, new String[0]));
                try {
                    if (this.protectFileFilter != null && !this.protectFileFilter.filter(fileInfo.getAbsPath())) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.signMode == SignMode.ContinueSign && abxFilePath.equals(this.signaturesLoc.getLoc())) continue;
                res.add(fileInfo);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signatures exeSign() throws IOException, GeneralSecurityException {
        byte[] signedValue;
        if (this.signContainer == null) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5b9e\u73b0\u5bb9\u5668\uff08signContainer\uff09\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u4f9b\u7b7e\u540d\u5b9e\u73b0\u5bb9\u5668");
        }
        this.hasSign = true;
        SignsDir signsDir = this.ofdDir.obtainDocDefault().obtainSigns();
        SignDir signDir = signsDir.newSignDir();
        Signatures signListObj = this.reader.getDefaultSignatures();
        if (this.signaturesLoc == null || signListObj == null) {
            signListObj = new Signatures();
            signsDir.setSignatures(signListObj);
            this.signaturesLoc = signsDir.getAbsLoc().cat("Signatures.xml");
            try {
                this.ofdDir.getOfd().getDocBody().setSignatures(this.signaturesLoc);
                this.ofdDir.flushFileByName("OFD.xml");
            }
            catch (DocumentException e) {
                throw new BadOFDException("OFD.xml \u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            }
        }
        ST_Loc signatureLoc = signDir.getAbsLoc().cat("Signature.xml");
        com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature signatureRecord = new com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature().setID(this.MaxSignID.incrementAndGet()).setType(this.signContainer.getSignType()).setBaseLoc(signatureLoc);
        if (this.relativeID != null && this.relativeID.trim().length() > 0) {
            signatureRecord.setRelative(this.relativeID);
        }
        signListObj.addSignature(signatureRecord);
        FilePath signatureFilePath = this.buildSignature(signsDir, signDir, signListObj);
        String propertyInfo = signDir.getAbsLoc().cat("Signature.xml").toString();
        FileInputStream inData = null;
        try {
            inData = new FileInputStream(new File(signatureFilePath.getPath()));
            signedValue = this.signContainer.sign(inData, propertyInfo);
        }
        catch (Throwable throwable) {
            IOUtil.close(inData);
            throw throwable;
        }
        IOUtil.close(inData);
        FilePath signedValuePath = PathUtil.get(signDir.getSysAbsPath(), "SignedValue.dat");
        FileUtil.write(signedValuePath, signedValue);
        return signListObj;
    }

    private FilePath buildSignature(SignsDir signsDir, SignDir signDir, Signatures signListObj) throws IOException, SignatureException {
        Object sealBin;
        SignedInfo signedInfo = new SignedInfo().setProvider(OFDSigner.OFDRW_Provider()).setSignatureMethod(this.signContainer.getSignAlgOID()).setParameters(this.parameters).setSignatureDateTime(DF.format(new Date()));
        ST_Loc signDirAbsLoc = signDir.getAbsLoc();
        if (this.signContainer.getSignType() == SigType.Seal && (sealBin = this.signContainer.getSeal()) != null && ((byte[])sealBin).length != 0) {
            FilePath sealPath = PathUtil.get(signDir.getSysAbsPath(), "Seal.esl");
            FileUtil.write(sealPath, (byte[])sealBin);
            Seal seal = new Seal().setBaseLoc(signDirAbsLoc.cat("Seal.esl"));
            signedInfo.setSeal(seal);
        }
        if (!this.apList.isEmpty()) {
            sealBin = this.apList.iterator();
            while (sealBin.hasNext()) {
                StampAppearance sa = (StampAppearance)sealBin.next();
                for (StampAnnot stampAnnot : sa.getAppearance(this.reader, this.MaxSignID)) {
                    signedInfo.addStampAnnot(stampAnnot);
                }
            }
        }
        signListObj.setMaxSignId(this.MaxSignID.get());
        signsDir.flushFileByName("Signatures.xml");
        MessageDigest md = this.signContainer.getDigestFnc();
        References references = new References().setCheckMethod(md.getAlgorithm());
        List<ToDigestFileInfo> toDigestFileInfos = this.toBeDigestFileList();
        for (ToDigestFileInfo fileInfo : toDigestFileInfos) {
            byte[] digest = this.calculateFileDigest(md, fileInfo.getSysPath());
            md.reset();
            Reference ref = new Reference().setFileRef(fileInfo.getAbsPath()).setCheckValue(digest);
            references.addReference(ref);
        }
        signedInfo.setReferences(references);
        Signature signature = new Signature().setSignedValue(signDirAbsLoc.cat("SignedValue.dat")).setSignedInfo(signedInfo);
        signDir.setSignature(signature);
        signDir.flushFileByName("Signature.xml");
        return PathUtil.get(signDir.getSysAbsPath(), "Signature.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateFileDigest(MessageDigest md, FilePath filePath) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        DigestInputStream dis = null;
        try {
            in = new FileInputStream(new File(filePath.getPath()));
            dis = new DigestInputStream(in, md);
            byte[] buffer = new byte[4096];
            while (dis.read(buffer) > -1) {
            }
            byArray = md.digest();
        }
        catch (Throwable throwable) {
            IOUtil.close(dis);
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(dis);
        IOUtil.close(in);
        return byArray;
    }

    @Override
    public void close() throws IOException {
        if (!this.hasSign) {
            throw new IllegalStateException("\u8bf7\u5148\u6267\u884c exeSign\u5728\u5173\u95ed\u5f15\u64ce\u5b8c\u6210\u6570\u5b57\u7b7e\u540d\u3002");
        }
        if (this.out != null) {
            this.ofdDir.jar(this.out);
        } else if (this.outStream != null) {
            this.ofdDir.jar(this.outStream);
        } else {
            throw new IllegalArgumentException("OFD\u6587\u6863\u8f93\u51fa\u76ee\u5f55\u9519\u8bef\u6216\u6ca1\u6709\u8bbe\u7f6e\u8f93\u51fa\u6d41");
        }
        this.reader.close();
    }

    public OFDSigner setProtectFileFilter(ProtectFileFilter filter) {
        this.protectFileFilter = filter;
        return this;
    }

    public OFDSigner setRelative(String id) {
        this.relativeID = id;
        return this;
    }

    public OFDSigner setParameters(Parameters parameters) {
        this.parameters = parameters;
        return this;
    }
}

