/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.sign;

import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.DocBody;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicStructure.ofd.OFD;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.OFDDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.VirtualContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ResourceLocator;
import java.io.IOException;
import org.dom4j.DocumentException;

public class SignCleaner {
    private OFDReader reader;
    private FilePath out;

    private SignCleaner() {
    }

    public SignCleaner(OFDReader reader, FilePath out) {
        if (reader == null) {
            throw new IllegalArgumentException("OFD\u89e3\u6790\u5668(reader)\u4e3a\u7a7a");
        }
        if (out == null) {
            throw new IllegalArgumentException("\u8f93\u51fa\u4f4d\u7f6e(out)\u4e3a\u7a7a");
        }
        this.reader = reader;
        this.out = out;
    }

    public void clean() throws IOException, DocumentException {
        OFDDir ofdDir = this.reader.getOFDDir();
        OFD ofd = ofdDir.getOfd();
        ResourceLocator rl = this.reader.getResourceLocator();
        for (DocBody docBody : ofd.getDocBodies()) {
            ST_Loc signListFileLoc = docBody.getSignatures();
            docBody.removeOFDElemByNames("Signatures");
            if (signListFileLoc == null) continue;
            FilePath signaturesXMLFile = rl.getFile(signListFileLoc);
            String parent = signListFileLoc.parent();
            VirtualContainer container = rl.getContainer(parent);
            if ("Signs".equalsIgnoreCase(container.getContainerName())) {
                container.clean();
            }
            if (FileUtil.exists(signaturesXMLFile)) {
                FileUtil.delete(signaturesXMLFile);
            }
            ofdDir.jar(this.out);
        }
    }
}

