/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.test;

import com.ygsoft.abc.mapp.ygca.gwcw.common.config.VerifyConfig;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.factory.BizSignatureServiceFactory;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizSignatureServiceTest2 {
    private static final Logger LOG = LoggerFactory.getLogger(BizSignatureServiceTest2.class);
    public static String samplesPath = "D:\\wk\\abc-sst-ca-verify700\\abc.ygca.gwcw.verify.depend2\\src\\test\\resources\\samples";
    public static Set<String> allIssuer = new HashSet<String>();
    public static Map<String, Set<String>> allIssuerMap = new HashMap<String, Set<String>>();

    private boolean verifyOfd(String tag, String ofdFile) {
        boolean isOk;
        IBizSignatureService service = this.createService();
        VerifyResultVO result = null;
        byte[] fileData = IOUtil.readFile(ofdFile);
        result = service.verify(fileData, "ofd");
        boolean bl = isOk = result != null && result.getSuccessed() == YesnoEnum.YES;
        if (isOk) {
            String subject = result.getSignInfo().getCertInfo().getSubject();
            String issuer = result.getSignInfo().getCertInfo().getIssuer();
            allIssuer.add(issuer);
            Set<Object> subIssuers = null;
            if (allIssuerMap.containsKey(subject)) {
                subIssuers = allIssuerMap.get(subject);
            } else {
                subIssuers = new HashSet();
                allIssuerMap.put(subject, subIssuers);
            }
            subIssuers.add(issuer);
        }
        LOG.info(tag + ":" + isOk);
        return isOk;
    }

    private IBizSignatureService createService() {
        String verifyServerUrl = null;
        verifyServerUrl = "http://10.51.170.8:25392/fmp-grm/fmp-fts-bsportal/inner/dcc/mapp/esign";
        verifyServerUrl = "http://10.122.3.71:8501/inner/dcc/mapp/verify";
        String verifyType = "sdk";
        return BizSignatureServiceFactory.getInstance(new VerifyConfig(verifyType, verifyServerUrl));
    }

    public static boolean testRegister2(String verifyType, String verifyServerUrl) {
        InputStream stream = null;
        boolean result = true;
        stream = BizSignatureServiceTest2.class.getClassLoader().getResourceAsStream("com/ygsoft/abc/mapp/ygca/test/1.ofd");
        if (!BizSignatureServiceTest2.testRegister(verifyType, verifyServerUrl, stream, "ofd")) {
            result = false;
        }
        if (!BizSignatureServiceTest2.testRegister(verifyType, verifyServerUrl, stream = BizSignatureServiceTest2.class.getClassLoader().getResourceAsStream("com/ygsoft/abc/mapp/ygca/test/2.ofd"), "ofd")) {
            result = false;
        }
        if (!BizSignatureServiceTest2.testRegister(verifyType, verifyServerUrl, stream = BizSignatureServiceTest2.class.getClassLoader().getResourceAsStream("com/ygsoft/abc/mapp/ygca/test/3.zip"), "zip")) {
            result = false;
        }
        return result;
    }

    public static boolean testRegister(String verifyType, String verifyServerUrl, InputStream stream, String fileType) {
        byte[] zipData;
        if (stream == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        IBizSignatureService service = BizSignatureServiceFactory.getInstance(new VerifyConfig(verifyType, verifyServerUrl));
        VerifyResultVO resultVO = service.verify(zipData = IOUtil.toByteArray(stream), fileType);
        boolean isOk = resultVO.getSuccessed() == YesnoEnum.YES;
        LOG.info("==================\u9a8c\u7b7e\u7ed3\u679c: " + isOk);
        return isOk;
    }

    public void testCase() {
        String ofd;
        byte[] zipData;
        String verifyType = "server";
        String verifyServerUrl = "http://10.122.3.71:9001/member/dcc/mapp/esign/service/eVoucher/submitVerifyAll";
        IBizSignatureService service = BizSignatureServiceFactory.getInstance(new VerifyConfig(verifyType, verifyServerUrl));
        VerifyResultVO resultVO = service.verify(zipData = IOUtil.readFile(ofd = samplesPath + File.separator + "inv_ord_issuer_202204_08888G22041409255232.zip"), "zip");
        boolean isOk = resultVO.getSuccessed() == YesnoEnum.YES;
        LOG.info("result: " + isOk);
    }

    public boolean testZip() {
        IBizSignatureService service = this.createService();
        String ofd = samplesPath + File.separator + "3.zip";
        byte[] zipData = IOUtil.readFile(ofd);
        VerifyResultVO resultVO = service.verify(zipData, "zip");
        resultVO.getFailMessage();
        boolean isOk = resultVO.getSuccessed() == YesnoEnum.YES;
        LOG.info("result: " + isOk);
        return isOk;
    }

    public boolean testTieLu() {
        String ofd = samplesPath + File.separator + "\u552e\u7968\u6362\u5f00\u6837\u4f8b.ofd";
        return this.verifyOfd("\u94c1\u8def--ofd\u9a8c\u7b7e", ofd);
    }

    public boolean testZheShang() {
        String ofd = samplesPath + File.separator + "bker_issuer_20191231_C10303110004552019030390296600243000000000019444.ofd";
        return this.verifyOfd("\u6d59\u5546--ofd\u9a8c\u7ae0", ofd);
    }

    public boolean testGuangDa() {
        String ofd = samplesPath + File.separator + "\u5149\u5927" + File.separator + "bank_receipt_1.ofd";
        return this.verifyOfd("\u5149\u5927--ofd\u9a8c\u7b7e", ofd);
    }

    public boolean testShengJing() {
        String ofd = samplesPath + File.separator + "kk" + File.separator + "\u5bf9\u8d26\u5355.ofd";
        return this.verifyOfd("\u76db\u4eac\u7535\u5b50\u7b7e\u7ae0--ofd\u9a8c\u7b7e", ofd);
    }

    public boolean testZheliBan() {
        String ofd = samplesPath + File.separator + "kk" + File.separator + "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968.ofd";
        return this.verifyOfd("\u6d59\u91cc\u529e\u7535\u5b50\u7b7e\u7ae0--ofd\u9a8c\u7b7e", ofd);
    }

    public boolean testZdc() {
        String ofd = samplesPath + File.separator + "1.ofd";
        IBizSignatureService service = this.createService();
        VerifyResultVO result = null;
        byte[] fileData = IOUtil.readFile(ofd);
        HashMap<String, String> optionalParam = new HashMap<String, String>();
        optionalParam.put("issued", "999");
        result = service.verify(fileData, "ofd", optionalParam);
        boolean isOk = result != null && result.getSuccessed() == YesnoEnum.YES;
        LOG.info("isOk:" + isOk);
        return isOk;
    }

    public boolean testZdc2() {
        String ofd = samplesPath + File.separator + "1.ofd";
        return this.verifyOfd("\u4e2d\u7535\u8d22--ofd\u9a8c\u7b7e", ofd);
    }

    public boolean testGh() {
        String ofd = samplesPath + File.separator + "gonghang" + File.separator + "0402021509300142766_001_22206000039_20220725_acc.ofd";
        return this.verifyOfd("gonghang", ofd);
    }

    public boolean testHk() {
        String ofd = samplesPath + File.separator + "\u7535\u5b50\u884c\u7a0b\u535512345678901234567892\uff08\u7ea2\u51b2\uff09.ofd";
        return this.verifyOfd("\u822a\u7a7a\u8fd0\u8f93--ofd\u9a8c\u7b7e", ofd);
    }

    public void testAll() {
        StringBuilder errors = new StringBuilder();
        File dir = new File(samplesPath, "kk");
        int success = 0;
        int total = 0;
        for (File ofd : dir.listFiles()) {
            ++total;
            boolean temSuccess = false;
            try {
                if (this.verifyOfd("ALL", ofd.getAbsolutePath())) {
                    ++success;
                    temSuccess = true;
                    LOG.info("ofd validate success:" + ofd.getAbsolutePath());
                } else {
                    LOG.warn("ofd validate fail:" + ofd.getAbsolutePath());
                }
            }
            catch (Exception e) {
                LOG.warn("ofd validate error:" + ofd.getAbsolutePath(), (Throwable)e);
            }
            if (!temSuccess) {
                errors.append(ofd.getName()).append("\n");
            }
            LOG.info("============================================================================================================================================");
        }
        LOG.info(String.format("success: %d, error: %d, total: %d", success, total - success, total));
        LOG.info(String.format("errors: %s", errors.toString()));
    }

    public void testAll2() {
        File dir = new File("C:\\Users\\yangzhi2\\Desktop\\doc\\20220609_\u9a8c\u7b7e");
        final OfdCount ofdCount = new OfdCount();
        this.traverseFile(dir, new FileVisit(){

            @Override
            public void visit(File file) {
                if (file.getName().endsWith(".ofd")) {
                    ofdCount.setTotal(ofdCount.getTotal() + 1);
                    boolean temSuccess = false;
                    try {
                        if (BizSignatureServiceTest2.this.verifyOfd("ALL", file.getAbsolutePath())) {
                            ofdCount.setSuccess(ofdCount.getSuccess() + 1);
                            temSuccess = true;
                            LOG.info("ofd validate success:" + file.getAbsolutePath());
                        } else {
                            LOG.warn("ofd validate fail:" + file.getAbsolutePath());
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("ofd validate error:" + file.getAbsolutePath(), (Throwable)e);
                    }
                    if (!temSuccess) {
                        ofdCount.getErrors().append(file.getAbsolutePath()).append("\n");
                    }
                    LOG.info("============================================================================================================================================");
                }
            }
        });
        LOG.info(String.format("success: %d, error: %d, total: %d", ofdCount.getSuccess(), ofdCount.getTotal() - ofdCount.getSuccess(), ofdCount.getTotal()));
        LOG.info(String.format("errors: %s", ofdCount.getErrors().toString()));
        LOG.info(String.format("allIssuer: %s", allIssuer.toString()));
        LOG.info(String.format("allIssuerMap: %s", allIssuerMap.size()));
    }

    public static void main(String[] args) {
        BizSignatureServiceTest2 bizSignatureServiceTest2 = new BizSignatureServiceTest2();
        LOG.info("========================================\u56fd\u7f51========================================");
        bizSignatureServiceTest2.testZip();
        LOG.info("========================================\u7535\u5b50\u7b7e\u540d========================================");
        bizSignatureServiceTest2.testTieLu();
        LOG.info("========================================\u7535\u5b50\u7b7e\u7ae0\u6d59\u5546========================================");
        bizSignatureServiceTest2.testZheShang();
        LOG.info("========================================\u7535\u5b50\u7b7e\u7ae0\u5149\u5927========================================");
        bizSignatureServiceTest2.testGuangDa();
        LOG.info("========================================\u7535\u5b50\u7b7e\u7ae0\u5de5\u884c========================================");
        bizSignatureServiceTest2.testGh();
        LOG.info("========================================\u7535\u5b50\u7b7e\u7ae0\u822a\u7a7a========================================");
        bizSignatureServiceTest2.testHk();
        LOG.info("========================================ALL========================================");
        bizSignatureServiceTest2.testAll();
    }

    public boolean testItem() {
        String ofd = samplesPath + File.separator + "kk" + File.separator + "ret_1.ofd";
        return this.verifyOfd("test", ofd);
    }

    public void traverseFile(File dir, FileVisit fileVisit) {
        File[] fileArray;
        if (dir.exists() && (fileArray = dir.listFiles()) != null && fileArray.length > 0) {
            for (File f : fileArray) {
                if (f.isDirectory()) {
                    this.traverseFile(f, fileVisit);
                    continue;
                }
                fileVisit.visit(f);
            }
        }
    }

    static interface FileVisit {
        public void visit(File var1);
    }

    private static class OfdCount {
        private int success;
        private int total;
        private StringBuilder errors = new StringBuilder();

        private OfdCount() {
        }

        public int getSuccess() {
            return this.success;
        }

        public void setSuccess(int success) {
            this.success = success;
        }

        public int getTotal() {
            return this.total;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public StringBuilder getErrors() {
            return this.errors;
        }

        public void setErrors(StringBuilder errors) {
            this.errors = errors;
        }
    }
}

