/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async;

import com.ygsoft.ecp.service.async.BASE64Decoder;
import com.ygsoft.ecp.service.async.SecurityRuntimeException;
import java.util.Arrays;

public class BASE64Encoder {
    static final int LOWER_CASE_A_VALUE = 26;
    static final int ZERO_VALUE = 52;
    static final int PLUS_VALUE = 62;
    static final int SLASH_VALUE = 63;
    private static final int SIX_BIT_MASK = 63;

    private int convertUnsignedByteToInt(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public String encode(byte[] data) {
        int charCount = data.length * 4 / 3 + 4;
        StringBuffer result = new StringBuffer(charCount * 77 / 76);
        int byteArrayLength = data.length;
        int byteArrayIndex = 0;
        int byteTriplet = 0;
        while (byteArrayIndex < byteArrayLength - 2) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byte b4 = (byte)(0x3F & (byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++])));
            byte b3 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append(this.mapByteToChar(b3));
            result.append(this.mapByteToChar(b4));
        }
        if (byteArrayIndex == byteArrayLength - 1) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b2 = (byte)(0x3F & (byteTriplet <<= 4));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append("==");
        }
        if (byteArrayIndex == byteArrayLength - 2) {
            byteTriplet = this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byteTriplet <<= 8;
            byteTriplet |= this.convertUnsignedByteToInt(data[byteArrayIndex++]);
            byte b3 = (byte)(0x3F & (byteTriplet <<= 2));
            byte b2 = (byte)(0x3F & (byteTriplet >>= 6));
            byte b1 = (byte)(0x3F & (byteTriplet >>= 6));
            result.append(this.mapByteToChar(b1));
            result.append(this.mapByteToChar(b2));
            result.append(this.mapByteToChar(b3));
            result.append("=");
        }
        return result.toString();
    }

    private char mapByteToChar(byte b) {
        if (b < 26) {
            return (char)(65 + b);
        }
        if (b < 52) {
            return (char)(97 + (b - 26));
        }
        if (b < 62) {
            return (char)(48 + (b - 52));
        }
        if (b == 62) {
            return '+';
        }
        if (b == 63) {
            return '/';
        }
        throw new SecurityRuntimeException("Byte {0} is not a valid Base64 value.", new Object[]{b});
    }

    public static void main(String[] args) throws Exception {
        BASE64Encoder encoder = new BASE64Encoder();
        BASE64Decoder decoder = new BASE64Decoder();
        for (int j = 0; j < 100; ++j) {
            byte[] test = new byte[(int)(100000.0 * Math.random())];
            for (int i = 0; i < test.length; ++i) {
                test[i] = (byte)(256.0 * Math.random());
            }
            String string = encoder.encode(test);
            byte[] result = decoder.decodeBuffer(string);
            if (Arrays.equals(test, result) && test.length == result.length) continue;
            System.out.println("ARRAYS DO NOT MATCH!");
        }
    }
}

