/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async;

import com.ygsoft.ecp.service.async.BASE64Decoder;
import com.ygsoft.ecp.service.async.BASE64Encoder;
import com.ygsoft.ecp.service.async.CryptoUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang.StringUtils;

public class CrypToUtil {
    public static final byte[] DEFAULT_DES_KEY = new byte[]{-99, 118, 97, -105, -51, -17, 81, 14};

    public static String base64Encode(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        return new BASE64Encoder().encode(bytes);
    }

    public static byte[] base64Decode(String text) {
        if (text == null) {
            return new byte[0];
        }
        return new BASE64Decoder().decodeBuffer(text);
    }

    public static String decryptByDES(String cryptograph, String keyString) {
        if (cryptograph == null) {
            return null;
        }
        byte[] bytes = CrypToUtil.base64Decode(cryptograph);
        byte[] key = DEFAULT_DES_KEY;
        if (!StringUtils.isBlank((String)keyString)) {
            key = CrypToUtil.fixToBytes(keyString, 8);
        }
        try {
            return new String(CryptoUtils.decrypt(bytes, key, CryptoUtils.DES_ALGORITHM));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptByDES(String plainText, String keyString) {
        if (plainText == null) {
            return null;
        }
        byte[] key = DEFAULT_DES_KEY;
        if (!StringUtils.isBlank((String)keyString)) {
            key = CrypToUtil.fixToBytes(keyString, 8);
        }
        try {
            byte[] cryptograph = CryptoUtils.encrypt(plainText.getBytes(), key, CryptoUtils.DES_ALGORITHM);
            return CrypToUtil.base64Encode(cryptograph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestByMD5(String text) {
        if (text == null) {
            return null;
        }
        try {
            byte[] digest = CryptoUtils.md5(text.getBytes());
            return CrypToUtil.base64Encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String digestBySHA(String text) {
        if (text == null) {
            return null;
        }
        try {
            MessageDigest alg = MessageDigest.getInstance("SHA");
            alg.update(text.getBytes());
            byte[] digest = alg.digest();
            return CrypToUtil.base64Encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static final byte[] fixToBytes(String s, int destLength) {
        byte[] bytes = s.getBytes();
        int xLength = destLength - bytes.length;
        if (xLength == 0) {
            return bytes;
        }
        if (xLength > 0) {
            byte[] result = new byte[destLength];
            System.arraycopy(bytes, 0, result, 0, bytes.length);
            return result;
        }
        byte[] result = new byte[destLength];
        System.arraycopy(bytes, 0, result, 0, destLength - 1);
        return result;
    }
}

