/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async;

import com.ygsoft.ecp.service.async.IPortableCaller;
import com.ygsoft.ecp.service.async.IPortableInput;
import com.ygsoft.ecp.service.async.IPortableResult;
import com.ygsoft.ecp.service.async.LocalMethodCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodTemplate {
    private IPortableCaller caller = null;

    public MethodTemplate(IPortableCaller caller) {
        this.caller = caller == null ? LocalMethodCaller.getInstance() : caller;
    }

    public MethodTemplate() {
        this(null);
    }

    public <T> T callMethod(Class targetClass, String methodName, Object[] params) throws Throwable {
        return this.callMethod(targetClass, methodName, null, params);
    }

    public <T> T callMethod(Class targetClass, String methodName, Class[] paramTypes, Object[] params) throws Throwable {
        IPortableInput.DefaultImpl in = new IPortableInput.DefaultImpl();
        in.setTargetClass(targetClass);
        in.setMethodName(methodName);
        in.setArguments(params);
        in.setParamTypes(paramTypes);
        in.validate();
        IPortableResult res = this.caller.call(in);
        if (res.success()) {
            return res.value();
        }
        throw res.getException();
    }

    public <T> T callMethod(Object target, String methodName, Object[] params) throws Throwable {
        return this.callMethod(target, methodName, null, params);
    }

    public <T> T callMethod(Object target, String methodName, Class[] paramTypes, Object[] params) throws Throwable {
        if (target instanceof Class) {
            return this.callMethod((Class)target, methodName, paramTypes, params);
        }
        IPortableInput.DefaultImpl in = new IPortableInput.DefaultImpl();
        in.setTarget(target);
        in.setMethodName(methodName);
        in.setArguments(params);
        in.setParamTypes(paramTypes);
        in.validate();
        IPortableResult res = this.caller.call(in);
        if (res.success()) {
            return res.value();
        }
        throw res.getException();
    }

    public <T> T callMethod(String targetClassName, String methodName, Object[] params) throws Throwable {
        return this.callMethod(targetClassName, methodName, null, params);
    }

    public <T> T callMethod(String targetClassName, String methodName, Class[] paramTypes, Object[] params) throws Throwable {
        IPortableInput.DefaultImpl in = new IPortableInput.DefaultImpl();
        in.setTargetClassName(targetClassName);
        in.setMethodName(methodName);
        in.setArguments(params);
        in.setParamTypes(paramTypes);
        in.validate();
        IPortableResult res = this.caller.call(in);
        if (res.success()) {
            return res.value();
        }
        throw res.getException();
    }

    public <T> T callMethod(IPortableInput input) throws Throwable {
        IPortableResult res = this.caller.call(input);
        if (res.success()) {
            return res.value();
        }
        throw res.getException();
    }
}

