/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Util {
    private static final Map<Class, Class> primitiveWrapperTypeMap = new HashMap<Class, Class>(8);
    private static final Map<String, Class> primitiveTypeNameMap = new HashMap<String, Class>(8);
    private static Class[] NULL_CLASSES;
    public static final Class[] EMPTY_CLASS_ARRAY;

    private static Class[] getClasses(Object[] args) {
        if (args == null || args.length == 0) {
            return NULL_CLASSES;
        }
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (null == object) {
                throw new IllegalArgumentException("the object array should not contains null");
            }
            classes[i] = object.getClass();
            if (!primitiveWrapperTypeMap.containsKey(classes[i])) continue;
            classes[i] = primitiveWrapperTypeMap.get(classes[i]);
        }
        return classes;
    }

    public static Method getMethod(Class clazz, String name, Object[] args, boolean allowSuperType) {
        Class[] classes = Util.getClasses(args);
        return Util.getMethod(clazz, name, classes, allowSuperType);
    }

    public static Method getMethod(Class clazz, String name, Class[] parameterTypes, boolean allowSuperType) {
        Method method;
        int i;
        Method[] methods = clazz.getMethods();
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!method.getName().equals(name) || !Util.isParameterEqual(method, parameterTypes, allowSuperType)) continue;
            return method;
        }
        methods = clazz.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!method.getName().equals(name) || !Util.isParameterEqual(method, parameterTypes, allowSuperType)) continue;
            return method;
        }
        return null;
    }

    public static boolean isParameterEqual(Method method, Class[] parameterTypes, boolean allowSuperType) {
        if (null == method) {
            return false;
        }
        Object[] methodParameterTypes = method.getParameterTypes();
        if (Util.isEmpty(parameterTypes) && Util.isEmpty(methodParameterTypes)) {
            return true;
        }
        if (parameterTypes.length != methodParameterTypes.length) {
            return false;
        }
        if (allowSuperType) {
            return Util.isAssignable(parameterTypes, (Class[])methodParameterTypes);
        }
        return Arrays.equals(parameterTypes, methodParameterTypes);
    }

    private static boolean isAssignable(Class[] classArray, Class[] toClassArray) {
        if (!Util.isSameLength(classArray, toClassArray)) {
            return false;
        }
        if (classArray == null) {
            classArray = EMPTY_CLASS_ARRAY;
        }
        if (toClassArray == null) {
            toClassArray = EMPTY_CLASS_ARRAY;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (Util.isAssignable(classArray[i], toClassArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Class cls, Class toClass) {
        if (toClass == null) {
            return false;
        }
        if (cls == null) {
            return !toClass.isPrimitive();
        }
        if (cls.equals(toClass)) {
            return true;
        }
        if (cls.isPrimitive()) {
            if (!toClass.isPrimitive()) {
                return false;
            }
            if (Integer.TYPE.equals(cls)) {
                return Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Long.TYPE.equals(cls)) {
                return Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Boolean.TYPE.equals(cls)) {
                return false;
            }
            if (Double.TYPE.equals(cls)) {
                return false;
            }
            if (Float.TYPE.equals(cls)) {
                return Double.TYPE.equals(toClass);
            }
            if (Character.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Short.TYPE.equals(cls)) {
                return Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            if (Byte.TYPE.equals(cls)) {
                return Short.TYPE.equals(toClass) || Integer.TYPE.equals(toClass) || Long.TYPE.equals(toClass) || Float.TYPE.equals(toClass) || Double.TYPE.equals(toClass);
            }
            return false;
        }
        return toClass.isAssignableFrom(cls);
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static boolean isSameLength(Object[] array1, Object[] array2) {
        return !(array1 == null && array2 != null && array2.length > 0 || array2 == null && array1 != null && array1.length > 0) && (array1 == null || array2 == null || array1.length == array2.length);
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Class primitiveClass : primitiveWrapperTypeMap.values()) {
            primitiveTypeNameMap.put(primitiveClass.getName(), primitiveClass);
        }
        NULL_CLASSES = new Class[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }
}

