/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.dataaccess;

import com.ygsoft.ecp.service.dataaccess.HibernateFilterEntity;
import com.ygsoft.ecp.service.dataaccess.IEntityDAO;
import com.ygsoft.ecp.service.dataaccess.IEntityMetadataService;
import com.ygsoft.ecp.service.dataaccess.IHibernateCallBack;
import com.ygsoft.ecp.service.dataaccess.IHibernateTemplate;
import com.ygsoft.ecp.service.dataaccess.ISQLTemplate;
import com.ygsoft.ecp.service.dataaccess.IStatelessSession;
import com.ygsoft.ecp.service.model.IPersistObject;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityDAO<T extends IPersistObject>
implements IEntityDAO<T> {
    private IHibernateTemplate hibernateTemplate;
    private IEntityMetadataService metadataService;
    private ISQLTemplate sqlTemplate;
    private IStatelessSession statelessSession;

    protected abstract String getEntityName();

    protected IStatelessSession getStatelessSession() {
        if (this.statelessSession == null) {
            this.statelessSession = OSGiUtil.getService(IStatelessSession.class);
            if (this.statelessSession == null) {
                throw new RuntimeException("\u670d\u52a1" + IStatelessSession.class.getName() + "\u8fd8\u672a\u53d1\u5e03\u6210\u529f!");
            }
        }
        return this.statelessSession;
    }

    public void setStatelessSession(IStatelessSession newstatelessSession) {
        this.statelessSession = newstatelessSession;
    }

    protected IHibernateTemplate getHibernateTemplate() {
        if (this.hibernateTemplate == null) {
            this.hibernateTemplate = DBUitl.getHibernateTemplate();
        }
        return this.hibernateTemplate;
    }

    @Override
    public void setHibernateTemplate(IHibernateTemplate newhibernateTemplate) {
        this.hibernateTemplate = newhibernateTemplate;
    }

    protected ISQLTemplate getSqlTemplate() {
        if (this.sqlTemplate == null) {
            this.sqlTemplate = DBUitl.getSqlTemplate();
        }
        return this.sqlTemplate;
    }

    @Override
    public void setSqlTemplate(ISQLTemplate newsqlTemplate) {
        this.sqlTemplate = newsqlTemplate;
    }

    protected IEntityMetadataService getMetadataService() {
        if (this.metadataService == null) {
            this.metadataService = OSGiUtil.getService(IEntityMetadataService.class);
            if (this.metadataService == null) {
                throw new RuntimeException("\u670d\u52a1" + IEntityMetadataService.class.getName() + "\u8fd8\u672a\u53d1\u5e03\u6210\u529f!");
            }
        }
        return this.metadataService;
    }

    public void setMetadataService(IEntityMetadataService newmetadataService) {
        this.metadataService = newmetadataService;
    }

    @Override
    public void persist(T entity) {
        this.getHibernateTemplate().persist((IPersistObject)entity);
    }

    @Override
    public void update(T entity) {
        this.getHibernateTemplate().update((IPersistObject)entity);
    }

    @Override
    public void delete(T entity) {
        this.getHibernateTemplate().delete((IPersistObject)entity);
    }

    @Override
    public void delete(Class<T> c, Serializable primaryKey) {
        this.delete(c.getName(), primaryKey);
    }

    @Override
    public T find(Class<T> entity, Serializable primaryKey) {
        return this.find(entity.getName(), primaryKey);
    }

    protected void delete(String entityName, Serializable primaryKey) {
        this.getHibernateTemplate().delete(entityName, primaryKey);
    }

    protected T find(String entityName, Serializable primaryKey) {
        return (T)this.getHibernateTemplate().find(entityName, primaryKey);
    }

    @Override
    public void persist(Collection<T> entities) {
        this.getHibernateTemplate().saveAllEntity(entities);
    }

    @Override
    public void update(Collection<T> entities) {
        this.getHibernateTemplate().updateAllEntity(entities);
    }

    @Override
    public void delete(Collection<T> entities) {
        this.getHibernateTemplate().deleteAllEntity(entities);
    }

    protected List<? extends Serializable> findAll(String entityName, int page, int pageSize) {
        return this.getHibernateTemplate().findByHQL("from " + entityName, page, pageSize, Serializable.class);
    }

    @Deprecated
    protected void delete(String entityName, Map<String, Object> keys) {
        this.getHibernateTemplate().delete(entityName, keys);
    }

    protected T find(String entityName, Map<String, Object> keys) {
        return (T)this.getHibernateTemplate().find(entityName, keys);
    }

    @Override
    public void delete(Serializable primaryKey) {
        this.getHibernateTemplate().delete(this.getEntityName(), primaryKey);
    }

    @Override
    public void delete(Map<String, Object> keys) {
        this.getHibernateTemplate().delete(this.getEntityName(), keys);
    }

    @Override
    public void deleteByPrimaryKeys(List<? extends Serializable> primaryKeys) {
        String primaryKeyProperty = this.getMetadataService().getPrimaryKeyProperty(this.getEntityName());
        this.deleteByPropertyKeys(primaryKeyProperty, primaryKeys);
    }

    @Override
    public void deleteByPropertyKeys(String propertyName, List<? extends Serializable> keys) {
        if (keys == null || keys.size() == 0 || keys.get(0) == null) {
            return;
        }
        String entityName = this.getEntityName();
        if (this.getMetadataService() != null && this.getMetadataService().getPrimaryKeyColumn(entityName).length > 1 && this.getMetadataService().getPrimaryKeyProperty(entityName).equals(keys.get(0).getClass().getName())) {
            for (Serializable serializable : keys) {
                this.getHibernateTemplate().delete(entityName, serializable);
            }
        } else {
            int batchInSize = keys.get(0).toString().length() > 10 ? 200 : 500;
            String string = "delete " + entityName + " where " + propertyName + " in (:keyList)";
            if (keys.size() <= batchInSize) {
                this.getHibernateTemplate().bulkUpdate(string, "keyList", keys);
            } else {
                int mod = keys.size() / batchInSize;
                for (int i = 0; i < mod; ++i) {
                    int fromIndex = i * batchInSize;
                    int toIndex = fromIndex + batchInSize;
                    List<? extends Serializable> subList = keys.subList(fromIndex, toIndex);
                    this.getHibernateTemplate().bulkUpdate(string, "keyList", subList);
                }
                if (keys.size() % batchInSize != 0) {
                    List<? extends Serializable> lastList = keys.subList(mod * batchInSize, keys.size());
                    this.getHibernateTemplate().bulkUpdate(string, "keyList", lastList);
                }
            }
        }
    }

    @Override
    public T find(Serializable primaryKey) {
        return (T)this.getHibernateTemplate().find(this.getEntityName(), primaryKey);
    }

    @Override
    public List<T> findByMultiKeys(List<Map<String, Object>> multiKeys) {
        if (multiKeys == null || multiKeys.size() == 0 || multiKeys.get(0) == null) {
            return Collections.emptyList();
        }
        String entityName = this.getEntityName();
        ArrayList<IPersistObject> dataList = new ArrayList<IPersistObject>();
        ArrayList<String> queryList = new ArrayList<String>();
        StringBuffer query = new StringBuffer();
        for (Map<String, Object> keyMap : multiKeys) {
            StringBuffer t = new StringBuffer();
            if (StringUtil.isNotEmptyString(query.toString())) {
                query.append(" or ");
            }
            query.append("(");
            for (Map.Entry<String, Object> entry : keyMap.entrySet()) {
                String keyName = entry.getKey();
                Object keyValue = entry.getValue();
                if (StringUtil.isNotEmptyString(t.toString())) {
                    t.append(" and ");
                }
                t.append(keyName).append(" = ");
                if (!(keyValue instanceof Number)) {
                    t.append("'");
                }
                t.append(keyMap.get(keyName));
                if (keyValue instanceof Number) continue;
                t.append("'");
            }
            if (StringUtil.isNotEmptyString(t.toString())) {
                query.append(t.toString());
            }
            query.append(")");
            if (query.length() <= 7800) continue;
            queryList.add(query.toString());
            query = new StringBuffer();
        }
        queryList.add(query.toString());
        for (String queryStr : queryList) {
            String hql = "from " + entityName + " where " + queryStr;
            dataList.addAll(this.getHibernateTemplate().findByHQLWithoutRowNumLimit(hql, IPersistObject.class));
        }
        return dataList;
    }

    @Override
    public List<T> findByPrimaryKeys(List<? extends Serializable> primaryKeys) {
        String primaryKeyProperty = this.getMetadataService().getPrimaryKeyProperty(this.getEntityName());
        return this.findByPropertyKeys(primaryKeyProperty, primaryKeys);
    }

    @Override
    public List<T> findByPropertyKeys(String propertyName, List<? extends Serializable> keys) {
        if (keys == null || keys.size() == 0 || keys.get(0) == null) {
            return Collections.EMPTY_LIST;
        }
        String entityName = this.getEntityName();
        ArrayList<IPersistObject> dataList = new ArrayList<IPersistObject>();
        if (this.getMetadataService() != null && this.getMetadataService().getPrimaryKeyColumn(entityName).length > 1 && this.getMetadataService().getPrimaryKeyProperty(entityName).equals(keys.get(0).getClass().getName())) {
            for (Serializable serializable : keys) {
                dataList.add(this.getHibernateTemplate().find(entityName, serializable));
            }
            return dataList;
        }
        int batchInSize = keys.get(0).toString().length() > 10 ? 200 : 500;
        String string = "from " + entityName + " where " + propertyName + " in (:keyList)";
        if (keys.size() <= batchInSize) {
            return this.getHibernateTemplate().findByHQLWithoutRowNumLimit(string, "keyList", keys, IPersistObject.class);
        }
        int mod = keys.size() / batchInSize;
        for (int i = 0; i < mod; ++i) {
            int fromIndex = i * batchInSize;
            int toIndex = fromIndex + batchInSize;
            List<? extends Serializable> subList = keys.subList(fromIndex, toIndex);
            dataList.addAll(this.getHibernateTemplate().findByHQLWithoutRowNumLimit(string, "keyList", subList, IPersistObject.class));
        }
        if (keys.size() % batchInSize != 0) {
            List<? extends Serializable> lastList = keys.subList(mod * batchInSize, keys.size());
            dataList.addAll(this.getHibernateTemplate().findByHQLWithoutRowNumLimit(string, "keyList", lastList, IPersistObject.class));
        }
        return dataList;
    }

    @Override
    public T find(Map<String, Object> keys) {
        return (T)this.getHibernateTemplate().find(this.getEntityName(), keys);
    }

    public T merge(T entity) {
        return this.getHibernateTemplate().merge(entity);
    }

    @Override
    public void evict(T entity) {
        this.getHibernateTemplate().evict((IPersistObject)entity);
    }

    @Override
    public Object doInHibernate(IHibernateCallBack callback) {
        return this.getHibernateTemplate().doInHibernate(this.getEntityName(), callback);
    }

    @Override
    public void addFilter(HibernateFilterEntity ... filters) {
        this.getHibernateTemplate().addFilter(filters);
    }

    @Override
    public void removeFilter(String ... filterNames) {
        this.getHibernateTemplate().removeFilter(filterNames);
    }

    @Override
    public List<T> findAll(int page, int pageSize) {
        List<Serializable> data = this.findAll(this.getEntityName(), page, pageSize);
        if (data != null && data.size() > 0) {
            ArrayList<IPersistObject> dataList = new ArrayList<IPersistObject>();
            Iterator<Serializable> it = data.iterator();
            while (it.hasNext()) {
                dataList.add((IPersistObject)it.next());
            }
            return dataList;
        }
        return Collections.emptyList();
    }

    @Override
    public List<T> findByExample(T example, int page, int pageSize) {
        return this.getHibernateTemplate().findByExample(example, page, pageSize);
    }

    @Override
    public List<T> findByCondition(String hql, Map<String, Object> params, int page, int pageSize, Class<T> entity) {
        return this.getHibernateTemplate().findByHQL(hql, params, page, pageSize, entity);
    }
}

