/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.dataaccess;

import com.ygsoft.ecp.service.dataaccess.PreparedSqlEntity;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public final class PreparedSqlParser {
    private static final Set<String> SQL_PROPARED_CHECK_TOKENS = new HashSet<String>();
    public static final String WHITESPACE = " \n\r\f\t";

    private PreparedSqlParser() {
    }

    public static PreparedSqlEntity parseSql(String sql) {
        PreparedSqlEntity entity = new PreparedSqlEntity();
        StringBuilder preparedSql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] tokens = PreparedSqlParser.split(" \n\r\f\t(),", sql, true);
        String last = null;
        int nextIndex = 0;
        String next = null;
        int j = 0;
        boolean isIn = false;
        block0: for (int i = 1; i < tokens.length; ++i) {
            String token;
            if (!PreparedSqlParser.isWhitespace(tokens[i - 1])) {
                last = tokens[i - 1].toLowerCase();
            }
            if (PreparedSqlParser.isWhitespace(token = tokens[i]) && last != null || nextIndex > i) continue;
            for (nextIndex = i + 1; nextIndex < tokens.length; ++nextIndex) {
                char c;
                next = tokens[nextIndex].toLowerCase();
                if (PreparedSqlParser.isWhitespace(next)) continue;
                if (!SQL_PROPARED_CHECK_TOKENS.contains(token)) continue block0;
                isIn = "in".equals(token);
                if (isIn) {
                    next = tokens[nextIndex + 1];
                }
                if (((c = next.charAt(0)) < '0' || c > '9') && c != '\'') continue block0;
                String p = "p" + j;
                params.put(p, next);
                if (isIn) {
                    tokens[nextIndex + 1] = ":" + p;
                } else {
                    tokens[nextIndex] = ":" + p;
                }
                ++j;
                continue block0;
            }
        }
        for (String token : tokens) {
            preparedSql.append(token);
        }
        entity.setPreparedSql(preparedSql.toString());
        entity.setParams(params);
        return entity;
    }

    private static String[] split(String seperators, String list, boolean include) {
        StringTokenizer tokens = new StringTokenizer(list, seperators, include);
        String[] result = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            result[i++] = tokens.nextToken();
        }
        return result;
    }

    private static boolean isWhitespace(String str) {
        return WHITESPACE.indexOf(str) > -1;
    }

    static {
        SQL_PROPARED_CHECK_TOKENS.add("=");
        SQL_PROPARED_CHECK_TOKENS.add("like");
        SQL_PROPARED_CHECK_TOKENS.add("in");
        SQL_PROPARED_CHECK_TOKENS.add(">");
        SQL_PROPARED_CHECK_TOKENS.add("<");
    }
}

