/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.entity;

import com.ygsoft.ecp.framework.model.dynamic.IDynamicModel;
import com.ygsoft.ecp.service.dataaccess.IHibernateTemplate;
import com.ygsoft.ecp.service.dataaccess.SessionFactoryManager;
import com.ygsoft.ecp.service.dataaccess.exception.DataaccessException;
import com.ygsoft.ecp.service.entity.DynamicEntity;
import com.ygsoft.ecp.service.model.IPersistObject;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.DBUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.ASTQueryTranslatorFactory;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.proxy.HibernateProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityHelper {
    private static final Logger LOG = LoggerFactory.getLogger(EntityHelper.class);
    public static final int NEW = 4;
    public static final int MODIFY = 8;
    public static final int CHILD_MODIFY = 64;
    public static final int DELETE = 2;
    private static IHibernateTemplate hibernateTemplate;

    private EntityHelper() {
    }

    public static String generateEntityName(String classID, String typeID) {
        if (StringUtil.isEmptyString(classID)) {
            throw new DataaccessException("\u52a8\u6001\u5b9e\u4f53\u7ed9\u5b9aclassID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (classID.indexOf("_") >= 0) {
            throw new DataaccessException("\u52a8\u6001\u5b9e\u4f53\u7ed9\u5b9aclassID\u4e0d\u80fd\u5305\u542b\u4e0b\u5212\u7ebf!");
        }
        if (!StringUtil.isEmptyString(typeID)) {
            return (classID + "_" + typeID).toLowerCase();
        }
        return classID;
    }

    public static String generateEntityName(Class<? extends IPersistObject> entityCls) {
        return entityCls.getName();
    }

    public static String getEntityName(IPersistObject entity) {
        Object entityManagerFactory;
        Object value;
        Session currentsession;
        StatefulPersistenceContext context;
        SessionFactory sf;
        String entityName = null;
        entityName = entity instanceof HibernateProxy ? ((HibernateProxy)entity).getHibernateLazyInitializer().getEntityName() : (entity instanceof DynamicEntity || entity instanceof IDynamicModel ? ((sf = SessionFactoryManager.INSTANCE.getFactoryForTransactionSync()) != null ? ((context = (StatefulPersistenceContext)ClassUtil.getFieldValue(currentsession = (value = TransactionSynchronizationManager.getResource((Object)(entityManagerFactory = OSGiUtil.getSpringBean("entityManagerFactory")))) instanceof EntityManagerHolder && DBUitl.isbindJpaTransaction() ? (Session)((EntityManagerHolder)value).getEntityManager().unwrap(Session.class) : sf.getCurrentSession(), "persistenceContext")).isEntryFor((Object)entity) ? context.getEntry((Object)entity).getEntityName() : (entity instanceof IDynamicModel ? String.valueOf(ClassUtil.callMethod(entity, "getEntityName", new Object[0])) : ((DynamicEntity)entity).getEntityName())) : (entity instanceof IDynamicModel ? String.valueOf(ClassUtil.callMethod(entity, "getEntityName", new Object[0])) : ((DynamicEntity)entity).getEntityName())) : entity.getClass().getName());
        if (entityName == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error("EntityName Can't be null!");
            }
            throw new DataaccessException("EntityName Can't be null!");
        }
        return entityName;
    }

    public static <T extends IPersistObject> T rebuildPO(int modelState, Serializable primaryKey, Class<T> entity) {
        return EntityHelper.rebuildPO(modelState, primaryKey, entity.getName());
    }

    public static <T extends IPersistObject> T rebuildPO(int modelState, Serializable primaryKey, String entityName) {
        if (primaryKey == null) {
            return null;
        }
        if ((modelState & 4) != 4 && ((modelState & 2) == 2 || (modelState & 8) == 8 || (modelState & 0x40) == 64)) {
            return (T)EntityHelper.getHibernateTemplate().find(entityName, primaryKey);
        }
        IHibernateTemplate hibernateTemplate = DBUtil.getHibernateTemplate();
        try {
            Object entity = ClassUtil.createObject(entityName);
            hibernateTemplate.setIdentifier((IPersistObject)entity, primaryKey);
            Map<String, ?> ids = hibernateTemplate.getEntityIdentifier((IPersistObject)entity);
            if (ids.size() > 1) {
                return (T)((IPersistObject)primaryKey);
            }
            return (T)((IPersistObject)entity);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String hqlToSql(String hqlQueryText) {
        if (hqlQueryText != null && hqlQueryText.trim().length() > 0) {
            IHibernateTemplate hibernateTemplate = DBUtil.getHibernateTemplate();
            SessionFactory sessionFactory = (SessionFactory)ClassUtil.getAttribute(hibernateTemplate, "defaultSessionFactory");
            ASTQueryTranslatorFactory translatorFactory = new ASTQueryTranslatorFactory();
            SessionFactoryImplementor factory = (SessionFactoryImplementor)sessionFactory;
            QueryTranslator translator = translatorFactory.createQueryTranslator(hqlQueryText, hqlQueryText, Collections.EMPTY_MAP, factory, null);
            translator.compile(Collections.EMPTY_MAP, false);
            return translator.getSQLString();
        }
        return null;
    }

    public static void setHibernateTemplate(IHibernateTemplate newhibernateTemplate) {
        hibernateTemplate = newhibernateTemplate;
    }

    private static IHibernateTemplate getHibernateTemplate() {
        if (hibernateTemplate == null) {
            hibernateTemplate = DBUitl.getHibernateTemplate();
        }
        return hibernateTemplate;
    }

    public static String renderSqlFunction(String functionName, Object ... args) {
        SessionFactoryImplementor sfi = (SessionFactoryImplementor)SessionFactoryManager.INSTANCE.getFactory();
        Map functions = sfi.getDialect().getFunctions();
        SQLFunction function = (SQLFunction)functions.get(functionName.toLowerCase());
        if (function != null) {
            return function.render(null, Arrays.asList(args), sfi);
        }
        return null;
    }
}

